/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.cldr.impl;

import org.gwtproject.i18n.shared.cldr.LocalizedNamesImplBase;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "fa_AF" locale.
 */
public class LocalizedNamesImpl_fa_AF extends LocalizedNamesImpl_fa {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "XA",
        "XB",
        "AW",
        "DE",
        "AI",
        "IE",
        "IS",
        "EU",
        "AT",
        "AR",
        "JO",
        "AM",
        "ER",
        "UZ",
        "AU",
        "EE",
        "IL",
        "SJ",
        "ZA",
        "AF",
        "AL",
        "DZ",
        "SV",
        "AE",
        "AQ",
        "AG",
        "AD",
        "ID",
        "AO",
        "UA",
        "EC",
        "US",
        "IT",
        "ET",
        "IR",
        "BB",
        "BH",
        "QO",
        "BR",
        "BM",
        "BN",
        "GB",
        "BY",
        "BE",
        "BG",
        "BZ",
        "BD",
        "BJ",
        "BS",
        "BT",
        "BW",
        "BI",
        "BF",
        "BA",
        "BO",
        "TJ",
        "TZ",
        "TH",
        "TW",
        "TM",
        "TR",
        "TA",
        "TT",
        "TN",
        "TO",
        "TV",
        "TK",
        "TG",
        "TL",
        "JM",
        "JP",
        "GI",
        "JE",
        "AC",
        "AX",
        "TC",
        "GS",
        "UM",
        "SB",
        "FO",
        "FK",
        "IC",
        "MH",
        "MP",
        "VI",
        "VG",
        "PN",
        "BQ",
        "CP",
        "CK",
        "CC",
        "KY",
        "BV",
        "IM",
        "NF",
        "HM",
        "CX",
        "AZ",
        "CF",
        "DO",
        "DJ",
        "DK",
        "DM",
        "DG",
        "RE",
        "RW",
        "RU",
        "RO",
        "ZM",
        "NZ",
        "ZW",
        "EA",
        "ST",
        "CI",
        "UN",
        "WS",
        "AS",
        "SM",
        "TF",
        "PS",
        "LK",
        "SK",
        "SI",
        "BL",
        "LC",
        "SX",
        "MF",
        "SH",
        "VC",
        "KN",
        "PM",
        "SZ",
        "SD",
        "SS",
        "SR",
        "SY",
        "SO",
        "SE",
        "CH",
        "SL",
        "SC",
        "SG",
        "SN",
        "EH",
        "RS",
        "IQ",
        "SA",
        "OM",
        "FR",
        "FI",
        "FJ",
        "PH",
        "CY",
        "KG",
        "KZ",
        "QA",
        "IO",
        "LA",
        "LV",
        "LB",
        "LT",
        "LU",
        "LR",
        "LY",
        "LI",
        "LS",
        "MG",
        "MQ",
        "MW",
        "MT",
        "MV",
        "ML",
        "MY",
        "MO",
        "YT",
        "HU",
        "MA",
        "EG",
        "MK",
        "EZ",
        "MN",
        "MR",
        "MU",
        "MZ",
        "MD",
        "MC",
        "MS",
        "ME",
        "MX",
        "MM",
        "FM",
        "NR",
        "NO",
        "NA",
        "NE",
        "NG",
        "NU",
        "NP",
        "NI",
        "NL",
        "HN",
        "HK",
        "HT",
        "ES",
        "IN",
        "VA",
        "WF",
        "VU",
        "VE",
        "VN",
        "PY",
        "PW",
        "PA",
        "PG",
        "PK",
        "PT",
        "PF",
        "PR",
        "PL",
        "PE",
        "TD",
        "CL",
        "CZ",
        "CN",
        "CR",
        "NC",
        "CM",
        "CA",
        "CG",
        "CD",
        "HR",
        "KH",
        "CW",
        "KR",
        "KP",
        "XK",
        "CO",
        "KM",
        "KW",
        "KI",
        "KE",
        "CU",
        "CV",
        "GA",
        "GM",
        "GH",
        "GE",
        "GG",
        "GD",
        "GL",
        "GT",
        "GP",
        "GU",
        "GF",
        "GY",
        "GN",
        "GQ",
        "GW",
        "YE",
        "UY",
        "GR",
        "UG",
    };
  }

  @Override
  protected void loadNameMap() {
    super.loadNameMap();
    namesMap.put("AD", "اندورا");
    namesMap.put("AG", "انتیگوا و باربودا");
    namesMap.put("AL", "البانیا");
    namesMap.put("AO", "انگولا");
    namesMap.put("AQ", "انترکتیکا");
    namesMap.put("AR", "ارجنتاین");
    namesMap.put("BA", "بوسنیا و هرزه‌گوینا");
    namesMap.put("BD", "بنگله‌دیش");
    namesMap.put("BE", "بلجیم");
    namesMap.put("BG", "بلغاریا");
    namesMap.put("BN", "برونی");
    namesMap.put("BO", "بولیویا");
    namesMap.put("BR", "برازیل");
    namesMap.put("BS", "بهاماس");
    namesMap.put("CD", "کانگو - کینشاسا");
    namesMap.put("CG", "کانگو - برازویل");
    namesMap.put("CH", "سویس");
    namesMap.put("CL", "چلی");
    namesMap.put("CO", "کولمبیا");
    namesMap.put("CR", "کاستریکا");
    namesMap.put("CU", "کیوبا");
    namesMap.put("CZ", "چک");
    namesMap.put("DK", "دنمارک");
    namesMap.put("EA", "سئوتا و ملیلا");
    namesMap.put("EE", "استونیا");
    namesMap.put("ER", "اریتریا");
    namesMap.put("ES", "هسپانیه");
    namesMap.put("ET", "ایتوپیا");
    namesMap.put("FI", "فنلند");
    namesMap.put("FM", "میکرونزیا");
    namesMap.put("GD", "گرینادا");
    namesMap.put("GH", "گانا");
    namesMap.put("GN", "گینیا");
    namesMap.put("GQ", "گینیا استوایی");
    namesMap.put("GT", "گواتیمالا");
    namesMap.put("GW", "گینیا بیسائو");
    namesMap.put("GY", "گیانا");
    namesMap.put("HK", "هانگ کانگ، ناحیهٔ ویژهٔ حکومتی چین");
    namesMap.put("HN", "هاندوراس");
    namesMap.put("HR", "کروشیا");
    namesMap.put("HT", "هایتی");
    namesMap.put("ID", "اندونیزیا");
    namesMap.put("IE", "آیرلند");
    namesMap.put("IS", "آیسلند");
    namesMap.put("JP", "جاپان");
    namesMap.put("KE", "کینیا");
    namesMap.put("KH", "کمپوچیا");
    namesMap.put("KP", "کوریای شمالی");
    namesMap.put("KR", "کوریای جنوبی");
    namesMap.put("LK", "سریلانکا");
    namesMap.put("LS", "لیسوتو");
    namesMap.put("LT", "لتوانیا");
    namesMap.put("LV", "لاتویا");
    namesMap.put("LY", "لیبیا");
    namesMap.put("MG", "مادغاسکر");
    namesMap.put("MN", "منگولیا");
    namesMap.put("MR", "موریتانیا");
    namesMap.put("MT", "مالتا");
    namesMap.put("MX", "مکسیکو");
    namesMap.put("MY", "مالیزیا");
    namesMap.put("MZ", "موزمبیق");
    namesMap.put("NG", "نیجریا");
    namesMap.put("NI", "نیکاراگوا");
    namesMap.put("NL", "هالند");
    namesMap.put("NO", "ناروی");
    namesMap.put("NP", "نیپال");
    namesMap.put("NZ", "زیلاند جدید");
    namesMap.put("PA", "پانامه");
    namesMap.put("PE", "پیرو");
    namesMap.put("PG", "پاپوا نیو گینیا");
    namesMap.put("PL", "پولند");
    namesMap.put("PT", "پرتگال");
    namesMap.put("PY", "پاراگوای");
    namesMap.put("RO", "رومانیا");
    namesMap.put("SE", "سویدن");
    namesMap.put("SG", "سینگاپور");
    namesMap.put("SI", "سلونیا");
    namesMap.put("SJ", "اسوالبارد و جان ماین");
    namesMap.put("SK", "سلواکیا");
    namesMap.put("SL", "سیرالیون");
    namesMap.put("SN", "سینیگال");
    namesMap.put("SO", "سومالیه");
    namesMap.put("SV", "السلوادور");
    namesMap.put("TJ", "تاجکستان");
    namesMap.put("UG", "یوگاندا");
    namesMap.put("UY", "یوروگوای");
    namesMap.put("VC", "سنت وینسنت و گرنادین‌ها");
    namesMap.put("VE", "ونزویلا");
    namesMap.put("XK", "کوسوا");
    namesMap.put("ZW", "زیمبابوی");
  }

}
