/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.cldr.impl;

import org.gwtproject.i18n.shared.cldr.LocalizedNamesImplBase;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "pa" locale.
 */
public class LocalizedNamesImpl_pa extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "IN",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "XA",
        "XB",
        "AZ",
        "AF",
        "AS",
        "AR",
        "AM",
        "AW",
        "DZ",
        "AL",
        "SV",
        "AX",
        "AC",
        "AI",
        "AO",
        "AQ",
        "AD",
        "IE",
        "IM",
        "IS",
        "QO",
        "AT",
        "AU",
        "EC",
        "IL",
        "IT",
        "ET",
        "IQ",
        "ER",
        "EE",
        "ID",
        "IR",
        "UZ",
        "UY",
        "KP",
        "MP",
        "AG",
        "OM",
        "KZ",
        "QA",
        "HR",
        "CP",
        "CD",
        "CG",
        "CU",
        "KG",
        "KI",
        "KE",
        "CW",
        "KW",
        "CK",
        "CF",
        "IC",
        "CV",
        "KY",
        "CA",
        "CM",
        "BQ",
        "CC",
        "CI",
        "KM",
        "CO",
        "CR",
        "XK",
        "CX",
        "KH",
        "GA",
        "GG",
        "GN",
        "GW",
        "GT",
        "GP",
        "GU",
        "GY",
        "GM",
        "GL",
        "GR",
        "GD",
        "GH",
        "TD",
        "CL",
        "CN",
        "CZ",
        "JP",
        "JM",
        "DE",
        "JE",
        "ZM",
        "ZW",
        "DJ",
        "GE",
        "JO",
        "GI",
        "TN",
        "TC",
        "TV",
        "TK",
        "TG",
        "TO",
        "TT",
        "TA",
        "DG",
        "DK",
        "DM",
        "DO",
        "TZ",
        "TW",
        "TJ",
        "TL",
        "TM",
        "TR",
        "TH",
        "KR",
        "SS",
        "ZA",
        "GS",
        "NE",
        "NG",
        "NR",
        "NA",
        "NO",
        "NC",
        "NZ",
        "NI",
        "NU",
        "NL",
        "NP",
        "NF",
        "PA",
        "PW",
        "PK",
        "PG",
        "PR",
        "PN",
        "PT",
        "PE",
        "PY",
        "PL",
        "EH",
        "GF",
        "TF",
        "PF",
        "FR",
        "FK",
        "FJ",
        "FI",
        "PH",
        "PS",
        "FO",
        "IO",
        "BM",
        "BN",
        "BS",
        "BH",
        "BB",
        "BF",
        "BI",
        "BG",
        "BJ",
        "BY",
        "BZ",
        "BE",
        "BW",
        "BO",
        "BA",
        "BV",
        "BR",
        "VG",
        "BD",
        "IN",
        "GQ",
        "BT",
        "MO",
        "MW",
        "MY",
        "FM",
        "YT",
        "MQ",
        "MH",
        "MT",
        "MV",
        "ML",
        "MM",
        "EG",
        "MK",
        "MX",
        "MG",
        "MS",
        "ME",
        "MZ",
        "MC",
        "MR",
        "MA",
        "MD",
        "MU",
        "MN",
        "YE",
        "UM",
        "VI",
        "UA",
        "UG",
        "GB",
        "EU",
        "EZ",
        "RW",
        "RE",
        "RU",
        "RO",
        "LU",
        "LR",
        "LA",
        "LV",
        "LI",
        "LT",
        "LY",
        "LS",
        "LB",
        "VU",
        "WF",
        "VN",
        "VE",
        "VA",
        "ES",
        "RS",
        "SK",
        "SI",
        "SZ",
        "SJ",
        "CH",
        "SE",
        "CY",
        "SA",
        "ST",
        "WS",
        "SL",
        "EA",
        "SG",
        "SX",
        "SY",
        "SD",
        "SR",
        "KN",
        "PM",
        "BL",
        "MF",
        "LC",
        "VC",
        "SH",
        "SN",
        "SC",
        "SM",
        "SO",
        "SB",
        "LK",
        "AE",
        "US",
        "UN",
        "HM",
        "HK",
        "HT",
        "HN",
        "HU",
    };
  }

  @Override
  protected void loadNameMap() {
    super.loadNameMap();
    namesMap.put("001", "ਸੰਸਾਰ");
    namesMap.put("002", "ਅਫ਼ਰੀਕਾ");
    namesMap.put("003", "ਉੱਤਰ ਅਮਰੀਕਾ");
    namesMap.put("005", "ਦੱਖਣ ਅਮਰੀਕਾ");
    namesMap.put("009", "ਓਸ਼ੇਨੀਆ");
    namesMap.put("011", "ਪੱਛਮੀ ਅਫ਼ਰੀਕਾ");
    namesMap.put("013", "ਕੇਂਦਰੀ ਅਮਰੀਕਾ");
    namesMap.put("014", "ਪੂਰਬੀ ਅਫ਼ਰੀਕਾ");
    namesMap.put("015", "ਉੱਤਰੀ ਅਫ਼ਰੀਕਾ");
    namesMap.put("017", "ਮੱਧ ਅਫ਼ਰੀਕਾ");
    namesMap.put("018", "ਦੱਖਣੀ ਅਫ਼ਰੀਕਾ");
    namesMap.put("019", "ਅਮਰੀਕਾ");
    namesMap.put("021", "ਉੱਤਰੀ ਅਮਰੀਕਾ");
    namesMap.put("029", "ਕੈਰੇਬੀਆਈ");
    namesMap.put("030", "ਪੂਰਬੀ ਏਸ਼ੀਆ");
    namesMap.put("034", "ਦੱਖਣੀ ਏਸ਼ੀਆ");
    namesMap.put("035", "ਦੱਖਣ-ਪੂਰਬੀ ਏਸ਼ੀਆ");
    namesMap.put("039", "ਦੱਖਣੀ ਯੂਰਪ");
    namesMap.put("053", "ਆਸਟਰੇਲੇਸ਼ੀਆ");
    namesMap.put("054", "ਮੇਲਾਨੇਸ਼ੀਆ");
    namesMap.put("057", "ਮਾਇਕ੍ਰੋਨੇਸ਼ੀਆਈ ਇਲਾਕਾ");
    namesMap.put("061", "ਪੋਲੀਨੇਸ਼ੀਆ");
    namesMap.put("142", "ਏਸ਼ੀਆ");
    namesMap.put("143", "ਕੇਂਦਰੀ ਏਸ਼ੀਆ");
    namesMap.put("145", "ਪੱਛਮੀ ਏਸ਼ੀਆ");
    namesMap.put("150", "ਯੂਰਪ");
    namesMap.put("151", "ਪੂਰਬੀ ਯੂਰਪ");
    namesMap.put("154", "ਉੱਤਰੀ ਯੂਰਪ");
    namesMap.put("155", "ਪੱਛਮੀ ਯੂਰਪ");
    namesMap.put("202", "ਉਪ-ਸਹਾਰਾ ਅਫ਼ਰੀਕਾ");
    namesMap.put("419", "ਲਾਤੀਨੀ ਅਮਰੀਕਾ");
    namesMap.put("AC", "ਅਸੈਂਸ਼ਨ ਟਾਪੂ");
    namesMap.put("AD", "ਅੰਡੋਰਾ");
    namesMap.put("AE", "ਸੰਯੁਕਤ ਅਰਬ ਅਮੀਰਾਤ");
    namesMap.put("AF", "ਅਫ਼ਗਾਨਿਸਤਾਨ");
    namesMap.put("AG", "ਐਂਟੀਗੁਆ ਅਤੇ ਬਾਰਬੁਡਾ");
    namesMap.put("AI", "ਅੰਗੁਇਲਾ");
    namesMap.put("AL", "ਅਲਬਾਨੀਆ");
    namesMap.put("AM", "ਅਰਮੀਨੀਆ");
    namesMap.put("AO", "ਅੰਗੋਲਾ");
    namesMap.put("AQ", "ਅੰਟਾਰਕਟਿਕਾ");
    namesMap.put("AR", "ਅਰਜਨਟੀਨਾ");
    namesMap.put("AS", "ਅਮੈਰੀਕਨ ਸਮੋਆ");
    namesMap.put("AT", "ਆਸਟਰੀਆ");
    namesMap.put("AU", "ਆਸਟ੍ਰੇਲੀਆ");
    namesMap.put("AW", "ਅਰੂਬਾ");
    namesMap.put("AX", "ਅਲੈਂਡ ਟਾਪੂ");
    namesMap.put("AZ", "ਅਜ਼ਰਬਾਈਜਾਨ");
    namesMap.put("BA", "ਬੋਸਨੀਆ ਅਤੇ ਹਰਜ਼ੇਗੋਵੀਨਾ");
    namesMap.put("BB", "ਬਾਰਬਾਡੋਸ");
    namesMap.put("BD", "ਬੰਗਲਾਦੇਸ਼");
    namesMap.put("BE", "ਬੈਲਜੀਅਮ");
    namesMap.put("BF", "ਬੁਰਕੀਨਾ ਫ਼ਾਸੋ");
    namesMap.put("BG", "ਬੁਲਗਾਰੀਆ");
    namesMap.put("BH", "ਬਹਿਰੀਨ");
    namesMap.put("BI", "ਬੁਰੁੰਡੀ");
    namesMap.put("BJ", "ਬੇਨਿਨ");
    namesMap.put("BL", "ਸੇਂਟ ਬਾਰਥੇਲੇਮੀ");
    namesMap.put("BM", "ਬਰਮੂਡਾ");
    namesMap.put("BN", "ਬਰੂਨੇਈ");
    namesMap.put("BO", "ਬੋਲੀਵੀਆ");
    namesMap.put("BQ", "ਕੈਰੇਬੀਆਈ ਨੀਦਰਲੈਂਡ");
    namesMap.put("BR", "ਬ੍ਰਾਜ਼ੀਲ");
    namesMap.put("BS", "ਬਹਾਮਾਸ");
    namesMap.put("BT", "ਭੂਟਾਨ");
    namesMap.put("BV", "ਬੌਵੇਟ ਟਾਪੂ");
    namesMap.put("BW", "ਬੋਤਸਵਾਨਾ");
    namesMap.put("BY", "ਬੇਲਾਰੂਸ");
    namesMap.put("BZ", "ਬੇਲੀਜ਼");
    namesMap.put("CA", "ਕੈਨੇਡਾ");
    namesMap.put("CC", "ਕੋਕੋਸ (ਕੀਲਿੰਗ) ਟਾਪੂ");
    namesMap.put("CD", "ਕਾਂਗੋ - ਕਿੰਸ਼ਾਸਾ");
    namesMap.put("CF", "ਕੇਂਦਰੀ ਅਫ਼ਰੀਕੀ ਗਣਰਾਜ");
    namesMap.put("CG", "ਕਾਂਗੋ - ਬ੍ਰਾਜ਼ਾਵਿਲੇ");
    namesMap.put("CH", "ਸਵਿਟਜ਼ਰਲੈਂਡ");
    namesMap.put("CI", "ਕੋਟ ਡੀਵੋਆਰ");
    namesMap.put("CK", "ਕੁੱਕ ਟਾਪੂ");
    namesMap.put("CL", "ਚਿਲੀ");
    namesMap.put("CM", "ਕੈਮਰੂਨ");
    namesMap.put("CN", "ਚੀਨ");
    namesMap.put("CO", "ਕੋਲੰਬੀਆ");
    namesMap.put("CP", "ਕਲਿੱਪਰਟਨ ਟਾਪੂ");
    namesMap.put("CR", "ਕੋਸਟਾ ਰੀਕਾ");
    namesMap.put("CU", "ਕਿਊਬਾ");
    namesMap.put("CV", "ਕੇਪ ਵਰਡੇ");
    namesMap.put("CW", "ਕੁਰਾਕਾਓ");
    namesMap.put("CX", "ਕ੍ਰਿਸਮਿਸ ਟਾਪੂ");
    namesMap.put("CY", "ਸਾਇਪ੍ਰਸ");
    namesMap.put("CZ", "ਚੈਕੀਆ");
    namesMap.put("DE", "ਜਰਮਨੀ");
    namesMap.put("DG", "ਡੀਇਗੋ ਗਾਰਸੀਆ");
    namesMap.put("DJ", "ਜ਼ੀਬੂਤੀ");
    namesMap.put("DK", "ਡੈਨਮਾਰਕ");
    namesMap.put("DM", "ਡੋਮੀਨਿਕਾ");
    namesMap.put("DO", "ਡੋਮੀਨਿਕਾਈ ਗਣਰਾਜ");
    namesMap.put("DZ", "ਅਲਜੀਰੀਆ");
    namesMap.put("EA", "ਸਿਓਟਾ ਅਤੇ ਮੇਲਿੱਲਾ");
    namesMap.put("EC", "ਇਕਵੇਡੋਰ");
    namesMap.put("EE", "ਇਸਟੋਨੀਆ");
    namesMap.put("EG", "ਮਿਸਰ");
    namesMap.put("EH", "ਪੱਛਮੀ ਸਹਾਰਾ");
    namesMap.put("ER", "ਇਰੀਟ੍ਰਿਆ");
    namesMap.put("ES", "ਸਪੇਨ");
    namesMap.put("ET", "ਇਥੋਪੀਆ");
    namesMap.put("EU", "ਯੂਰਪੀ ਸੰਘ");
    namesMap.put("EZ", "ਯੂਰੋਜ਼ੋਨ");
    namesMap.put("FI", "ਫਿਨਲੈਂਡ");
    namesMap.put("FJ", "ਫ਼ਿਜੀ");
    namesMap.put("FK", "ਫ਼ਾਕਲੈਂਡ ਟਾਪੂ");
    namesMap.put("FM", "ਮਾਇਕ੍ਰੋਨੇਸ਼ੀਆ");
    namesMap.put("FO", "ਫੈਰੋ ਟਾਪੂ");
    namesMap.put("FR", "ਫ਼ਰਾਂਸ");
    namesMap.put("GA", "ਗਬੋਨ");
    namesMap.put("GB", "ਯੂਨਾਈਟਡ ਕਿੰਗਡਮ");
    namesMap.put("GD", "ਗ੍ਰੇਨਾਡਾ");
    namesMap.put("GE", "ਜਾਰਜੀਆ");
    namesMap.put("GF", "ਫਰੈਂਚ ਗੁਇਆਨਾ");
    namesMap.put("GG", "ਗਰਨਜੀ");
    namesMap.put("GH", "ਘਾਨਾ");
    namesMap.put("GI", "ਜਿਬਰਾਲਟਰ");
    namesMap.put("GL", "ਗ੍ਰੀਨਲੈਂਡ");
    namesMap.put("GM", "ਗੈਂਬੀਆ");
    namesMap.put("GN", "ਗਿਨੀ");
    namesMap.put("GP", "ਗੁਆਡੇਲੋਪ");
    namesMap.put("GQ", "ਭੂ-ਖੰਡੀ ਗਿਨੀ");
    namesMap.put("GR", "ਗ੍ਰੀਸ");
    namesMap.put("GS", "ਦੱਖਣੀ ਜਾਰਜੀਆ ਅਤੇ ਦੱਖਣੀ ਸੈਂਡਵਿਚ ਟਾਪੂ");
    namesMap.put("GT", "ਗੁਆਟੇਮਾਲਾ");
    namesMap.put("GU", "ਗੁਆਮ");
    namesMap.put("GW", "ਗਿਨੀ-ਬਿਸਾਉ");
    namesMap.put("GY", "ਗੁਯਾਨਾ");
    namesMap.put("HK", "ਹਾਂਗ ਕਾਂਗ ਐਸਏਆਰ ਚੀਨ");
    namesMap.put("HM", "ਹਰਡ ਤੇ ਮੈਕਡੋਨਾਲਡ ਟਾਪੂ");
    namesMap.put("HN", "ਹੋਂਡੁਰਸ");
    namesMap.put("HR", "ਕਰੋਏਸ਼ੀਆ");
    namesMap.put("HT", "ਹੈਤੀ");
    namesMap.put("HU", "ਹੰਗਰੀ");
    namesMap.put("IC", "ਕੇਨਾਰੀ ਟਾਪੂ");
    namesMap.put("ID", "ਇੰਡੋਨੇਸ਼ੀਆ");
    namesMap.put("IE", "ਆਇਰਲੈਂਡ");
    namesMap.put("IL", "ਇਜ਼ਰਾਈਲ");
    namesMap.put("IM", "ਆਇਲ ਆਫ ਮੈਨ");
    namesMap.put("IN", "ਭਾਰਤ");
    namesMap.put("IO", "ਬਰਤਾਨਵੀ ਹਿੰਦ ਮਹਾਂਸਾਗਰ ਖਿੱਤਾ");
    namesMap.put("IQ", "ਇਰਾਕ");
    namesMap.put("IR", "ਈਰਾਨ");
    namesMap.put("IS", "ਆਈਸਲੈਂਡ");
    namesMap.put("IT", "ਇਟਲੀ");
    namesMap.put("JE", "ਜਰਸੀ");
    namesMap.put("JM", "ਜਮਾਇਕਾ");
    namesMap.put("JO", "ਜਾਰਡਨ");
    namesMap.put("JP", "ਜਪਾਨ");
    namesMap.put("KE", "ਕੀਨੀਆ");
    namesMap.put("KG", "ਕਿਰਗਿਜ਼ਸਤਾਨ");
    namesMap.put("KH", "ਕੰਬੋਡੀਆ");
    namesMap.put("KI", "ਕਿਰਬਾਤੀ");
    namesMap.put("KM", "ਕੋਮੋਰੋਸ");
    namesMap.put("KN", "ਸੇਂਟ ਕਿਟਸ ਐਂਡ ਨੇਵਿਸ");
    namesMap.put("KP", "ਉੱਤਰ ਕੋਰੀਆ");
    namesMap.put("KR", "ਦੱਖਣ ਕੋਰੀਆ");
    namesMap.put("KW", "ਕੁਵੈਤ");
    namesMap.put("KY", "ਕੇਮੈਨ ਟਾਪੂ");
    namesMap.put("KZ", "ਕਜ਼ਾਖਸਤਾਨ");
    namesMap.put("LA", "ਲਾਓਸ");
    namesMap.put("LB", "ਲੈਬਨਾਨ");
    namesMap.put("LC", "ਸੇਂਟ ਲੂਸੀਆ");
    namesMap.put("LI", "ਲਿਚੇਂਸਟਾਇਨ");
    namesMap.put("LK", "ਸ੍ਰੀ ਲੰਕਾ");
    namesMap.put("LR", "ਲਾਈਬੀਰੀਆ");
    namesMap.put("LS", "ਲੇਸੋਥੋ");
    namesMap.put("LT", "ਲਿਥੁਆਨੀਆ");
    namesMap.put("LU", "ਲਕਜ਼ਮਬਰਗ");
    namesMap.put("LV", "ਲਾਤਵੀਆ");
    namesMap.put("LY", "ਲੀਬੀਆ");
    namesMap.put("MA", "ਮੋਰੱਕੋ");
    namesMap.put("MC", "ਮੋਨਾਕੋ");
    namesMap.put("MD", "ਮੋਲਡੋਵਾ");
    namesMap.put("ME", "ਮੋਂਟੇਨੇਗਰੋ");
    namesMap.put("MF", "ਸੇਂਟ ਮਾਰਟਿਨ");
    namesMap.put("MG", "ਮੈਡਾਗਾਸਕਰ");
    namesMap.put("MH", "ਮਾਰਸ਼ਲ ਟਾਪੂ");
    namesMap.put("MK", "ਮੈਕਡੋਨੀਆ");
    namesMap.put("ML", "ਮਾਲੀ");
    namesMap.put("MM", "ਮਿਆਂਮਾਰ (ਬਰਮਾ)");
    namesMap.put("MN", "ਮੰਗੋਲੀਆ");
    namesMap.put("MO", "ਮਕਾਉ ਐਸਏਆਰ ਚੀਨ");
    namesMap.put("MP", "ਉੱਤਰੀ ਮਾਰੀਆਨਾ ਟਾਪੂ");
    namesMap.put("MQ", "ਮਾਰਟੀਨਿਕ");
    namesMap.put("MR", "ਮੋਰਿਟਾਨੀਆ");
    namesMap.put("MS", "ਮੋਂਟਸੇਰਾਤ");
    namesMap.put("MT", "ਮਾਲਟਾ");
    namesMap.put("MU", "ਮੌਰੀਸ਼ਸ");
    namesMap.put("MV", "ਮਾਲਦੀਵ");
    namesMap.put("MW", "ਮਲਾਵੀ");
    namesMap.put("MX", "ਮੈਕਸੀਕੋ");
    namesMap.put("MY", "ਮਲੇਸ਼ੀਆ");
    namesMap.put("MZ", "ਮੋਜ਼ਾਮਬੀਕ");
    namesMap.put("NA", "ਨਾਮੀਬੀਆ");
    namesMap.put("NC", "ਨਿਊ ਕੈਲੇਡੋਨੀਆ");
    namesMap.put("NE", "ਨਾਈਜਰ");
    namesMap.put("NF", "ਨੋਰਫੌਕ ਟਾਪੂ");
    namesMap.put("NG", "ਨਾਈਜੀਰੀਆ");
    namesMap.put("NI", "ਨਿਕਾਰਾਗੁਆ");
    namesMap.put("NL", "ਨੀਦਰਲੈਂਡ");
    namesMap.put("NO", "ਨਾਰਵੇ");
    namesMap.put("NP", "ਨੇਪਾਲ");
    namesMap.put("NR", "ਨਾਉਰੂ");
    namesMap.put("NU", "ਨਿਯੂ");
    namesMap.put("NZ", "ਨਿਊਜ਼ੀਲੈਂਡ");
    namesMap.put("OM", "ਓਮਾਨ");
    namesMap.put("PA", "ਪਨਾਮਾ");
    namesMap.put("PE", "ਪੇਰੂ");
    namesMap.put("PF", "ਫਰੈਂਚ ਪੋਲੀਨੇਸ਼ੀਆ");
    namesMap.put("PG", "ਪਾਪੂਆ ਨਿਊ ਗਿਨੀ");
    namesMap.put("PH", "ਫਿਲੀਪੀਨਜ");
    namesMap.put("PK", "ਪਾਕਿਸਤਾਨ");
    namesMap.put("PL", "ਪੋਲੈਂਡ");
    namesMap.put("PM", "ਸੇਂਟ ਪੀਅਰੇ ਐਂਡ ਮਿਕੇਲਨ");
    namesMap.put("PN", "ਪਿਟਕੇਰਨ ਟਾਪੂ");
    namesMap.put("PR", "ਪਿਊਰਟੋ ਰਿਕੋ");
    namesMap.put("PS", "ਫਿਲੀਸਤੀਨੀ ਇਲਾਕਾ");
    namesMap.put("PT", "ਪੁਰਤਗਾਲ");
    namesMap.put("PW", "ਪਲਾਉ");
    namesMap.put("PY", "ਪੈਰਾਗਵੇ");
    namesMap.put("QA", "ਕਤਰ");
    namesMap.put("QO", "ਆਊਟਲਾਇੰਗ ਓਸ਼ੀਨੀਆ");
    namesMap.put("RE", "ਰਿਯੂਨੀਅਨ");
    namesMap.put("RO", "ਰੋਮਾਨੀਆ");
    namesMap.put("RS", "ਸਰਬੀਆ");
    namesMap.put("RU", "ਰੂਸ");
    namesMap.put("RW", "ਰਵਾਂਡਾ");
    namesMap.put("SA", "ਸਾਊਦੀ ਅਰਬ");
    namesMap.put("SB", "ਸੋਲੋਮਨ ਟਾਪੂ");
    namesMap.put("SC", "ਸੇਸ਼ਲਸ");
    namesMap.put("SD", "ਸੂਡਾਨ");
    namesMap.put("SE", "ਸਵੀਡਨ");
    namesMap.put("SG", "ਸਿੰਗਾਪੁਰ");
    namesMap.put("SH", "ਸੇਂਟ ਹੇਲੇਨਾ");
    namesMap.put("SI", "ਸਲੋਵੇਨੀਆ");
    namesMap.put("SJ", "ਸਵਾਲਬਰਡ ਅਤੇ ਜਾਨ ਮਾਯੇਨ");
    namesMap.put("SK", "ਸਲੋਵਾਕੀਆ");
    namesMap.put("SL", "ਸਿਏਰਾ ਲਿਓਨ");
    namesMap.put("SM", "ਸੈਨ ਮਰੀਨੋ");
    namesMap.put("SN", "ਸੇਨੇਗਲ");
    namesMap.put("SO", "ਸੋਮਾਲੀਆ");
    namesMap.put("SR", "ਸੂਰੀਨਾਮ");
    namesMap.put("SS", "ਦੱਖਣ ਸੁਡਾਨ");
    namesMap.put("ST", "ਸਾਓ ਟੋਮ ਅਤੇ ਪ੍ਰਿੰਸੀਪੇ");
    namesMap.put("SV", "ਅਲ ਸਲਵਾਡੋਰ");
    namesMap.put("SX", "ਸਿੰਟ ਮਾਰਟੀਨ");
    namesMap.put("SY", "ਸੀਰੀਆ");
    namesMap.put("SZ", "ਸਵਾਜ਼ੀਲੈਂਡ");
    namesMap.put("TA", "ਟ੍ਰਿਸਟਾਨ ਦਾ ਕੁੰਹਾ");
    namesMap.put("TC", "ਟੁਰਕਸ ਅਤੇ ਕੈਕੋਸ ਟਾਪੂ");
    namesMap.put("TD", "ਚਾਡ");
    namesMap.put("TF", "ਫਰੈਂਚ ਦੱਖਣੀ ਪ੍ਰਦੇਸ਼");
    namesMap.put("TG", "ਟੋਗੋ");
    namesMap.put("TH", "ਥਾਈਲੈਂਡ");
    namesMap.put("TJ", "ਤਾਜਿਕਿਸਤਾਨ");
    namesMap.put("TK", "ਟੋਕੇਲਾਉ");
    namesMap.put("TL", "ਤਿਮੋਰ-ਲੇਸਤੇ");
    namesMap.put("TM", "ਤੁਰਕਮੇਨਿਸਤਾਨ");
    namesMap.put("TN", "ਟਿਊਨੀਸ਼ੀਆ");
    namesMap.put("TO", "ਟੌਂਗਾ");
    namesMap.put("TR", "ਤੁਰਕੀ");
    namesMap.put("TT", "ਟ੍ਰਿਨੀਡਾਡ ਅਤੇ ਟੋਬਾਗੋ");
    namesMap.put("TV", "ਟੁਵਾਲੂ");
    namesMap.put("TW", "ਤਾਇਵਾਨ");
    namesMap.put("TZ", "ਤਨਜ਼ਾਨੀਆ");
    namesMap.put("UA", "ਯੂਕਰੇਨ");
    namesMap.put("UG", "ਯੂਗਾਂਡਾ");
    namesMap.put("UM", "ਯੂ.ਐੱਸ. ਦੂਰ-ਦੁਰਾਡੇ ਟਾਪੂ");
    namesMap.put("UN", "ਸੰਯੁਕਤ ਰਾਸ਼ਟਰ");
    namesMap.put("US", "ਸੰਯੁਕਤ ਰਾਜ");
    namesMap.put("UY", "ਉਰੂਗਵੇ");
    namesMap.put("UZ", "ਉਜ਼ਬੇਕਿਸਤਾਨ");
    namesMap.put("VA", "ਵੈਟੀਕਨ ਸਿਟੀ");
    namesMap.put("VC", "ਸੇਂਟ ਵਿਨਸੈਂਟ ਐਂਡ ਗ੍ਰੇਨਾਡੀਨਸ");
    namesMap.put("VE", "ਵੇਨੇਜ਼ੂਏਲਾ");
    namesMap.put("VG", "ਬ੍ਰਿਟਿਸ਼ ਵਰਜਿਨ ਟਾਪੂ");
    namesMap.put("VI", "ਯੂ ਐੱਸ ਵਰਜਿਨ ਟਾਪੂ");
    namesMap.put("VN", "ਵੀਅਤਨਾਮ");
    namesMap.put("VU", "ਵਾਨੂਆਟੂ");
    namesMap.put("WF", "ਵਾਲਿਸ ਅਤੇ ਫੂਟੂਨਾ");
    namesMap.put("WS", "ਸਾਮੋਆ");
    namesMap.put("XK", "ਕੋਸੋਵੋ");
    namesMap.put("YE", "ਯਮਨ");
    namesMap.put("YT", "ਮਾਯੋਟੀ");
    namesMap.put("ZA", "ਦੱਖਣੀ ਅਫਰੀਕਾ");
    namesMap.put("ZM", "ਜ਼ਾਮਬੀਆ");
    namesMap.put("ZW", "ਜ਼ਿੰਬਾਬਵੇ");
    namesMap.put("ZZ", "ਅਣਪਛਾਤਾ ਇਲਾਕਾ");
  }

}
