/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.cldr.impl;

import org.gwtproject.i18n.shared.cldr.LocalizedNamesImplBase;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "ru" locale.
 */
public class LocalizedNamesImpl_ru extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "RU",
        "UA",
        "KZ",
        "PL",
        "DE",
        "UZ",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "XA",
        "XB",
        "AU",
        "AT",
        "AZ",
        "AX",
        "AL",
        "DZ",
        "AS",
        "AI",
        "AO",
        "AD",
        "AQ",
        "AG",
        "AR",
        "AM",
        "AW",
        "AF",
        "BS",
        "BD",
        "BB",
        "BH",
        "BY",
        "BZ",
        "BE",
        "BJ",
        "BM",
        "BG",
        "BO",
        "BQ",
        "BA",
        "BW",
        "BR",
        "IO",
        "BN",
        "BF",
        "BI",
        "BT",
        "VU",
        "VA",
        "GB",
        "HU",
        "VE",
        "VG",
        "VI",
        "UM",
        "QO",
        "TL",
        "VN",
        "GA",
        "HT",
        "GY",
        "GM",
        "GH",
        "GP",
        "GT",
        "GN",
        "GW",
        "DE",
        "GG",
        "GI",
        "HN",
        "HK",
        "GD",
        "GL",
        "GR",
        "GE",
        "GU",
        "DK",
        "JE",
        "DJ",
        "DG",
        "DM",
        "DO",
        "EZ",
        "EU",
        "EG",
        "ZM",
        "EH",
        "ZW",
        "IL",
        "IN",
        "ID",
        "JO",
        "IQ",
        "IR",
        "IE",
        "IS",
        "ES",
        "IT",
        "YE",
        "CV",
        "KZ",
        "KH",
        "CM",
        "CA",
        "IC",
        "QA",
        "KE",
        "CY",
        "KG",
        "KI",
        "CN",
        "KP",
        "CC",
        "CO",
        "KM",
        "CG",
        "CD",
        "XK",
        "CR",
        "CI",
        "CU",
        "KW",
        "CW",
        "LA",
        "LV",
        "LS",
        "LR",
        "LB",
        "LY",
        "LT",
        "LI",
        "LU",
        "MU",
        "MR",
        "MG",
        "YT",
        "MO",
        "MK",
        "MW",
        "MY",
        "ML",
        "MV",
        "MT",
        "MA",
        "MQ",
        "MH",
        "MX",
        "MZ",
        "MD",
        "MC",
        "MN",
        "MS",
        "MM",
        "NA",
        "NR",
        "NP",
        "NE",
        "NG",
        "NL",
        "NI",
        "NU",
        "NZ",
        "NC",
        "NO",
        "AE",
        "PN",
        "TC",
        "HM",
        "BV",
        "AC",
        "CP",
        "IM",
        "NF",
        "CX",
        "SH",
        "OM",
        "UN",
        "KY",
        "CK",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PL",
        "PT",
        "PR",
        "KR",
        "RE",
        "RU",
        "RW",
        "RO",
        "SV",
        "WS",
        "SM",
        "ST",
        "SA",
        "SZ",
        "MP",
        "SC",
        "BL",
        "SN",
        "MF",
        "PM",
        "VC",
        "KN",
        "LC",
        "RS",
        "EA",
        "SG",
        "SX",
        "SY",
        "SK",
        "SI",
        "US",
        "SB",
        "SO",
        "SD",
        "SR",
        "SL",
        "TJ",
        "TH",
        "TW",
        "TZ",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TV",
        "TN",
        "TM",
        "TR",
        "UG",
        "UZ",
        "UA",
        "WF",
        "UY",
        "FO",
        "FM",
        "FJ",
        "PH",
        "FI",
        "FK",
        "FR",
        "GF",
        "PF",
        "TF",
        "HR",
        "CF",
        "TD",
        "ME",
        "CZ",
        "CL",
        "CH",
        "SE",
        "SJ",
        "LK",
        "EC",
        "GQ",
        "ER",
        "EE",
        "ET",
        "GS",
        "ZA",
        "SS",
        "JM",
        "JP",
    };
  }

  @Override
  protected void loadNameMap() {
    super.loadNameMap();
    namesMap.put("001", "весь мир");
    namesMap.put("002", "Африка");
    namesMap.put("003", "Северная Америка");
    namesMap.put("005", "Южная Америка");
    namesMap.put("009", "Океания");
    namesMap.put("011", "Западная Африка");
    namesMap.put("013", "Центральная Америка");
    namesMap.put("014", "Восточная Африка");
    namesMap.put("015", "Северная Африка");
    namesMap.put("017", "Центральная Африка");
    namesMap.put("018", "Южная Африка");
    namesMap.put("019", "Америка");
    namesMap.put("021", "Североамериканский регион");
    namesMap.put("029", "Карибы");
    namesMap.put("030", "Восточная Азия");
    namesMap.put("034", "Южная Азия");
    namesMap.put("035", "Юго-Восточная Азия");
    namesMap.put("039", "Южная Европа");
    namesMap.put("053", "Австралазия");
    namesMap.put("054", "Меланезия");
    namesMap.put("057", "Микронезия");
    namesMap.put("061", "Полинезия");
    namesMap.put("142", "Азия");
    namesMap.put("143", "Центральная Азия");
    namesMap.put("145", "Западная Азия");
    namesMap.put("150", "Европа");
    namesMap.put("151", "Восточная Европа");
    namesMap.put("154", "Северная Европа");
    namesMap.put("155", "Западная Европа");
    namesMap.put("202", "Тропическая Африка");
    namesMap.put("419", "Латинская Америка");
    namesMap.put("AC", "о-в Вознесения");
    namesMap.put("AD", "Андорра");
    namesMap.put("AE", "ОАЭ");
    namesMap.put("AF", "Афганистан");
    namesMap.put("AG", "Антигуа и Барбуда");
    namesMap.put("AI", "Ангилья");
    namesMap.put("AL", "Албания");
    namesMap.put("AM", "Армения");
    namesMap.put("AO", "Ангола");
    namesMap.put("AQ", "Антарктида");
    namesMap.put("AR", "Аргентина");
    namesMap.put("AS", "Американское Самоа");
    namesMap.put("AT", "Австрия");
    namesMap.put("AU", "Австралия");
    namesMap.put("AW", "Аруба");
    namesMap.put("AX", "Аландские о-ва");
    namesMap.put("AZ", "Азербайджан");
    namesMap.put("BA", "Босния и Герцеговина");
    namesMap.put("BB", "Барбадос");
    namesMap.put("BD", "Бангладеш");
    namesMap.put("BE", "Бельгия");
    namesMap.put("BF", "Буркина-Фасо");
    namesMap.put("BG", "Болгария");
    namesMap.put("BH", "Бахрейн");
    namesMap.put("BI", "Бурунди");
    namesMap.put("BJ", "Бенин");
    namesMap.put("BL", "Сен-Бартелеми");
    namesMap.put("BM", "Бермудские о-ва");
    namesMap.put("BN", "Бруней-Даруссалам");
    namesMap.put("BO", "Боливия");
    namesMap.put("BQ", "Бонэйр, Синт-Эстатиус и Саба");
    namesMap.put("BR", "Бразилия");
    namesMap.put("BS", "Багамы");
    namesMap.put("BT", "Бутан");
    namesMap.put("BV", "о-в Буве");
    namesMap.put("BW", "Ботсвана");
    namesMap.put("BY", "Беларусь");
    namesMap.put("BZ", "Белиз");
    namesMap.put("CA", "Канада");
    namesMap.put("CC", "Кокосовые о-ва");
    namesMap.put("CD", "Конго - Киншаса");
    namesMap.put("CF", "Центрально-Африканская Республика");
    namesMap.put("CG", "Конго - Браззавиль");
    namesMap.put("CH", "Швейцария");
    namesMap.put("CI", "Кот-д’Ивуар");
    namesMap.put("CK", "Острова Кука");
    namesMap.put("CL", "Чили");
    namesMap.put("CM", "Камерун");
    namesMap.put("CN", "Китай");
    namesMap.put("CO", "Колумбия");
    namesMap.put("CP", "о-в Клиппертон");
    namesMap.put("CR", "Коста-Рика");
    namesMap.put("CU", "Куба");
    namesMap.put("CV", "Кабо-Верде");
    namesMap.put("CW", "Кюрасао");
    namesMap.put("CX", "о-в Рождества");
    namesMap.put("CY", "Кипр");
    namesMap.put("CZ", "Чехия");
    namesMap.put("DE", "Германия");
    namesMap.put("DG", "Диего-Гарсия");
    namesMap.put("DJ", "Джибути");
    namesMap.put("DK", "Дания");
    namesMap.put("DM", "Доминика");
    namesMap.put("DO", "Доминиканская Республика");
    namesMap.put("DZ", "Алжир");
    namesMap.put("EA", "Сеута и Мелилья");
    namesMap.put("EC", "Эквадор");
    namesMap.put("EE", "Эстония");
    namesMap.put("EG", "Египет");
    namesMap.put("EH", "Западная Сахара");
    namesMap.put("ER", "Эритрея");
    namesMap.put("ES", "Испания");
    namesMap.put("ET", "Эфиопия");
    namesMap.put("EU", "Европейский союз");
    namesMap.put("EZ", "еврозона");
    namesMap.put("FI", "Финляндия");
    namesMap.put("FJ", "Фиджи");
    namesMap.put("FK", "Фолклендские о-ва");
    namesMap.put("FM", "Федеративные Штаты Микронезии");
    namesMap.put("FO", "Фарерские о-ва");
    namesMap.put("FR", "Франция");
    namesMap.put("GA", "Габон");
    namesMap.put("GB", "Великобритания");
    namesMap.put("GD", "Гренада");
    namesMap.put("GE", "Грузия");
    namesMap.put("GF", "Французская Гвиана");
    namesMap.put("GG", "Гернси");
    namesMap.put("GH", "Гана");
    namesMap.put("GI", "Гибралтар");
    namesMap.put("GL", "Гренландия");
    namesMap.put("GM", "Гамбия");
    namesMap.put("GN", "Гвинея");
    namesMap.put("GP", "Гваделупа");
    namesMap.put("GQ", "Экваториальная Гвинея");
    namesMap.put("GR", "Греция");
    namesMap.put("GS", "Южная Георгия и Южные Сандвичевы о-ва");
    namesMap.put("GT", "Гватемала");
    namesMap.put("GU", "Гуам");
    namesMap.put("GW", "Гвинея-Бисау");
    namesMap.put("GY", "Гайана");
    namesMap.put("HK", "Гонконг (САР)");
    namesMap.put("HM", "о-ва Херд и Макдональд");
    namesMap.put("HN", "Гондурас");
    namesMap.put("HR", "Хорватия");
    namesMap.put("HT", "Гаити");
    namesMap.put("HU", "Венгрия");
    namesMap.put("IC", "Канарские о-ва");
    namesMap.put("ID", "Индонезия");
    namesMap.put("IE", "Ирландия");
    namesMap.put("IL", "Израиль");
    namesMap.put("IM", "о-в Мэн");
    namesMap.put("IN", "Индия");
    namesMap.put("IO", "Британская территория в Индийском океане");
    namesMap.put("IQ", "Ирак");
    namesMap.put("IR", "Иран");
    namesMap.put("IS", "Исландия");
    namesMap.put("IT", "Италия");
    namesMap.put("JE", "Джерси");
    namesMap.put("JM", "Ямайка");
    namesMap.put("JO", "Иордания");
    namesMap.put("JP", "Япония");
    namesMap.put("KE", "Кения");
    namesMap.put("KG", "Киргизия");
    namesMap.put("KH", "Камбоджа");
    namesMap.put("KI", "Кирибати");
    namesMap.put("KM", "Коморы");
    namesMap.put("KN", "Сент-Китс и Невис");
    namesMap.put("KP", "КНДР");
    namesMap.put("KR", "Республика Корея");
    namesMap.put("KW", "Кувейт");
    namesMap.put("KY", "Острова Кайман");
    namesMap.put("KZ", "Казахстан");
    namesMap.put("LA", "Лаос");
    namesMap.put("LB", "Ливан");
    namesMap.put("LC", "Сент-Люсия");
    namesMap.put("LI", "Лихтенштейн");
    namesMap.put("LK", "Шри-Ланка");
    namesMap.put("LR", "Либерия");
    namesMap.put("LS", "Лесото");
    namesMap.put("LT", "Литва");
    namesMap.put("LU", "Люксембург");
    namesMap.put("LV", "Латвия");
    namesMap.put("LY", "Ливия");
    namesMap.put("MA", "Марокко");
    namesMap.put("MC", "Монако");
    namesMap.put("MD", "Молдова");
    namesMap.put("ME", "Черногория");
    namesMap.put("MF", "Сен-Мартен");
    namesMap.put("MG", "Мадагаскар");
    namesMap.put("MH", "Маршалловы Острова");
    namesMap.put("MK", "Македония");
    namesMap.put("ML", "Мали");
    namesMap.put("MM", "Мьянма (Бирма)");
    namesMap.put("MN", "Монголия");
    namesMap.put("MO", "Макао (САР)");
    namesMap.put("MP", "Северные Марианские о-ва");
    namesMap.put("MQ", "Мартиника");
    namesMap.put("MR", "Мавритания");
    namesMap.put("MS", "Монтсеррат");
    namesMap.put("MT", "Мальта");
    namesMap.put("MU", "Маврикий");
    namesMap.put("MV", "Мальдивы");
    namesMap.put("MW", "Малави");
    namesMap.put("MX", "Мексика");
    namesMap.put("MY", "Малайзия");
    namesMap.put("MZ", "Мозамбик");
    namesMap.put("NA", "Намибия");
    namesMap.put("NC", "Новая Каледония");
    namesMap.put("NE", "Нигер");
    namesMap.put("NF", "о-в Норфолк");
    namesMap.put("NG", "Нигерия");
    namesMap.put("NI", "Никарагуа");
    namesMap.put("NL", "Нидерланды");
    namesMap.put("NO", "Норвегия");
    namesMap.put("NP", "Непал");
    namesMap.put("NR", "Науру");
    namesMap.put("NU", "Ниуэ");
    namesMap.put("NZ", "Новая Зеландия");
    namesMap.put("OM", "Оман");
    namesMap.put("PA", "Панама");
    namesMap.put("PE", "Перу");
    namesMap.put("PF", "Французская Полинезия");
    namesMap.put("PG", "Папуа — Новая Гвинея");
    namesMap.put("PH", "Филиппины");
    namesMap.put("PK", "Пакистан");
    namesMap.put("PL", "Польша");
    namesMap.put("PM", "Сен-Пьер и Микелон");
    namesMap.put("PN", "о-ва Питкэрн");
    namesMap.put("PR", "Пуэрто-Рико");
    namesMap.put("PS", "Палестинские территории");
    namesMap.put("PT", "Португалия");
    namesMap.put("PW", "Палау");
    namesMap.put("PY", "Парагвай");
    namesMap.put("QA", "Катар");
    namesMap.put("QO", "Внешняя Океания");
    namesMap.put("RE", "Реюньон");
    namesMap.put("RO", "Румыния");
    namesMap.put("RS", "Сербия");
    namesMap.put("RU", "Россия");
    namesMap.put("RW", "Руанда");
    namesMap.put("SA", "Саудовская Аравия");
    namesMap.put("SB", "Соломоновы Острова");
    namesMap.put("SC", "Сейшельские Острова");
    namesMap.put("SD", "Судан");
    namesMap.put("SE", "Швеция");
    namesMap.put("SG", "Сингапур");
    namesMap.put("SH", "о-в Св. Елены");
    namesMap.put("SI", "Словения");
    namesMap.put("SJ", "Шпицберген и Ян-Майен");
    namesMap.put("SK", "Словакия");
    namesMap.put("SL", "Сьерра-Леоне");
    namesMap.put("SM", "Сан-Марино");
    namesMap.put("SN", "Сенегал");
    namesMap.put("SO", "Сомали");
    namesMap.put("SR", "Суринам");
    namesMap.put("SS", "Южный Судан");
    namesMap.put("ST", "Сан-Томе и Принсипи");
    namesMap.put("SV", "Сальвадор");
    namesMap.put("SX", "Синт-Мартен");
    namesMap.put("SY", "Сирия");
    namesMap.put("SZ", "Свазиленд");
    namesMap.put("TA", "Тристан-да-Кунья");
    namesMap.put("TC", "о-ва Тёркс и Кайкос");
    namesMap.put("TD", "Чад");
    namesMap.put("TF", "Французские Южные территории");
    namesMap.put("TG", "Того");
    namesMap.put("TH", "Таиланд");
    namesMap.put("TJ", "Таджикистан");
    namesMap.put("TK", "Токелау");
    namesMap.put("TL", "Восточный Тимор");
    namesMap.put("TM", "Туркменистан");
    namesMap.put("TN", "Тунис");
    namesMap.put("TO", "Тонга");
    namesMap.put("TR", "Турция");
    namesMap.put("TT", "Тринидад и Тобаго");
    namesMap.put("TV", "Тувалу");
    namesMap.put("TW", "Тайвань");
    namesMap.put("TZ", "Танзания");
    namesMap.put("UA", "Украина");
    namesMap.put("UG", "Уганда");
    namesMap.put("UM", "Внешние малые о-ва (США)");
    namesMap.put("UN", "Организация Объединенных Наций");
    namesMap.put("US", "Соединенные Штаты");
    namesMap.put("UY", "Уругвай");
    namesMap.put("UZ", "Узбекистан");
    namesMap.put("VA", "Ватикан");
    namesMap.put("VC", "Сент-Винсент и Гренадины");
    namesMap.put("VE", "Венесуэла");
    namesMap.put("VG", "Виргинские о-ва (Великобритания)");
    namesMap.put("VI", "Виргинские о-ва (США)");
    namesMap.put("VN", "Вьетнам");
    namesMap.put("VU", "Вануату");
    namesMap.put("WF", "Уоллис и Футуна");
    namesMap.put("WS", "Самоа");
    namesMap.put("XK", "Косово");
    namesMap.put("YE", "Йемен");
    namesMap.put("YT", "Майотта");
    namesMap.put("ZA", "Южно-Африканская Республика");
    namesMap.put("ZM", "Замбия");
    namesMap.put("ZW", "Зимбабве");
    namesMap.put("ZZ", "неизвестный регион");
  }

}
