/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.cldr.impl;

import org.gwtproject.i18n.shared.cldr.LocalizedNamesImplBase;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "ia" locale.
 */
public class LocalizedNamesImpl_ia extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AF",
        "AI",
        "AL",
        "DZ",
        "AD",
        "AO",
        "AQ",
        "AG",
        "SA",
        "AR",
        "AM",
        "AU",
        "AT",
        "AW",
        "AZ",
        "BS",
        "BD",
        "BB",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BH",
        "BT",
        "BY",
        "MM",
        "BL",
        "BN",
        "BO",
        "BA",
        "BW",
        "BQ",
        "BR",
        "BG",
        "BF",
        "BI",
        "KH",
        "CM",
        "CA",
        "CC",
        "CD",
        "CZ",
        "CL",
        "CN",
        "CI",
        "VA",
        "CO",
        "KM",
        "CG",
        "KP",
        "KR",
        "CR",
        "CP",
        "HR",
        "CU",
        "CV",
        "CW",
        "CY",
        "DK",
        "DG",
        "DJ",
        "DM",
        "EA",
        "EC",
        "EG",
        "SV",
        "AE",
        "ER",
        "ES",
        "EE",
        "ET",
        "FI",
        "FJ",
        "FK",
        "FR",
        "GA",
        "GM",
        "GD",
        "GE",
        "DE",
        "GH",
        "GI",
        "GP",
        "GR",
        "GL",
        "GS",
        "GU",
        "GT",
        "GG",
        "GN",
        "GW",
        "GQ",
        "GF",
        "GY",
        "HT",
        "HK",
        "HM",
        "HN",
        "HU",
        "IC",
        "IN",
        "ID",
        "BV",
        "IM",
        "CX",
        "NF",
        "AX",
        "CK",
        "KY",
        "FO",
        "MP",
        "MH",
        "SB",
        "TC",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IL",
        "IT",
        "JP",
        "JE",
        "JM",
        "JO",
        "KZ",
        "KE",
        "KG",
        "KI",
        "XK",
        "KW",
        "LA",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MK",
        "MG",
        "MW",
        "MY",
        "ML",
        "MT",
        "MA",
        "MR",
        "MX",
        "MF",
        "FM",
        "MO",
        "MD",
        "MC",
        "MN",
        "ME",
        "MZ",
        "MQ",
        "MS",
        "MU",
        "MV",
        "NA",
        "UN",
        "NL",
        "NP",
        "NI",
        "NE",
        "NG",
        "NO",
        "NC",
        "NZ",
        "NR",
        "NU",
        "QO",
        "OM",
        "PK",
        "PA",
        "PG",
        "PY",
        "PE",
        "PH",
        "PN",
        "PL",
        "PF",
        "PT",
        "PR",
        "PS",
        "PW",
        "QA",
        "RE",
        "GB",
        "CF",
        "DO",
        "RO",
        "RW",
        "RU",
        "EH",
        "WS",
        "AS",
        "KN",
        "LC",
        "VC",
        "SM",
        "SN",
        "RS",
        "SC",
        "SG",
        "SH",
        "SL",
        "SK",
        "SI",
        "SO",
        "LK",
        "ST",
        "PM",
        "US",
        "ZA",
        "SD",
        "SS",
        "CH",
        "SR",
        "SJ",
        "SE",
        "SZ",
        "SX",
        "SY",
        "TA",
        "TJ",
        "TW",
        "TZ",
        "TD",
        "IO",
        "TF",
        "TH",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TN",
        "TR",
        "TM",
        "TV",
        "UG",
        "UA",
        "UM",
        "EU",
        "UY",
        "UZ",
        "VU",
        "VE",
        "VG",
        "VI",
        "VN",
        "WF",
        "XA",
        "XB",
        "YE",
        "YT",
        "ZM",
        "ZW",
        "EZ",
    };
  }

  @Override
  protected void loadNameMap() {
    super.loadNameMap();
    namesMap.put("001", "Mundo");
    namesMap.put("003", "America del Nord");
    namesMap.put("005", "America del Sud");
    namesMap.put("011", "Africa occidental");
    namesMap.put("013", "America central");
    namesMap.put("014", "Africa oriental");
    namesMap.put("015", "Africa septentrional");
    namesMap.put("017", "Africa central");
    namesMap.put("018", "Africa meridional");
    namesMap.put("021", "America septentrional");
    namesMap.put("029", "Caribes");
    namesMap.put("030", "Asia oriental");
    namesMap.put("034", "Asia meridional");
    namesMap.put("035", "Asia del sud-est");
    namesMap.put("039", "Europa meridional");
    namesMap.put("057", "Region micronesian");
    namesMap.put("143", "Asia central");
    namesMap.put("145", "Asia occidental");
    namesMap.put("150", "Europa");
    namesMap.put("151", "Europa oriental");
    namesMap.put("154", "Europa septentrional");
    namesMap.put("155", "Europa occidental");
    namesMap.put("202", "Africa subsaharian");
    namesMap.put("419", "America latin");
    namesMap.put("AE", "Emiratos Arabe Unite");
    namesMap.put("AG", "Antigua e Barbuda");
    namesMap.put("AS", "Samoa american");
    namesMap.put("AX", "Insulas Åland");
    namesMap.put("AZ", "Azerbaidzhan");
    namesMap.put("BA", "Bosnia e Herzegovina");
    namesMap.put("BE", "Belgica");
    namesMap.put("BR", "Brasil");
    namesMap.put("BV", "Insula de Bouvet");
    namesMap.put("BY", "Bielorussia");
    namesMap.put("CF", "Republica African Central");
    namesMap.put("CG", "Congo");
    namesMap.put("CH", "Suissa");
    namesMap.put("CK", "Insulas Cook");
    namesMap.put("CM", "Camerun");
    namesMap.put("CX", "Insula de Natal");
    namesMap.put("CY", "Cypro");
    namesMap.put("CZ", "Chechia");
    namesMap.put("DE", "Germania");
    namesMap.put("DK", "Danmark");
    namesMap.put("DO", "Republica Dominican");
    namesMap.put("EG", "Egypto");
    namesMap.put("EH", "Sahara occidental");
    namesMap.put("ES", "Espania");
    namesMap.put("EU", "Union Europee");
    namesMap.put("EZ", "Zona euro");
    namesMap.put("FI", "Finlandia");
    namesMap.put("FO", "Insulas Feroe");
    namesMap.put("FR", "Francia");
    namesMap.put("GB", "Regno Unite");
    namesMap.put("GF", "Guyana francese");
    namesMap.put("GL", "Groenlandia");
    namesMap.put("GQ", "Guinea equatorial");
    namesMap.put("GR", "Grecia");
    namesMap.put("HU", "Hungaria");
    namesMap.put("IE", "Irlanda");
    namesMap.put("IM", "Insula de Man");
    namesMap.put("IO", "Territorio oceanic britanno-indian");
    namesMap.put("IQ", "Irak");
    namesMap.put("IS", "Islanda");
    namesMap.put("IT", "Italia");
    namesMap.put("JO", "Jordania");
    namesMap.put("JP", "Japon");
    namesMap.put("KG", "Kirghizistan");
    namesMap.put("KH", "Cambodgia");
    namesMap.put("KN", "Sancte Christophoro e Nevis");
    namesMap.put("KP", "Corea del Nord");
    namesMap.put("KR", "Corea del Sud");
    namesMap.put("KY", "Insulas de Caiman");
    namesMap.put("LB", "Libano");
    namesMap.put("LC", "Sancte Lucia");
    namesMap.put("LT", "Lituania");
    namesMap.put("LU", "Luxemburg");
    namesMap.put("LV", "Lettonia");
    namesMap.put("MA", "Marocco");
    namesMap.put("MD", "Moldavia");
    namesMap.put("MH", "Insulas Marshall");
    namesMap.put("MM", "Birmania/Myanmar");
    namesMap.put("MP", "Insulas Marianna del Nord");
    namesMap.put("NC", "Nove Caledonia");
    namesMap.put("NF", "Insula Norfolk");
    namesMap.put("NL", "Nederlandia");
    namesMap.put("NO", "Norvegia");
    namesMap.put("NZ", "Nove Zelanda");
    namesMap.put("PF", "Polynesia francese");
    namesMap.put("PG", "Papua Nove Guinea");
    namesMap.put("PH", "Philippinas");
    namesMap.put("PL", "Polonia");
    namesMap.put("PM", "St. Pierre e Miquelon");
    namesMap.put("QO", "Oceania remote");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "Arabia Saudita");
    namesMap.put("SB", "Insulas Solomon");
    namesMap.put("SE", "Svedia");
    namesMap.put("SJ", "Svalbard e Jan Mayen");
    namesMap.put("SK", "Slovachia");
    namesMap.put("SS", "Sudan del Sud");
    namesMap.put("SZ", "Swazilandia");
    namesMap.put("TC", "Insulas Turcos e Caicos");
    namesMap.put("TD", "Tchad");
    namesMap.put("TF", "Territorios meridional francese");
    namesMap.put("TH", "Thailandia");
    namesMap.put("TJ", "Tadzhikistan");
    namesMap.put("TL", "Timor del Est");
    namesMap.put("TR", "Turchia");
    namesMap.put("TT", "Trinidad e Tobago");
    namesMap.put("UA", "Ukraina");
    namesMap.put("UN", "Nationes Unite");
    namesMap.put("US", "Statos Unite");
    namesMap.put("VA", "Citate del Vaticano");
    namesMap.put("VC", "Sancte Vincente e le Grenadinas");
    namesMap.put("ZA", "Sudafrica");
    namesMap.put("ZZ", "Region incognite");
  }

}
