package org.gwtproject.i18n.shared.cldr.impl;

import java.lang.Override;
import java.lang.String;
import java.util.HashMap;
import javax.annotation.Generated;
import org.gwtproject.i18n.shared.cldr.CurrencyData;
import org.gwtproject.i18n.shared.cldr.CurrencyDataImpl;

@Generated("gwt-cldr-importer : org.gwtproject.tools.cldr.CurrencyListProcessor, CLDR version : release-34")
public class CurrencyList_yue_Hant_HK extends CurrencyList_yue_Hant {
  public CurrencyData getDefault() {
    return new CurrencyDataImpl("HKD","HK$",2,"HK$","HK$");
  }

  protected HashMap<String, CurrencyData> loadCurrencyMap() {
    HashMap<String,CurrencyData> result = super.loadCurrencyMap();
    // 安道爾陪士特
    result.put("ADP", new CurrencyDataImpl("ADP","ADP",128,"ADP","ADP"));
    // 阿拉伯聯合大公國迪爾汗
    result.put("AED", new CurrencyDataImpl("AED","AED",2,"AED","AED"));
    // 阿富汗尼 (1927–2002)
    result.put("AFA", new CurrencyDataImpl("AFA","AFA",130,"AFA","AFA"));
    // 阿富汗尼
    result.put("AFN", new CurrencyDataImpl("AFN","AFN",0,"AFN","AFN"));
    // 阿爾巴尼亞列克 (1946–1965)
    result.put("ALK", new CurrencyDataImpl("ALK","ALK",130,"ALK","ALK"));
    // 阿爾巴尼亞列克
    result.put("ALL", new CurrencyDataImpl("ALL","ALL",0,"ALL","ALL"));
    // 亞美尼亞德拉姆
    result.put("AMD", new CurrencyDataImpl("AMD","AMD",2,"AMD","AMD"));
    // 荷屬安地列斯盾
    result.put("ANG", new CurrencyDataImpl("ANG","ANG",2,"ANG","ANG"));
    // 安哥拉寬扎
    result.put("AOA", new CurrencyDataImpl("AOA","AOA",2,"AOA","AOA"));
    // 安哥拉寬扎 (1977–1990)
    result.put("AOK", new CurrencyDataImpl("AOK","AOK",130,"AOK","AOK"));
    // 安哥拉新寬扎 (1990–2000)
    result.put("AON", new CurrencyDataImpl("AON","AON",130,"AON","AON"));
    // 安哥拉新調寬扎 (1995–1999)
    result.put("AOR", new CurrencyDataImpl("AOR","AOR",130,"AOR","AOR"));
    // 阿根廷奧斯特納爾
    result.put("ARA", new CurrencyDataImpl("ARA","ARA",130,"ARA","ARA"));
    // 阿根廷披索 (1970–1983)
    result.put("ARL", new CurrencyDataImpl("ARL","ARL",130,"ARL","ARL"));
    // 阿根廷披索 (1881–1970)
    result.put("ARM", new CurrencyDataImpl("ARM","ARM",130,"ARM","ARM"));
    // 阿根廷披索 (1983–1985)
    result.put("ARP", new CurrencyDataImpl("ARP","ARP",130,"ARP","ARP"));
    // 阿根廷披索
    result.put("ARS", new CurrencyDataImpl("ARS","ARS",2,"ARS","ARS"));
    // 奧地利先令
    result.put("ATS", new CurrencyDataImpl("ATS","ATS",130,"ATS","ATS"));
    // 澳幣
    result.put("AUD", new CurrencyDataImpl("AUD","AU$",2,"AU$","AU$"));
    // 阿路巴盾
    result.put("AWG", new CurrencyDataImpl("AWG","AWG",2,"AWG","AWG"));
    // 亞塞拜然馬納特 (1993–2006)
    result.put("AZM", new CurrencyDataImpl("AZM","AZM",130,"AZM","AZM"));
    // 亞塞拜然馬納特
    result.put("AZN", new CurrencyDataImpl("AZN","AZN",2,"AZN","AZN"));
    // 波士尼亞-赫塞哥維納第納爾
    result.put("BAD", new CurrencyDataImpl("BAD","BAD",130,"BAD","BAD"));
    // 波士尼亞-赫塞哥維納可轉換馬克
    result.put("BAM", new CurrencyDataImpl("BAM","BAM",2,"BAM","BAM"));
    // 波士尼亞-赫塞哥維納新第納爾
    result.put("BAN", new CurrencyDataImpl("BAN","BAN",130,"BAN","BAN"));
    // 巴貝多元
    result.put("BBD", new CurrencyDataImpl("BBD","BBD",2,"BBD","BBD"));
    // 孟加拉塔卡
    result.put("BDT", new CurrencyDataImpl("BDT","BDT",2,"BDT","BDT"));
    // 比利時法郎（可轉換）
    result.put("BEC", new CurrencyDataImpl("BEC","BEC",130,"BEC","BEC"));
    // 比利時法郎
    result.put("BEF", new CurrencyDataImpl("BEF","BEF",130,"BEF","BEF"));
    // 比利時法郎（金融）
    result.put("BEL", new CurrencyDataImpl("BEL","BEL",130,"BEL","BEL"));
    // 保加利亞硬列弗
    result.put("BGL", new CurrencyDataImpl("BGL","BGL",130,"BGL","BGL"));
    // 保加利亞社會黨列弗
    result.put("BGM", new CurrencyDataImpl("BGM","BGM",130,"BGM","BGM"));
    // 保加利亞新列弗
    result.put("BGN", new CurrencyDataImpl("BGN","BGN",2,"BGN","BGN"));
    // 保加利亞列弗 (1879–1952)
    result.put("BGO", new CurrencyDataImpl("BGO","BGO",130,"BGO","BGO"));
    // 巴林第納爾
    result.put("BHD", new CurrencyDataImpl("BHD","BHD",3,"BHD","BHD"));
    // 蒲隆地法郎
    result.put("BIF", new CurrencyDataImpl("BIF","BIF",0,"BIF","BIF"));
    // 百慕達幣
    result.put("BMD", new CurrencyDataImpl("BMD","BMD",2,"BMD","BMD"));
    // 汶萊元
    result.put("BND", new CurrencyDataImpl("BND","BND",2,"BND","BND"));
    // 玻利維亞諾
    result.put("BOB", new CurrencyDataImpl("BOB","BOB",2,"BOB","BOB"));
    // 玻利維亞玻利維亞諾 (1863–1963)
    result.put("BOL", new CurrencyDataImpl("BOL","BOL",130,"BOL","BOL"));
    // 玻利維亞披索
    result.put("BOP", new CurrencyDataImpl("BOP","BOP",130,"BOP","BOP"));
    // 玻利維亞幕多
    result.put("BOV", new CurrencyDataImpl("BOV","BOV",130,"BOV","BOV"));
    // 巴西克魯薩多農瓦 (1967–1986)
    result.put("BRB", new CurrencyDataImpl("BRB","BRB",130,"BRB","BRB"));
    // 巴西克魯賽羅 (1986–1989)
    result.put("BRC", new CurrencyDataImpl("BRC","BRC",130,"BRC","BRC"));
    // 巴西克魯賽羅 (1990–1993)
    result.put("BRE", new CurrencyDataImpl("BRE","BRE",130,"BRE","BRE"));
    // 巴西里拉
    result.put("BRL", new CurrencyDataImpl("BRL","R$",2,"R$","R$"));
    // 巴西克如爾達農瓦
    result.put("BRN", new CurrencyDataImpl("BRN","BRN",130,"BRN","BRN"));
    // 巴西克魯賽羅 (1993–1994)
    result.put("BRR", new CurrencyDataImpl("BRR","BRR",130,"BRR","BRR"));
    // 巴西克魯賽羅 (1942 –1967)
    result.put("BRZ", new CurrencyDataImpl("BRZ","BRZ",130,"BRZ","BRZ"));
    // 巴哈馬元
    result.put("BSD", new CurrencyDataImpl("BSD","BSD",2,"BSD","BSD"));
    // 不丹那特倫
    result.put("BTN", new CurrencyDataImpl("BTN","BTN",2,"BTN","BTN"));
    // 緬甸基雅特
    result.put("BUK", new CurrencyDataImpl("BUK","BUK",130,"BUK","BUK"));
    // 波札那普拉
    result.put("BWP", new CurrencyDataImpl("BWP","BWP",2,"BWP","BWP"));
    // 白俄羅斯新盧布 (1994–1999)
    result.put("BYB", new CurrencyDataImpl("BYB","BYB",130,"BYB","BYB"));
    // 白俄羅斯盧布
    result.put("BYN", new CurrencyDataImpl("BYN","BYN",2,"BYN","BYN"));
    // 白俄羅斯盧布 (2000–2016)
    result.put("BYR", new CurrencyDataImpl("BYR","BYR",128,"BYR","BYR"));
    // 貝里斯元
    result.put("BZD", new CurrencyDataImpl("BZD","BZD",2,"BZD","BZD"));
    // 加幣
    result.put("CAD", new CurrencyDataImpl("CAD","CA$",2,"CA$","CA$"));
    // 剛果法郎
    result.put("CDF", new CurrencyDataImpl("CDF","CDF",2,"CDF","CDF"));
    // 歐元 (WIR)
    result.put("CHE", new CurrencyDataImpl("CHE","CHE",130,"CHE","CHE"));
    // 瑞士法郎
    result.put("CHF", new CurrencyDataImpl("CHF","CHF",2,"CHF","CHF"));
    // 法郎 (WIR)
    result.put("CHW", new CurrencyDataImpl("CHW","CHW",130,"CHW","CHW"));
    // 智利埃斯庫多
    result.put("CLE", new CurrencyDataImpl("CLE","CLE",130,"CLE","CLE"));
    // 卡林油達佛曼跎
    result.put("CLF", new CurrencyDataImpl("CLF","CLF",132,"CLF","CLF"));
    // 智利披索
    result.put("CLP", new CurrencyDataImpl("CLP","CLP",0,"CLP","CLP"));
    // 人民幣 (離岸)
    result.put("CNH", new CurrencyDataImpl("CNH","CNH",130,"CNH","CNH"));
    // CNX
    result.put("CNX", new CurrencyDataImpl("CNX","CNX",130,"CNX","CNX"));
    // 人民幣
    result.put("CNY", new CurrencyDataImpl("CNY","CN¥",2,"CN¥","CN¥"));
    // 哥倫比亞披索
    result.put("COP", new CurrencyDataImpl("COP","COP",2,"COP","COP"));
    // 哥倫比亞幣 (COU)
    result.put("COU", new CurrencyDataImpl("COU","COU",130,"COU","COU"));
    // 哥斯大黎加科朗
    result.put("CRC", new CurrencyDataImpl("CRC","CRC",2,"CRC","CRC"));
    // 舊塞爾維亞第納爾
    result.put("CSD", new CurrencyDataImpl("CSD","CSD",130,"CSD","CSD"));
    // 捷克斯洛伐克硬克朗
    result.put("CSK", new CurrencyDataImpl("CSK","CSK",130,"CSK","CSK"));
    // 古巴可轉換披索
    result.put("CUC", new CurrencyDataImpl("CUC","CUC",2,"CUC","CUC"));
    // 古巴披索
    result.put("CUP", new CurrencyDataImpl("CUP","CUP",2,"CUP","CUP"));
    // 維德角埃斯庫多
    result.put("CVE", new CurrencyDataImpl("CVE","CVE",2,"CVE","CVE"));
    // 賽普勒斯鎊
    result.put("CYP", new CurrencyDataImpl("CYP","CYP",130,"CYP","CYP"));
    // 捷克克朗
    result.put("CZK", new CurrencyDataImpl("CZK","CZK",2,"CZK","CZK"));
    // 東德奧斯特馬克
    result.put("DDM", new CurrencyDataImpl("DDM","DDM",130,"DDM","DDM"));
    // 德國馬克
    result.put("DEM", new CurrencyDataImpl("DEM","DEM",130,"DEM","DEM"));
    // 吉布地法郎
    result.put("DJF", new CurrencyDataImpl("DJF","DJF",0,"DJF","DJF"));
    // 丹麥克朗
    result.put("DKK", new CurrencyDataImpl("DKK","DKK",2,"DKK","DKK"));
    // 多明尼加披索
    result.put("DOP", new CurrencyDataImpl("DOP","DOP",2,"DOP","DOP"));
    // 阿爾及利亞第納爾
    result.put("DZD", new CurrencyDataImpl("DZD","DZD",2,"DZD","DZD"));
    // 厄瓜多蘇克雷
    result.put("ECS", new CurrencyDataImpl("ECS","ECS",130,"ECS","ECS"));
    // 厄瓜多爾由里達瓦康斯坦 (UVC)
    result.put("ECV", new CurrencyDataImpl("ECV","ECV",130,"ECV","ECV"));
    // 愛沙尼亞克朗
    result.put("EEK", new CurrencyDataImpl("EEK","EEK",130,"EEK","EEK"));
    // 埃及鎊
    result.put("EGP", new CurrencyDataImpl("EGP","EGP",2,"EGP","EGP"));
    // 厄立特里亞納克法
    result.put("ERN", new CurrencyDataImpl("ERN","ERN",2,"ERN","ERN"));
    // 西班牙比塞塔（會計單位）
    result.put("ESA", new CurrencyDataImpl("ESA","ESA",130,"ESA","ESA"));
    // 西班牙比塞塔（可轉換會計單位）
    result.put("ESB", new CurrencyDataImpl("ESB","ESB",130,"ESB","ESB"));
    // 西班牙陪士特
    result.put("ESP", new CurrencyDataImpl("ESP","ESP",128,"ESP","ESP"));
    // 衣索比亞比爾
    result.put("ETB", new CurrencyDataImpl("ETB","ETB",2,"ETB","ETB"));
    // 歐元
    result.put("EUR", new CurrencyDataImpl("EUR","€",2,"€","€"));
    // 芬蘭馬克
    result.put("FIM", new CurrencyDataImpl("FIM","FIM",130,"FIM","FIM"));
    // 斐濟元
    result.put("FJD", new CurrencyDataImpl("FJD","FJD",2,"FJD","FJD"));
    // 福克蘭群島鎊
    result.put("FKP", new CurrencyDataImpl("FKP","FKP",2,"FKP","FKP"));
    // 法國法郎
    result.put("FRF", new CurrencyDataImpl("FRF","FRF",130,"FRF","FRF"));
    // 英鎊
    result.put("GBP", new CurrencyDataImpl("GBP","£",2,"£","£"));
    // 喬治亞庫旁拉里
    result.put("GEK", new CurrencyDataImpl("GEK","GEK",130,"GEK","GEK"));
    // 喬治亞拉里
    result.put("GEL", new CurrencyDataImpl("GEL","₾",2,"₾","₾"));
    // 迦納賽地 (1979–2007)
    result.put("GHC", new CurrencyDataImpl("GHC","GHC",130,"GHC","GHC"));
    // 迦納塞地
    result.put("GHS", new CurrencyDataImpl("GHS","GHS",2,"GHS","GHS"));
    // 直布羅陀鎊
    result.put("GIP", new CurrencyDataImpl("GIP","GIP",2,"GIP","GIP"));
    // 甘比亞達拉西
    result.put("GMD", new CurrencyDataImpl("GMD","GMD",2,"GMD","GMD"));
    // 幾內亞法郎
    result.put("GNF", new CurrencyDataImpl("GNF","GNF",0,"GNF","GNF"));
    // 幾內亞西里
    result.put("GNS", new CurrencyDataImpl("GNS","GNS",130,"GNS","GNS"));
    // 赤道幾內亞埃奎勒
    result.put("GQE", new CurrencyDataImpl("GQE","GQE",130,"GQE","GQE"));
    // 希臘德拉克馬
    result.put("GRD", new CurrencyDataImpl("GRD","GRD",130,"GRD","GRD"));
    // 瓜地馬拉格查爾
    result.put("GTQ", new CurrencyDataImpl("GTQ","GTQ",2,"GTQ","GTQ"));
    // 葡屬幾內亞埃斯庫多
    result.put("GWE", new CurrencyDataImpl("GWE","GWE",130,"GWE","GWE"));
    // 幾內亞比索披索
    result.put("GWP", new CurrencyDataImpl("GWP","GWP",130,"GWP","GWP"));
    // 圭亞那元
    result.put("GYD", new CurrencyDataImpl("GYD","GYD",2,"GYD","GYD"));
    // 港幣
    result.put("HKD", new CurrencyDataImpl("HKD","HK$",2,"HK$","HK$"));
    // 洪都拉斯倫皮拉
    result.put("HNL", new CurrencyDataImpl("HNL","HNL",2,"HNL","HNL"));
    // 克羅埃西亞第納爾
    result.put("HRD", new CurrencyDataImpl("HRD","HRD",130,"HRD","HRD"));
    // 克羅埃西亞庫納
    result.put("HRK", new CurrencyDataImpl("HRK","HRK",2,"HRK","HRK"));
    // 海地古德
    result.put("HTG", new CurrencyDataImpl("HTG","HTG",2,"HTG","HTG"));
    // 匈牙利福林
    result.put("HUF", new CurrencyDataImpl("HUF","HUF",2,"HUF","HUF"));
    // 印尼盾
    result.put("IDR", new CurrencyDataImpl("IDR","IDR",2,"IDR","IDR"));
    // 愛爾蘭鎊
    result.put("IEP", new CurrencyDataImpl("IEP","IEP",130,"IEP","IEP"));
    // 以色列鎊
    result.put("ILP", new CurrencyDataImpl("ILP","ILP",130,"ILP","ILP"));
    // 以色列謝克爾 (1980–1985)
    result.put("ILR", new CurrencyDataImpl("ILR","ILR",130,"ILR","ILR"));
    // 以色列新謝克爾
    result.put("ILS", new CurrencyDataImpl("ILS","₪",2,"₪","₪"));
    // 印度盧比
    result.put("INR", new CurrencyDataImpl("INR","₹",2,"₹","₹"));
    // 伊拉克第納爾
    result.put("IQD", new CurrencyDataImpl("IQD","IQD",0,"IQD","IQD"));
    // 伊朗里亞爾
    result.put("IRR", new CurrencyDataImpl("IRR","IRR",0,"IRR","IRR"));
    // 冰島克朗 (1918–1981)
    result.put("ISJ", new CurrencyDataImpl("ISJ","ISJ",130,"ISJ","ISJ"));
    // 冰島克朗
    result.put("ISK", new CurrencyDataImpl("ISK","ISK",0,"ISK","ISK"));
    // 義大利里拉
    result.put("ITL", new CurrencyDataImpl("ITL","ITL",128,"ITL","ITL"));
    // 牙買加元
    result.put("JMD", new CurrencyDataImpl("JMD","JMD",2,"JMD","JMD"));
    // 約旦第納爾
    result.put("JOD", new CurrencyDataImpl("JOD","JOD",3,"JOD","JOD"));
    // 日圓
    result.put("JPY", new CurrencyDataImpl("JPY","¥",0,"¥","¥"));
    // 肯尼亞先令
    result.put("KES", new CurrencyDataImpl("KES","KES",2,"KES","KES"));
    // 吉爾吉斯索姆
    result.put("KGS", new CurrencyDataImpl("KGS","KGS",2,"KGS","KGS"));
    // 柬埔寨瑞爾
    result.put("KHR", new CurrencyDataImpl("KHR","KHR",2,"KHR","KHR"));
    // 科摩羅法郎
    result.put("KMF", new CurrencyDataImpl("KMF","KMF",0,"KMF","KMF"));
    // 北韓圓
    result.put("KPW", new CurrencyDataImpl("KPW","KPW",0,"KPW","KPW"));
    // 南韓圜
    result.put("KRH", new CurrencyDataImpl("KRH","KRH",130,"KRH","KRH"));
    // 南韓圓
    result.put("KRO", new CurrencyDataImpl("KRO","KRO",130,"KRO","KRO"));
    // 韓圓
    result.put("KRW", new CurrencyDataImpl("KRW","￦",0,"￦","￦"));
    // 科威特第納爾
    result.put("KWD", new CurrencyDataImpl("KWD","KWD",3,"KWD","KWD"));
    // 開曼群島元
    result.put("KYD", new CurrencyDataImpl("KYD","KYD",2,"KYD","KYD"));
    // 卡扎克斯坦坦吉
    result.put("KZT", new CurrencyDataImpl("KZT","KZT",2,"KZT","KZT"));
    // 寮國基普
    result.put("LAK", new CurrencyDataImpl("LAK","LAK",0,"LAK","LAK"));
    // 黎巴嫩鎊
    result.put("LBP", new CurrencyDataImpl("LBP","LBP",0,"LBP","LBP"));
    // 斯里蘭卡盧比
    result.put("LKR", new CurrencyDataImpl("LKR","LKR",2,"LKR","LKR"));
    // 賴比瑞亞元
    result.put("LRD", new CurrencyDataImpl("LRD","LRD",2,"LRD","LRD"));
    // 賴索托洛蒂
    result.put("LSL", new CurrencyDataImpl("LSL","LSL",2,"LSL","LSL"));
    // 立陶宛立特
    result.put("LTL", new CurrencyDataImpl("LTL","LTL",130,"LTL","LTL"));
    // 立陶宛特羅
    result.put("LTT", new CurrencyDataImpl("LTT","LTT",130,"LTT","LTT"));
    // 盧森堡可兌換法郎
    result.put("LUC", new CurrencyDataImpl("LUC","LUC",130,"LUC","LUC"));
    // 盧森堡法郎
    result.put("LUF", new CurrencyDataImpl("LUF","LUF",128,"LUF","LUF"));
    // 盧森堡金融法郎
    result.put("LUL", new CurrencyDataImpl("LUL","LUL",130,"LUL","LUL"));
    // 拉脫維亞拉特銀幣
    result.put("LVL", new CurrencyDataImpl("LVL","LVL",130,"LVL","LVL"));
    // 拉脫維亞盧布
    result.put("LVR", new CurrencyDataImpl("LVR","LVR",130,"LVR","LVR"));
    // 利比亞第納爾
    result.put("LYD", new CurrencyDataImpl("LYD","LYD",3,"LYD","LYD"));
    // 摩洛哥迪拉姆
    result.put("MAD", new CurrencyDataImpl("MAD","MAD",2,"MAD","MAD"));
    // 摩洛哥法郎
    result.put("MAF", new CurrencyDataImpl("MAF","MAF",130,"MAF","MAF"));
    // 摩納哥法郎
    result.put("MCF", new CurrencyDataImpl("MCF","MCF",130,"MCF","MCF"));
    // 摩爾多瓦券
    result.put("MDC", new CurrencyDataImpl("MDC","MDC",130,"MDC","MDC"));
    // 摩杜雲列伊
    result.put("MDL", new CurrencyDataImpl("MDL","MDL",2,"MDL","MDL"));
    // 馬達加斯加阿里亞里
    result.put("MGA", new CurrencyDataImpl("MGA","MGA",0,"MGA","MGA"));
    // 馬達加斯加法郎
    result.put("MGF", new CurrencyDataImpl("MGF","MGF",128,"MGF","MGF"));
    // 馬其頓第納爾
    result.put("MKD", new CurrencyDataImpl("MKD","MKD",2,"MKD","MKD"));
    // 馬其頓第納爾 (1992–1993)
    result.put("MKN", new CurrencyDataImpl("MKN","MKN",130,"MKN","MKN"));
    // 馬里法郎
    result.put("MLF", new CurrencyDataImpl("MLF","MLF",130,"MLF","MLF"));
    // 緬甸元
    result.put("MMK", new CurrencyDataImpl("MMK","MMK",0,"MMK","MMK"));
    // 蒙古圖格里克
    result.put("MNT", new CurrencyDataImpl("MNT","MNT",2,"MNT","MNT"));
    // 澳門元
    result.put("MOP", new CurrencyDataImpl("MOP","MOP",2,"MOP","MOP"));
    // 茅利塔尼亞烏吉亞 (1973–2017)
    result.put("MRO", new CurrencyDataImpl("MRO","MRO",128,"MRO","MRO"));
    // 茅利塔尼亞烏吉亞
    result.put("MRU", new CurrencyDataImpl("MRU","MRU",2,"MRU","MRU"));
    // 馬爾他里拉
    result.put("MTL", new CurrencyDataImpl("MTL","MTL",130,"MTL","MTL"));
    // 馬爾他鎊
    result.put("MTP", new CurrencyDataImpl("MTP","MTP",130,"MTP","MTP"));
    // 模里西斯盧比
    result.put("MUR", new CurrencyDataImpl("MUR","MUR",2,"MUR","MUR"));
    // 馬爾地夫盧比
    result.put("MVP", new CurrencyDataImpl("MVP","MVP",130,"MVP","MVP"));
    // 馬爾地夫盧非亞
    result.put("MVR", new CurrencyDataImpl("MVR","MVR",2,"MVR","MVR"));
    // 馬拉維克瓦查
    result.put("MWK", new CurrencyDataImpl("MWK","MWK",2,"MWK","MWK"));
    // 墨西哥披索
    result.put("MXN", new CurrencyDataImpl("MXN","MX$",2,"MX$","MX$"));
    // 墨西哥銀披索 (1861–1992)
    result.put("MXP", new CurrencyDataImpl("MXP","MXP",130,"MXP","MXP"));
    // 墨西哥轉換單位 (UDI)
    result.put("MXV", new CurrencyDataImpl("MXV","MXV",130,"MXV","MXV"));
    // 馬來西亞令吉
    result.put("MYR", new CurrencyDataImpl("MYR","MYR",2,"MYR","MYR"));
    // 莫三比克埃斯庫多
    result.put("MZE", new CurrencyDataImpl("MZE","MZE",130,"MZE","MZE"));
    // 莫三比克梅蒂卡爾 (1980–2006)
    result.put("MZM", new CurrencyDataImpl("MZM","MZM",130,"MZM","MZM"));
    // 莫三比克梅蒂卡爾
    result.put("MZN", new CurrencyDataImpl("MZN","MZN",2,"MZN","MZN"));
    // 納米比亞元
    result.put("NAD", new CurrencyDataImpl("NAD","NAD",2,"NAD","NAD"));
    // 奈及利亞奈拉
    result.put("NGN", new CurrencyDataImpl("NGN","NGN",2,"NGN","NGN"));
    // 尼加拉瓜科多巴
    result.put("NIC", new CurrencyDataImpl("NIC","NIC",130,"NIC","NIC"));
    // 尼加拉瓜金科多巴
    result.put("NIO", new CurrencyDataImpl("NIO","NIO",2,"NIO","NIO"));
    // 荷蘭盾
    result.put("NLG", new CurrencyDataImpl("NLG","NLG",130,"NLG","NLG"));
    // 挪威克朗
    result.put("NOK", new CurrencyDataImpl("NOK","NOK",2,"NOK","NOK"));
    // 尼泊爾盧比
    result.put("NPR", new CurrencyDataImpl("NPR","NPR",2,"NPR","NPR"));
    // 紐西蘭幣
    result.put("NZD", new CurrencyDataImpl("NZD","NZ$",2,"NZ$","NZ$"));
    // 阿曼里亞爾
    result.put("OMR", new CurrencyDataImpl("OMR","OMR",3,"OMR","OMR"));
    // 巴拿馬巴波亞
    result.put("PAB", new CurrencyDataImpl("PAB","PAB",2,"PAB","PAB"));
    // 祕魯因蒂
    result.put("PEI", new CurrencyDataImpl("PEI","PEI",130,"PEI","PEI"));
    // 秘魯太陽幣
    result.put("PEN", new CurrencyDataImpl("PEN","PEN",2,"PEN","PEN"));
    // 秘魯索爾 (1863–1965)
    result.put("PES", new CurrencyDataImpl("PES","PES",130,"PES","PES"));
    // 巴布亞紐幾內亞基那
    result.put("PGK", new CurrencyDataImpl("PGK","PGK",2,"PGK","PGK"));
    // 菲律賓披索
    result.put("PHP", new CurrencyDataImpl("PHP","PHP",2,"PHP","PHP"));
    // 巴基斯坦盧比
    result.put("PKR", new CurrencyDataImpl("PKR","PKR",2,"PKR","PKR"));
    // 波蘭茲羅提
    result.put("PLN", new CurrencyDataImpl("PLN","PLN",2,"PLN","PLN"));
    // 波蘭茲羅提 (1950–1995)
    result.put("PLZ", new CurrencyDataImpl("PLZ","PLZ",130,"PLZ","PLZ"));
    // 葡萄牙埃斯庫多
    result.put("PTE", new CurrencyDataImpl("PTE","PTE",130,"PTE","PTE"));
    // 巴拉圭瓜拉尼
    result.put("PYG", new CurrencyDataImpl("PYG","PYG",0,"PYG","PYG"));
    // 卡達里亞爾
    result.put("QAR", new CurrencyDataImpl("QAR","QAR",2,"QAR","QAR"));
    // 羅德西亞元
    result.put("RHD", new CurrencyDataImpl("RHD","RHD",130,"RHD","RHD"));
    // 舊羅馬尼亞列伊
    result.put("ROL", new CurrencyDataImpl("ROL","ROL",130,"ROL","ROL"));
    // 羅馬尼亞列伊
    result.put("RON", new CurrencyDataImpl("RON","RON",2,"RON","RON"));
    // 塞爾維亞戴納
    result.put("RSD", new CurrencyDataImpl("RSD","RSD",0,"RSD","RSD"));
    // 俄羅斯盧布
    result.put("RUB", new CurrencyDataImpl("RUB","RUB",2,"RUB","RUB"));
    // 俄羅斯盧布 (1991–1998)
    result.put("RUR", new CurrencyDataImpl("RUR","RUR",130,"RUR","RUR"));
    // 盧安達法郎
    result.put("RWF", new CurrencyDataImpl("RWF","RWF",0,"RWF","RWF"));
    // 沙烏地里亞爾
    result.put("SAR", new CurrencyDataImpl("SAR","SAR",2,"SAR","SAR"));
    // 索羅門群島元
    result.put("SBD", new CurrencyDataImpl("SBD","SBD",2,"SBD","SBD"));
    // 塞席爾盧比
    result.put("SCR", new CurrencyDataImpl("SCR","SCR",2,"SCR","SCR"));
    // 蘇丹第納爾
    result.put("SDD", new CurrencyDataImpl("SDD","SDD",130,"SDD","SDD"));
    // 蘇丹鎊
    result.put("SDG", new CurrencyDataImpl("SDG","SDG",2,"SDG","SDG"));
    // 舊蘇丹鎊
    result.put("SDP", new CurrencyDataImpl("SDP","SDP",130,"SDP","SDP"));
    // 瑞典克朗
    result.put("SEK", new CurrencyDataImpl("SEK","SEK",2,"SEK","SEK"));
    // 新加坡幣
    result.put("SGD", new CurrencyDataImpl("SGD","SGD",2,"SGD","SGD"));
    // 聖赫勒拿鎊
    result.put("SHP", new CurrencyDataImpl("SHP","SHP",2,"SHP","SHP"));
    // 斯洛維尼亞托勒
    result.put("SIT", new CurrencyDataImpl("SIT","SIT",130,"SIT","SIT"));
    // 斯洛伐克克朗
    result.put("SKK", new CurrencyDataImpl("SKK","SKK",130,"SKK","SKK"));
    // 獅子山利昂
    result.put("SLL", new CurrencyDataImpl("SLL","SLL",0,"SLL","SLL"));
    // 索馬利亞先令
    result.put("SOS", new CurrencyDataImpl("SOS","SOS",0,"SOS","SOS"));
    // 蘇利南元
    result.put("SRD", new CurrencyDataImpl("SRD","SRD",2,"SRD","SRD"));
    // 蘇利南基爾
    result.put("SRG", new CurrencyDataImpl("SRG","SRG",130,"SRG","SRG"));
    // 南蘇丹鎊
    result.put("SSP", new CurrencyDataImpl("SSP","SSP",2,"SSP","SSP"));
    // 聖多美島和普林西比島多布拉 (1977–2017)
    result.put("STD", new CurrencyDataImpl("STD","STD",128,"STD","STD"));
    // 聖多美島和普林西比島多布拉
    result.put("STN", new CurrencyDataImpl("STN","STN",2,"STN","STN"));
    // 蘇聯盧布
    result.put("SUR", new CurrencyDataImpl("SUR","SUR",130,"SUR","SUR"));
    // 薩爾瓦多科郎
    result.put("SVC", new CurrencyDataImpl("SVC","SVC",130,"SVC","SVC"));
    // 敘利亞鎊
    result.put("SYP", new CurrencyDataImpl("SYP","SYP",0,"SYP","SYP"));
    // 史瓦濟蘭里朗吉尼
    result.put("SZL", new CurrencyDataImpl("SZL","SZL",2,"SZL","SZL"));
    // 泰銖
    result.put("THB", new CurrencyDataImpl("THB","THB",2,"THB","THB"));
    // 塔吉克盧布
    result.put("TJR", new CurrencyDataImpl("TJR","TJR",130,"TJR","TJR"));
    // 塔吉克索莫尼
    result.put("TJS", new CurrencyDataImpl("TJS","TJS",2,"TJS","TJS"));
    // 土庫曼馬納特 (1993–2009)
    result.put("TMM", new CurrencyDataImpl("TMM","TMM",128,"TMM","TMM"));
    // 土庫曼馬納特
    result.put("TMT", new CurrencyDataImpl("TMT","TMT",2,"TMT","TMT"));
    // 突尼西亞第納爾
    result.put("TND", new CurrencyDataImpl("TND","TND",3,"TND","TND"));
    // 東加潘加
    result.put("TOP", new CurrencyDataImpl("TOP","TOP",2,"TOP","TOP"));
    // 帝汶埃斯庫多
    result.put("TPE", new CurrencyDataImpl("TPE","TPE",130,"TPE","TPE"));
    // 土耳其里拉
    result.put("TRL", new CurrencyDataImpl("TRL","TRL",128,"TRL","TRL"));
    // 新土耳其里拉
    result.put("TRY", new CurrencyDataImpl("TRY","TL",2,"TL","TL"));
    // 千里達及托巴哥元
    result.put("TTD", new CurrencyDataImpl("TTD","TTD",2,"TTD","TTD"));
    // 新台幣
    result.put("TWD", new CurrencyDataImpl("TWD","NT$",2,"NT$","NT$"));
    // 坦尚尼亞先令
    result.put("TZS", new CurrencyDataImpl("TZS","TZS",2,"TZS","TZS"));
    // 烏克蘭格里夫納
    result.put("UAH", new CurrencyDataImpl("UAH","UAH",2,"UAH","UAH"));
    // 烏克蘭卡本瓦那茲
    result.put("UAK", new CurrencyDataImpl("UAK","UAK",130,"UAK","UAK"));
    // 烏干達先令 (1966–1987)
    result.put("UGS", new CurrencyDataImpl("UGS","UGS",130,"UGS","UGS"));
    // 烏干達先令
    result.put("UGX", new CurrencyDataImpl("UGX","UGX",0,"UGX","UGX"));
    // 美元
    result.put("USD", new CurrencyDataImpl("USD","US$",2,"US$","US$"));
    // 美元（次日）
    result.put("USN", new CurrencyDataImpl("USN","USN",130,"USN","USN"));
    // 美元（當日）
    result.put("USS", new CurrencyDataImpl("USS","USS",130,"USS","USS"));
    // 烏拉圭披索（指數單位）
    result.put("UYI", new CurrencyDataImpl("UYI","UYI",128,"UYI","UYI"));
    // 烏拉圭披索 (1975–1993)
    result.put("UYP", new CurrencyDataImpl("UYP","UYP",130,"UYP","UYP"));
    // 烏拉圭披索
    result.put("UYU", new CurrencyDataImpl("UYU","UYU",2,"UYU","UYU"));
    // UYW
    result.put("UYW", new CurrencyDataImpl("UYW","UYW",132,"UYW","UYW"));
    // 烏茲別克索姆
    result.put("UZS", new CurrencyDataImpl("UZS","UZS",2,"UZS","UZS"));
    // 委內瑞拉玻利瓦 (1871–2008)
    result.put("VEB", new CurrencyDataImpl("VEB","VEB",130,"VEB","VEB"));
    // 委內瑞拉玻利瓦 (VEF)
    result.put("VEF", new CurrencyDataImpl("VEF","VEF",130,"VEF","VEF"));
    // 委內瑞拉玻利瓦
    result.put("VES", new CurrencyDataImpl("VES","VES",2,"VES","VES"));
    // 越南盾
    result.put("VND", new CurrencyDataImpl("VND","₫",0,"₫","₫"));
    // 越南盾 (1978–1985)
    result.put("VNN", new CurrencyDataImpl("VNN","VNN",130,"VNN","VNN"));
    // 萬那杜瓦圖
    result.put("VUV", new CurrencyDataImpl("VUV","VUV",0,"VUV","VUV"));
    // 西薩摩亞塔拉
    result.put("WST", new CurrencyDataImpl("WST","WST",2,"WST","WST"));
    // 法郎 (CFA–BEAC)
    result.put("XAF", new CurrencyDataImpl("XAF","FCFA",0,"FCFA","FCFA"));
    // 白銀
    result.put("XAG", new CurrencyDataImpl("XAG","XAG",130,"XAG","XAG"));
    // 黃金
    result.put("XAU", new CurrencyDataImpl("XAU","XAU",130,"XAU","XAU"));
    // 歐洲綜合單位
    result.put("XBA", new CurrencyDataImpl("XBA","XBA",130,"XBA","XBA"));
    // 歐洲貨幣單位 (XBB)
    result.put("XBB", new CurrencyDataImpl("XBB","XBB",130,"XBB","XBB"));
    // 歐洲會計單位 (XBC)
    result.put("XBC", new CurrencyDataImpl("XBC","XBC",130,"XBC","XBC"));
    // 歐洲會計單位 (XBD)
    result.put("XBD", new CurrencyDataImpl("XBD","XBD",130,"XBD","XBD"));
    // 格瑞那達元
    result.put("XCD", new CurrencyDataImpl("XCD","EC$",2,"EC$","EC$"));
    // 特殊提款權
    result.put("XDR", new CurrencyDataImpl("XDR","XDR",130,"XDR","XDR"));
    // 歐洲貨幣單位 (XEU)
    result.put("XEU", new CurrencyDataImpl("XEU","XEU",130,"XEU","XEU"));
    // 法國金法郎
    result.put("XFO", new CurrencyDataImpl("XFO","XFO",130,"XFO","XFO"));
    // 法國法郎 (UIC)
    result.put("XFU", new CurrencyDataImpl("XFU","XFU",130,"XFU","XFU"));
    // 法郎 (CFA–BCEAO)
    result.put("XOF", new CurrencyDataImpl("XOF","CFA",0,"CFA","CFA"));
    // 帕拉狄昂
    result.put("XPD", new CurrencyDataImpl("XPD","XPD",130,"XPD","XPD"));
    // 法郎 (CFP)
    result.put("XPF", new CurrencyDataImpl("XPF","CFPF",0,"CFPF","CFPF"));
    // 白金
    result.put("XPT", new CurrencyDataImpl("XPT","XPT",130,"XPT","XPT"));
    // RINET 基金
    result.put("XRE", new CurrencyDataImpl("XRE","XRE",130,"XRE","XRE"));
    // 蘇克雷貨幣
    result.put("XSU", new CurrencyDataImpl("XSU","XSU",130,"XSU","XSU"));
    // 測試用貨幣代碼
    result.put("XTS", new CurrencyDataImpl("XTS","XTS",130,"XTS","XTS"));
    // 亞洲開發銀行計價單位
    result.put("XUA", new CurrencyDataImpl("XUA","XUA",130,"XUA","XUA"));
    // 未知貨幣
    result.put("XXX", new CurrencyDataImpl("XXX","XXX",130,"XXX","XXX"));
    // 葉門第納爾
    result.put("YDD", new CurrencyDataImpl("YDD","YDD",130,"YDD","YDD"));
    // 葉門里亞爾
    result.put("YER", new CurrencyDataImpl("YER","YER",0,"YER","YER"));
    // 南斯拉夫第納爾硬幣
    result.put("YUD", new CurrencyDataImpl("YUD","YUD",130,"YUD","YUD"));
    // 南斯拉夫挪威亞第納爾
    result.put("YUM", new CurrencyDataImpl("YUM","YUM",130,"YUM","YUM"));
    // 南斯拉夫可轉換第納爾
    result.put("YUN", new CurrencyDataImpl("YUN","YUN",130,"YUN","YUN"));
    // 南斯拉夫改革第納爾 (1992–1993)
    result.put("YUR", new CurrencyDataImpl("YUR","YUR",130,"YUR","YUR"));
    // 南非蘭特（金融）
    result.put("ZAL", new CurrencyDataImpl("ZAL","ZAL",130,"ZAL","ZAL"));
    // 南非蘭特
    result.put("ZAR", new CurrencyDataImpl("ZAR","ZAR",2,"ZAR","ZAR"));
    // 尚比亞克瓦查 (1968–2012)
    result.put("ZMK", new CurrencyDataImpl("ZMK","ZMK",128,"ZMK","ZMK"));
    // 尚比亞克瓦查
    result.put("ZMW", new CurrencyDataImpl("ZMW","ZMW",2,"ZMW","ZMW"));
    // 薩伊新扎伊爾
    result.put("ZRN", new CurrencyDataImpl("ZRN","ZRN",130,"ZRN","ZRN"));
    // 薩伊扎伊爾
    result.put("ZRZ", new CurrencyDataImpl("ZRZ","ZRZ",130,"ZRZ","ZRZ"));
    // 辛巴威元 (1980–2008)
    result.put("ZWD", new CurrencyDataImpl("ZWD","ZWD",128,"ZWD","ZWD"));
    // 辛巴威元 (2009)
    result.put("ZWL", new CurrencyDataImpl("ZWL","ZWL",130,"ZWL","ZWL"));
    // 辛巴威元 (2008)
    result.put("ZWR", new CurrencyDataImpl("ZWR","ZWR",130,"ZWR","ZWR"));
    return result;
  }

  @Override
  protected HashMap<String, String> loadNamesMap() {
    HashMap<String, String> result = super.loadNamesMap();
    result.put("ADP","安道爾陪士特");
    result.put("AED","阿拉伯聯合大公國迪爾汗");
    result.put("AFA","阿富汗尼 (1927–2002)");
    result.put("AFN","阿富汗尼");
    result.put("ALK","阿爾巴尼亞列克 (1946–1965)");
    result.put("ALL","阿爾巴尼亞列克");
    result.put("AMD","亞美尼亞德拉姆");
    result.put("ANG","荷屬安地列斯盾");
    result.put("AOA","安哥拉寬扎");
    result.put("AOK","安哥拉寬扎 (1977–1990)");
    result.put("AON","安哥拉新寬扎 (1990–2000)");
    result.put("AOR","安哥拉新調寬扎 (1995–1999)");
    result.put("ARA","阿根廷奧斯特納爾");
    result.put("ARL","阿根廷披索 (1970–1983)");
    result.put("ARM","阿根廷披索 (1881–1970)");
    result.put("ARP","阿根廷披索 (1983–1985)");
    result.put("ARS","阿根廷披索");
    result.put("ATS","奧地利先令");
    result.put("AUD","澳幣");
    result.put("AWG","阿路巴盾");
    result.put("AZM","亞塞拜然馬納特 (1993–2006)");
    result.put("AZN","亞塞拜然馬納特");
    result.put("BAD","波士尼亞-赫塞哥維納第納爾");
    result.put("BAM","波士尼亞-赫塞哥維納可轉換馬克");
    result.put("BAN","波士尼亞-赫塞哥維納新第納爾");
    result.put("BBD","巴貝多元");
    result.put("BDT","孟加拉塔卡");
    result.put("BEC","比利時法郎（可轉換）");
    result.put("BEF","比利時法郎");
    result.put("BEL","比利時法郎（金融）");
    result.put("BGL","保加利亞硬列弗");
    result.put("BGM","保加利亞社會黨列弗");
    result.put("BGN","保加利亞新列弗");
    result.put("BGO","保加利亞列弗 (1879–1952)");
    result.put("BHD","巴林第納爾");
    result.put("BIF","蒲隆地法郎");
    result.put("BMD","百慕達幣");
    result.put("BND","汶萊元");
    result.put("BOB","玻利維亞諾");
    result.put("BOL","玻利維亞玻利維亞諾 (1863–1963)");
    result.put("BOP","玻利維亞披索");
    result.put("BOV","玻利維亞幕多");
    result.put("BRB","巴西克魯薩多農瓦 (1967–1986)");
    result.put("BRC","巴西克魯賽羅 (1986–1989)");
    result.put("BRE","巴西克魯賽羅 (1990–1993)");
    result.put("BRL","巴西里拉");
    result.put("BRN","巴西克如爾達農瓦");
    result.put("BRR","巴西克魯賽羅 (1993–1994)");
    result.put("BRZ","巴西克魯賽羅 (1942 –1967)");
    result.put("BSD","巴哈馬元");
    result.put("BTN","不丹那特倫");
    result.put("BUK","緬甸基雅特");
    result.put("BWP","波札那普拉");
    result.put("BYB","白俄羅斯新盧布 (1994–1999)");
    result.put("BYN","白俄羅斯盧布");
    result.put("BYR","白俄羅斯盧布 (2000–2016)");
    result.put("BZD","貝里斯元");
    result.put("CAD","加幣");
    result.put("CDF","剛果法郎");
    result.put("CHE","歐元 (WIR)");
    result.put("CHF","瑞士法郎");
    result.put("CHW","法郎 (WIR)");
    result.put("CLE","智利埃斯庫多");
    result.put("CLF","卡林油達佛曼跎");
    result.put("CLP","智利披索");
    result.put("CNH","人民幣 (離岸)");
    result.put("CNY","人民幣");
    result.put("COP","哥倫比亞披索");
    result.put("COU","哥倫比亞幣 (COU)");
    result.put("CRC","哥斯大黎加科朗");
    result.put("CSD","舊塞爾維亞第納爾");
    result.put("CSK","捷克斯洛伐克硬克朗");
    result.put("CUC","古巴可轉換披索");
    result.put("CUP","古巴披索");
    result.put("CVE","維德角埃斯庫多");
    result.put("CYP","賽普勒斯鎊");
    result.put("CZK","捷克克朗");
    result.put("DDM","東德奧斯特馬克");
    result.put("DEM","德國馬克");
    result.put("DJF","吉布地法郎");
    result.put("DKK","丹麥克朗");
    result.put("DOP","多明尼加披索");
    result.put("DZD","阿爾及利亞第納爾");
    result.put("ECS","厄瓜多蘇克雷");
    result.put("ECV","厄瓜多爾由里達瓦康斯坦 (UVC)");
    result.put("EEK","愛沙尼亞克朗");
    result.put("EGP","埃及鎊");
    result.put("ERN","厄立特里亞納克法");
    result.put("ESA","西班牙比塞塔（會計單位）");
    result.put("ESB","西班牙比塞塔（可轉換會計單位）");
    result.put("ESP","西班牙陪士特");
    result.put("ETB","衣索比亞比爾");
    result.put("EUR","歐元");
    result.put("FIM","芬蘭馬克");
    result.put("FJD","斐濟元");
    result.put("FKP","福克蘭群島鎊");
    result.put("FRF","法國法郎");
    result.put("GBP","英鎊");
    result.put("GEK","喬治亞庫旁拉里");
    result.put("GEL","喬治亞拉里");
    result.put("GHC","迦納賽地 (1979–2007)");
    result.put("GHS","迦納塞地");
    result.put("GIP","直布羅陀鎊");
    result.put("GMD","甘比亞達拉西");
    result.put("GNF","幾內亞法郎");
    result.put("GNS","幾內亞西里");
    result.put("GQE","赤道幾內亞埃奎勒");
    result.put("GRD","希臘德拉克馬");
    result.put("GTQ","瓜地馬拉格查爾");
    result.put("GWE","葡屬幾內亞埃斯庫多");
    result.put("GWP","幾內亞比索披索");
    result.put("GYD","圭亞那元");
    result.put("HKD","港幣");
    result.put("HNL","洪都拉斯倫皮拉");
    result.put("HRD","克羅埃西亞第納爾");
    result.put("HRK","克羅埃西亞庫納");
    result.put("HTG","海地古德");
    result.put("HUF","匈牙利福林");
    result.put("IDR","印尼盾");
    result.put("IEP","愛爾蘭鎊");
    result.put("ILP","以色列鎊");
    result.put("ILR","以色列謝克爾 (1980–1985)");
    result.put("ILS","以色列新謝克爾");
    result.put("INR","印度盧比");
    result.put("IQD","伊拉克第納爾");
    result.put("IRR","伊朗里亞爾");
    result.put("ISJ","冰島克朗 (1918–1981)");
    result.put("ISK","冰島克朗");
    result.put("ITL","義大利里拉");
    result.put("JMD","牙買加元");
    result.put("JOD","約旦第納爾");
    result.put("JPY","日圓");
    result.put("KES","肯尼亞先令");
    result.put("KGS","吉爾吉斯索姆");
    result.put("KHR","柬埔寨瑞爾");
    result.put("KMF","科摩羅法郎");
    result.put("KPW","北韓圓");
    result.put("KRH","南韓圜");
    result.put("KRO","南韓圓");
    result.put("KRW","韓圓");
    result.put("KWD","科威特第納爾");
    result.put("KYD","開曼群島元");
    result.put("KZT","卡扎克斯坦坦吉");
    result.put("LAK","寮國基普");
    result.put("LBP","黎巴嫩鎊");
    result.put("LKR","斯里蘭卡盧比");
    result.put("LRD","賴比瑞亞元");
    result.put("LSL","賴索托洛蒂");
    result.put("LTL","立陶宛立特");
    result.put("LTT","立陶宛特羅");
    result.put("LUC","盧森堡可兌換法郎");
    result.put("LUF","盧森堡法郎");
    result.put("LUL","盧森堡金融法郎");
    result.put("LVL","拉脫維亞拉特銀幣");
    result.put("LVR","拉脫維亞盧布");
    result.put("LYD","利比亞第納爾");
    result.put("MAD","摩洛哥迪拉姆");
    result.put("MAF","摩洛哥法郎");
    result.put("MCF","摩納哥法郎");
    result.put("MDC","摩爾多瓦券");
    result.put("MDL","摩杜雲列伊");
    result.put("MGA","馬達加斯加阿里亞里");
    result.put("MGF","馬達加斯加法郎");
    result.put("MKD","馬其頓第納爾");
    result.put("MKN","馬其頓第納爾 (1992–1993)");
    result.put("MLF","馬里法郎");
    result.put("MMK","緬甸元");
    result.put("MNT","蒙古圖格里克");
    result.put("MOP","澳門元");
    result.put("MRO","茅利塔尼亞烏吉亞 (1973–2017)");
    result.put("MRU","茅利塔尼亞烏吉亞");
    result.put("MTL","馬爾他里拉");
    result.put("MTP","馬爾他鎊");
    result.put("MUR","模里西斯盧比");
    result.put("MVP","馬爾地夫盧比");
    result.put("MVR","馬爾地夫盧非亞");
    result.put("MWK","馬拉維克瓦查");
    result.put("MXN","墨西哥披索");
    result.put("MXP","墨西哥銀披索 (1861–1992)");
    result.put("MXV","墨西哥轉換單位 (UDI)");
    result.put("MYR","馬來西亞令吉");
    result.put("MZE","莫三比克埃斯庫多");
    result.put("MZM","莫三比克梅蒂卡爾 (1980–2006)");
    result.put("MZN","莫三比克梅蒂卡爾");
    result.put("NAD","納米比亞元");
    result.put("NGN","奈及利亞奈拉");
    result.put("NIC","尼加拉瓜科多巴");
    result.put("NIO","尼加拉瓜金科多巴");
    result.put("NLG","荷蘭盾");
    result.put("NOK","挪威克朗");
    result.put("NPR","尼泊爾盧比");
    result.put("NZD","紐西蘭幣");
    result.put("OMR","阿曼里亞爾");
    result.put("PAB","巴拿馬巴波亞");
    result.put("PEI","祕魯因蒂");
    result.put("PEN","秘魯太陽幣");
    result.put("PES","秘魯索爾 (1863–1965)");
    result.put("PGK","巴布亞紐幾內亞基那");
    result.put("PHP","菲律賓披索");
    result.put("PKR","巴基斯坦盧比");
    result.put("PLN","波蘭茲羅提");
    result.put("PLZ","波蘭茲羅提 (1950–1995)");
    result.put("PTE","葡萄牙埃斯庫多");
    result.put("PYG","巴拉圭瓜拉尼");
    result.put("QAR","卡達里亞爾");
    result.put("RHD","羅德西亞元");
    result.put("ROL","舊羅馬尼亞列伊");
    result.put("RON","羅馬尼亞列伊");
    result.put("RSD","塞爾維亞戴納");
    result.put("RUB","俄羅斯盧布");
    result.put("RUR","俄羅斯盧布 (1991–1998)");
    result.put("RWF","盧安達法郎");
    result.put("SAR","沙烏地里亞爾");
    result.put("SBD","索羅門群島元");
    result.put("SCR","塞席爾盧比");
    result.put("SDD","蘇丹第納爾");
    result.put("SDG","蘇丹鎊");
    result.put("SDP","舊蘇丹鎊");
    result.put("SEK","瑞典克朗");
    result.put("SGD","新加坡幣");
    result.put("SHP","聖赫勒拿鎊");
    result.put("SIT","斯洛維尼亞托勒");
    result.put("SKK","斯洛伐克克朗");
    result.put("SLL","獅子山利昂");
    result.put("SOS","索馬利亞先令");
    result.put("SRD","蘇利南元");
    result.put("SRG","蘇利南基爾");
    result.put("SSP","南蘇丹鎊");
    result.put("STD","聖多美島和普林西比島多布拉 (1977–2017)");
    result.put("STN","聖多美島和普林西比島多布拉");
    result.put("SUR","蘇聯盧布");
    result.put("SVC","薩爾瓦多科郎");
    result.put("SYP","敘利亞鎊");
    result.put("SZL","史瓦濟蘭里朗吉尼");
    result.put("THB","泰銖");
    result.put("TJR","塔吉克盧布");
    result.put("TJS","塔吉克索莫尼");
    result.put("TMM","土庫曼馬納特 (1993–2009)");
    result.put("TMT","土庫曼馬納特");
    result.put("TND","突尼西亞第納爾");
    result.put("TOP","東加潘加");
    result.put("TPE","帝汶埃斯庫多");
    result.put("TRL","土耳其里拉");
    result.put("TRY","新土耳其里拉");
    result.put("TTD","千里達及托巴哥元");
    result.put("TWD","新台幣");
    result.put("TZS","坦尚尼亞先令");
    result.put("UAH","烏克蘭格里夫納");
    result.put("UAK","烏克蘭卡本瓦那茲");
    result.put("UGS","烏干達先令 (1966–1987)");
    result.put("UGX","烏干達先令");
    result.put("USD","美元");
    result.put("USN","美元（次日）");
    result.put("USS","美元（當日）");
    result.put("UYI","烏拉圭披索（指數單位）");
    result.put("UYP","烏拉圭披索 (1975–1993)");
    result.put("UYU","烏拉圭披索");
    result.put("UZS","烏茲別克索姆");
    result.put("VEB","委內瑞拉玻利瓦 (1871–2008)");
    result.put("VEF","委內瑞拉玻利瓦 (VEF)");
    result.put("VES","委內瑞拉玻利瓦");
    result.put("VND","越南盾");
    result.put("VNN","越南盾 (1978–1985)");
    result.put("VUV","萬那杜瓦圖");
    result.put("WST","西薩摩亞塔拉");
    result.put("XAF","法郎 (CFA–BEAC)");
    result.put("XAG","白銀");
    result.put("XAU","黃金");
    result.put("XBA","歐洲綜合單位");
    result.put("XBB","歐洲貨幣單位 (XBB)");
    result.put("XBC","歐洲會計單位 (XBC)");
    result.put("XBD","歐洲會計單位 (XBD)");
    result.put("XCD","格瑞那達元");
    result.put("XDR","特殊提款權");
    result.put("XEU","歐洲貨幣單位 (XEU)");
    result.put("XFO","法國金法郎");
    result.put("XFU","法國法郎 (UIC)");
    result.put("XOF","法郎 (CFA–BCEAO)");
    result.put("XPD","帕拉狄昂");
    result.put("XPF","法郎 (CFP)");
    result.put("XPT","白金");
    result.put("XRE","RINET 基金");
    result.put("XSU","蘇克雷貨幣");
    result.put("XTS","測試用貨幣代碼");
    result.put("XUA","亞洲開發銀行計價單位");
    result.put("XXX","未知貨幣");
    result.put("YDD","葉門第納爾");
    result.put("YER","葉門里亞爾");
    result.put("YUD","南斯拉夫第納爾硬幣");
    result.put("YUM","南斯拉夫挪威亞第納爾");
    result.put("YUN","南斯拉夫可轉換第納爾");
    result.put("YUR","南斯拉夫改革第納爾 (1992–1993)");
    result.put("ZAL","南非蘭特（金融）");
    result.put("ZAR","南非蘭特");
    result.put("ZMK","尚比亞克瓦查 (1968–2012)");
    result.put("ZMW","尚比亞克瓦查");
    result.put("ZRN","薩伊新扎伊爾");
    result.put("ZRZ","薩伊扎伊爾");
    result.put("ZWD","辛巴威元 (1980–2008)");
    result.put("ZWL","辛巴威元 (2009)");
    result.put("ZWR","辛巴威元 (2008)");
    return result;
  }
}
