/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.cldr.impl;
// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA

/**
 * Implementation of DateTimeFormatInfo for the "lv_LV" locale.
 */

import org.gwtproject.i18n.shared.cldr.DateTimeFormatInfoImpl;

public class DateTimeFormatInfoImpl_lv_LV extends DateTimeFormatInfoImpl_lv {

  @Override
  public String[] ampms() {
    return new String[] {
        "priekšp.",
        "pēcp."
    };
  }

  @Override
  public String dateFormat() {
    return dateFormatMedium();
  }

  @Override
  public String dateFormatFull() {
    return "EEEE, y. 'gada' d. MMMM";
  }

  @Override
  public String dateFormatLong() {
    return "y. 'gada' d. MMMM";
  }

  @Override
  public String dateFormatMedium() {
    return "y. 'gada' d. MMM";
  }

  @Override
  public String dateFormatShort() {
    return "dd.MM.yy";
  }

  @Override
  public String dateTime(String timePattern, String datePattern) {
    return dateTimeMedium(timePattern, datePattern);
  }

  @Override
  public String dateTimeFull(String timePattern, String datePattern) {
    return datePattern + " " + timePattern;
  }

  @Override
  public String dateTimeLong(String timePattern, String datePattern) {
    return datePattern + " " + timePattern;
  }

  @Override
  public String dateTimeMedium(String timePattern, String datePattern) {
    return datePattern + " " + timePattern;
  }

  @Override
  public String dateTimeShort(String timePattern, String datePattern) {
    return datePattern + " " + timePattern;
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "pirms mūsu ēras",
        "mūsu ērā"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "p.m.ē.",
        "m.ē."
    };
  }

  @Override
  public int firstDayOfTheWeek() {
    return 1;
  }

  @Override
  public String formatDay() {
    return "d";
  }

  @Override
  public String formatHour12Minute() {
    return "h:mm a";
  }

  @Override
  public String formatHour12MinuteSecond() {
    return "h:mm:ss a";
  }

  @Override
  public String formatHour24Minute() {
    return "HH:mm";
  }

  @Override
  public String formatHour24MinuteSecond() {
    return "HH:mm:ss";
  }

  @Override
  public String formatMinuteSecond() {
    return "mm:ss";
  }

  @Override
  public String formatMonthAbbrev() {
    return "LLL";
  }

  @Override
  public String formatMonthAbbrevDay() {
    return "d. MMM";
  }

  @Override
  public String formatMonthFull() {
    return "LLLL";
  }

  @Override
  public String formatMonthFullDay() {
    return "d. MMMM";
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "EEEE, d. MMMM";
  }

  @Override
  public String formatMonthNumDay() {
    return "dd.MM.";
  }

  @Override
  public String formatYear() {
    return "y. 'g'.";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "y. 'g'. MMM";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "y. 'g'. d. MMM";
  }

  @Override
  public String formatYearMonthFull() {
    return "y. 'g'. MMMM";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "y. 'gada' d. MMMM";
  }

  @Override
  public String formatYearMonthNum() {
    return "MM.y.";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "y.MM.d.";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "EEE, y. 'g'. d. MMM";
  }

  @Override
  public String formatYearQuarterFull() {
    return "y. 'g'. QQQQ";
  }

  @Override
  public String formatYearQuarterShort() {
    return "y. 'g'. Q";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "janvāris",
        "februāris",
        "marts",
        "aprīlis",
        "maijs",
        "jūnijs",
        "jūlijs",
        "augusts",
        "septembris",
        "oktobris",
        "novembris",
        "decembris"
    };
  }

  @Override
  public String[] monthsFullStandalone() {
    return monthsFull();
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "J",
        "F",
        "M",
        "A",
        "M",
        "J",
        "J",
        "A",
        "S",
        "O",
        "N",
        "D"
    };
  }

  @Override
  public String[] monthsNarrowStandalone() {
    return monthsNarrow();
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "janv.",
        "febr.",
        "marts",
        "apr.",
        "maijs",
        "jūn.",
        "jūl.",
        "aug.",
        "sept.",
        "okt.",
        "nov.",
        "dec."
    };
  }

  @Override
  public String[] monthsShortStandalone() {
    return monthsShort();
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "1. ceturksnis",
        "2. ceturksnis",
        "3. ceturksnis",
        "4. ceturksnis"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "1. cet.",
        "2. cet.",
        "3. cet.",
        "4. cet."
    };
  }

  @Override
  public String timeFormat() {
    return timeFormatMedium();
  }

  @Override
  public String timeFormatFull() {
    return "HH:mm:ss zzzz";
  }

  @Override
  public String timeFormatLong() {
    return "HH:mm:ss z";
  }

  @Override
  public String timeFormatMedium() {
    return "HH:mm:ss";
  }

  @Override
  public String timeFormatShort() {
    return "HH:mm";
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "svētdiena",
        "pirmdiena",
        "otrdiena",
        "trešdiena",
        "ceturtdiena",
        "piektdiena",
        "sestdiena"
    };
  }

  @Override
  public String[] weekdaysFullStandalone() {
    return new String[] {
        "Svētdiena",
        "Pirmdiena",
        "Otrdiena",
        "Trešdiena",
        "Ceturtdiena",
        "Piektdiena",
        "Sestdiena"
    };
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "S",
        "P",
        "O",
        "T",
        "C",
        "P",
        "S"
    };
  }

  @Override
  public String[] weekdaysNarrowStandalone() {
    return weekdaysNarrow();
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "svētd.",
        "pirmd.",
        "otrd.",
        "trešd.",
        "ceturtd.",
        "piektd.",
        "sestd."
    };
  }

  @Override
  public String[] weekdaysShortStandalone() {
    return new String[] {
        "Svētd.",
        "Pirmd.",
        "Otrd.",
        "Trešd.",
        "Ceturtd.",
        "Piektd.",
        "Sestd."
    };
  }

  @Override
  public int weekendEnd() {
    return 0;
  }

  @Override
  public int weekendStart() {
    return 6;
  }
}
