/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.cldr.impl;
// DO NOT EDIT - GENERATED FROM CLDR AND ICU DATA

/**
 * Implementation of DateTimeFormatInfo for the "mn_MN" locale.
 */

import org.gwtproject.i18n.shared.cldr.DateTimeFormatInfoImpl;

public class DateTimeFormatInfoImpl_mn_MN extends DateTimeFormatInfoImpl_mn {

  @Override
  public String[] ampms() {
    return new String[] {
        "ү.ө.",
        "ү.х."
    };
  }

  @Override
  public String dateFormat() {
    return dateFormatMedium();
  }

  @Override
  public String dateFormatFull() {
    return "y.MM.dd, EEEE";
  }

  @Override
  public String dateFormatLong() {
    return "y.MM.dd";
  }

  @Override
  public String dateFormatMedium() {
    return "y 'оны' MMM'ын' d";
  }

  @Override
  public String dateFormatShort() {
    return "y.MM.dd";
  }

  @Override
  public String dateTime(String timePattern, String datePattern) {
    return dateTimeMedium(timePattern, datePattern);
  }

  @Override
  public String dateTimeFull(String timePattern, String datePattern) {
    return datePattern + " " + timePattern;
  }

  @Override
  public String dateTimeLong(String timePattern, String datePattern) {
    return datePattern + " " + timePattern;
  }

  @Override
  public String dateTimeMedium(String timePattern, String datePattern) {
    return datePattern + " " + timePattern;
  }

  @Override
  public String dateTimeShort(String timePattern, String datePattern) {
    return datePattern + " " + timePattern;
  }

  @Override
  public String[] erasFull() {
    return new String[] {
        "манай эриний өмнөх",
        "манай эриний"
    };
  }

  @Override
  public String[] erasShort() {
    return new String[] {
        "МЭӨ",
        "МЭ"
    };
  }

  @Override
  public int firstDayOfTheWeek() {
    return 1;
  }

  @Override
  public String formatDay() {
    return "d";
  }

  @Override
  public String formatHour12Minute() {
    return "h:mm a";
  }

  @Override
  public String formatHour12MinuteSecond() {
    return "h:mm:ss a";
  }

  @Override
  public String formatHour24Minute() {
    return "HH:mm";
  }

  @Override
  public String formatHour24MinuteSecond() {
    return "HH:mm:ss";
  }

  @Override
  public String formatMinuteSecond() {
    return "mm:ss";
  }

  @Override
  public String formatMonthAbbrev() {
    return "LLL";
  }

  @Override
  public String formatMonthAbbrevDay() {
    return "MMM'ын' d";
  }

  @Override
  public String formatMonthFull() {
    return "LLLL";
  }

  @Override
  public String formatMonthFullDay() {
    return "MMMM'ын' d";
  }

  @Override
  public String formatMonthFullWeekdayDay() {
    return "MMMM'ын' d. EEEE";
  }

  @Override
  public String formatMonthNumDay() {
    return "MMMMM/dd";
  }

  @Override
  public String formatYear() {
    return "y";
  }

  @Override
  public String formatYearMonthAbbrev() {
    return "y 'оны' MMM";
  }

  @Override
  public String formatYearMonthAbbrevDay() {
    return "y 'оны' MMM'ын' d";
  }

  @Override
  public String formatYearMonthFull() {
    return "y 'оны' MMM";
  }

  @Override
  public String formatYearMonthFullDay() {
    return "y 'оны' MMMM'ын' d";
  }

  @Override
  public String formatYearMonthNum() {
    return "y MMMMM";
  }

  @Override
  public String formatYearMonthNumDay() {
    return "y.MM.dd";
  }

  @Override
  public String formatYearMonthWeekdayDay() {
    return "y 'оны' MMM'ын' d. EEE";
  }

  @Override
  public String formatYearQuarterFull() {
    return "y 'оны' QQQQ";
  }

  @Override
  public String formatYearQuarterShort() {
    return "y 'оны' Q";
  }

  @Override
  public String[] monthsFull() {
    return new String[] {
        "нэгдүгээр сар",
        "хоёрдугаар сар",
        "гуравдугаар сар",
        "дөрөвдүгээр сар",
        "тавдугаар сар",
        "зургаадугаар сар",
        "долоодугаар сар",
        "наймдугаар сар",
        "есдүгээр сар",
        "аравдугаар сар",
        "арван нэгдүгээр сар",
        "арван хоёрдугаар сар"
    };
  }

  @Override
  public String[] monthsFullStandalone() {
    return new String[] {
        "Нэгдүгээр сар",
        "Хоёрдугаар сар",
        "Гуравдугаар сар",
        "Дөрөвдүгээр сар",
        "Тавдугаар сар",
        "Зургаадугаар сар",
        "Долоодугаар сар",
        "Наймдугаар сар",
        "Есдүгээр сар",
        "Аравдугаар сар",
        "Арван нэгдүгээр сар",
        "Арван хоёрдугаар сар"
    };
  }

  @Override
  public String[] monthsNarrow() {
    return new String[] {
        "I",
        "II",
        "III",
        "IV",
        "V",
        "VI",
        "VII",
        "VIII",
        "IX",
        "X",
        "XI",
        "XII"
    };
  }

  @Override
  public String[] monthsNarrowStandalone() {
    return monthsNarrow();
  }

  @Override
  public String[] monthsShort() {
    return new String[] {
        "1-р сар",
        "2-р сар",
        "3-р сар",
        "4-р сар",
        "5-р сар",
        "6-р сар",
        "7-р сар",
        "8-р сар",
        "9-р сар",
        "10-р сар",
        "11-р сар",
        "12-р сар"
    };
  }

  @Override
  public String[] monthsShortStandalone() {
    return monthsShort();
  }

  @Override
  public String[] quartersFull() {
    return new String[] {
        "1-р улирал",
        "2-р улирал",
        "3-р улирал",
        "4-р улирал"
    };
  }

  @Override
  public String[] quartersShort() {
    return new String[] {
        "I улирал",
        "II улирал",
        "III улирал",
        "IV улирал"
    };
  }

  @Override
  public String timeFormat() {
    return timeFormatMedium();
  }

  @Override
  public String timeFormatFull() {
    return "HH:mm:ss (zzzz)";
  }

  @Override
  public String timeFormatLong() {
    return "HH:mm:ss (z)";
  }

  @Override
  public String timeFormatMedium() {
    return "HH:mm:ss";
  }

  @Override
  public String timeFormatShort() {
    return "HH:mm";
  }

  @Override
  public String[] weekdaysFull() {
    return new String[] {
        "ням",
        "даваа",
        "мягмар",
        "лхагва",
        "пүрэв",
        "баасан",
        "бямба"
    };
  }

  @Override
  public String[] weekdaysFullStandalone() {
    return new String[] {
        "Ням",
        "Даваа",
        "Мягмар",
        "Лхагва",
        "Пүрэв",
        "Баасан",
        "Бямба"
    };
  }

  @Override
  public String[] weekdaysNarrow() {
    return new String[] {
        "Ня",
        "Да",
        "Мя",
        "Лх",
        "Пү",
        "Ба",
        "Бя"
    };
  }

  @Override
  public String[] weekdaysNarrowStandalone() {
    return weekdaysNarrow();
  }

  @Override
  public String[] weekdaysShort() {
    return new String[] {
        "Ня",
        "Да",
        "Мя",
        "Лх",
        "Пү",
        "Ба",
        "Бя"
    };
  }

  @Override
  public String[] weekdaysShortStandalone() {
    return weekdaysShort();
  }

  @Override
  public int weekendEnd() {
    return 0;
  }

  @Override
  public int weekendStart() {
    return 6;
  }
}
