/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.gwtproject.i18n.shared.cldr.impl;

import org.gwtproject.i18n.shared.cldr.LocalizedNamesImplBase;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "dyo" locale.
 */
public class LocalizedNamesImpl_dyo extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "SA",
        "AC",
        "AE",
        "AF",
        "AL",
        "DE",
        "DZ",
        "AD",
        "AI",
        "AO",
        "AG",
        "AQ",
        "AM",
        "AR",
        "AW",
        "AZ",
        "AX",
        "HT",
        "BS",
        "BH",
        "BD",
        "BB",
        "BY",
        "BZ",
        "BE",
        "BJ",
        "BM",
        "BL",
        "BO",
        "BA",
        "BW",
        "BQ",
        "BR",
        "BG",
        "BF",
        "BI",
        "BN",
        "BT",
        "BV",
        "TD",
        "CC",
        "CF",
        "CH",
        "CL",
        "CK",
        "CP",
        "CW",
        "CX",
        "DK",
        "DG",
        "DM",
        "EA",
        "NF",
        "ET",
        "EH",
        "EC",
        "IN",
        "ID",
        "ER",
        "EG",
        "ES",
        "EE",
        "EU",
        "EZ",
        "FJ",
        "FI",
        "FK",
        "FM",
        "FO",
        "FR",
        "GH",
        "GA",
        "GM",
        "GB",
        "GF",
        "GG",
        "GN",
        "GW",
        "GY",
        "GQ",
        "GL",
        "GD",
        "GR",
        "GS",
        "GU",
        "GT",
        "GP",
        "HK",
        "HM",
        "IC",
        "IS",
        "IM",
        "IO",
        "IQ",
        "IR",
        "IE",
        "IL",
        "IT",
        "JE",
        "DJ",
        "JO",
        "KH",
        "CM",
        "CA",
        "CV",
        "KE",
        "KG",
        "KI",
        "KN",
        "CI",
        "CO",
        "KM",
        "CG",
        "CR",
        "KP",
        "KR",
        "HR",
        "CU",
        "KW",
        "KY",
        "KZ",
        "LA",
        "LB",
        "LI",
        "LR",
        "LS",
        "LT",
        "LU",
        "LV",
        "LY",
        "MA",
        "MG",
        "ML",
        "MC",
        "MD",
        "ME",
        "MF",
        "MH",
        "MK",
        "MM",
        "MN",
        "MO",
        "CD",
        "CZ",
        "DO",
        "MP",
        "MQ",
        "MR",
        "MS",
        "MT",
        "MU",
        "MV",
        "MW",
        "MX",
        "MY",
        "MZ",
        "NA",
        "NC",
        "NE",
        "NG",
        "NI",
        "NL",
        "NO",
        "NP",
        "NR",
        "NU",
        "NZ",
        "OM",
        "HN",
        "AU",
        "AT",
        "HU",
        "PA",
        "PE",
        "PF",
        "PG",
        "PH",
        "PK",
        "PL",
        "PM",
        "PN",
        "PR",
        "PS",
        "PT",
        "PW",
        "PY",
        "QA",
        "QO",
        "RE",
        "RO",
        "RS",
        "RU",
        "RW",
        "SV",
        "JM",
        "AS",
        "JP",
        "LC",
        "SB",
        "SC",
        "SE",
        "SN",
        "GE",
        "SL",
        "SH",
        "CN",
        "CY",
        "SG",
        "GI",
        "LK",
        "SJ",
        "SK",
        "SI",
        "SM",
        "SO",
        "SR",
        "SS",
        "ST",
        "SD",
        "SX",
        "SY",
        "SZ",
        "TA",
        "TH",
        "TC",
        "TF",
        "TJ",
        "TK",
        "TL",
        "TM",
        "TN",
        "TO",
        "TG",
        "TR",
        "TT",
        "TV",
        "TW",
        "TZ",
        "UA",
        "UG",
        "UM",
        "UN",
        "US",
        "UY",
        "UZ",
        "VA",
        "VC",
        "VE",
        "VG",
        "VI",
        "VN",
        "VU",
        "WF",
        "WS",
        "XA",
        "XB",
        "XK",
        "YE",
        "YT",
        "ZA",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMap() {
    super.loadNameMap();
    namesMap.put("AF", "Afganistan");
    namesMap.put("AG", "Antigua di Barbuda");
    namesMap.put("AI", "Angiiya");
    namesMap.put("AL", "Albani");
    namesMap.put("AM", "Armeni");
    namesMap.put("AR", "Arsantin");
    namesMap.put("AS", "Samoa yati Amerik");
    namesMap.put("AT", "Otris");
    namesMap.put("AU", "Ostraalia");
    namesMap.put("AZ", "Aserbaysan");
    namesMap.put("BA", "Bosni di Hersegovin");
    namesMap.put("BB", "Barbad");
    namesMap.put("BD", "Banglades");
    namesMap.put("BE", "Belsik");
    namesMap.put("BF", "Burukiina Faso");
    namesMap.put("BG", "Bulgari");
    namesMap.put("BH", "Bahrayn");
    namesMap.put("BJ", "Bene");
    namesMap.put("BM", "Bermud");
    namesMap.put("BN", "Buruney");
    namesMap.put("BO", "Boliivi");
    namesMap.put("BR", "Bresil");
    namesMap.put("BS", "Bahama");
    namesMap.put("BT", "Butan");
    namesMap.put("BW", "Boswana");
    namesMap.put("BZ", "Beliis");
    namesMap.put("CA", "Kanada");
    namesMap.put("CD", "Mofam demokratik mati Kongo");
    namesMap.put("CG", "Kongo");
    namesMap.put("CI", "Koddiwar");
    namesMap.put("CL", "Cili");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CN", "Siin");
    namesMap.put("CO", "Kolombi");
    namesMap.put("CR", "Kosta Rika");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Kap Ver");
    namesMap.put("CY", "Siipr");
    namesMap.put("CZ", "Mofam mati Cek");
    namesMap.put("DE", "Almaañ");
    namesMap.put("DJ", "Jibuti");
    namesMap.put("DK", "Danmark");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Mofam mati Dominik");
    namesMap.put("DZ", "Alseri");
    namesMap.put("EC", "Ekuador");
    namesMap.put("EE", "Estoni");
    namesMap.put("EG", "Esípt");
    namesMap.put("ER", "Eritree");
    namesMap.put("ES", "Espaañ");
    namesMap.put("ET", "Ecoopi");
    namesMap.put("FR", "Frans");
    namesMap.put("GE", "Seorsi");
    namesMap.put("GH", "Gaana");
    namesMap.put("GI", "Sipraltaar");
    namesMap.put("GM", "Gambi");
    namesMap.put("GN", "Giné");
    namesMap.put("GP", "Guwadalup");
    namesMap.put("GR", "Gres");
    namesMap.put("GW", "Giné Bisaau");
    namesMap.put("GY", "Giyan");
    namesMap.put("HN", "Onduras");
    namesMap.put("HR", "Kroasi");
    namesMap.put("HT", "Ayti");
    namesMap.put("HU", "Oŋri");
    namesMap.put("ID", "Endonesi");
    namesMap.put("IE", "Irland");
    namesMap.put("IN", "End");
    namesMap.put("IQ", "Irak");
    namesMap.put("IS", "Iisland");
    namesMap.put("IT", "Itali");
    namesMap.put("JM", "Samaik");
    namesMap.put("JP", "Sapoŋ");
    namesMap.put("KE", "Keniya");
    namesMap.put("KH", "Kamboj");
    namesMap.put("KM", "Komor");
    namesMap.put("LC", "Saŋ Lusia");
    namesMap.put("LK", "Siri Lanka");
    namesMap.put("MG", "Madagaskaar");
    namesMap.put("NF", "Ecinkey yati Noorfok");
    namesMap.put("SA", "Abari Saudi");
    namesMap.put("SG", "Singapur");
    namesMap.put("SI", "Sloveni");
    namesMap.put("SK", "Slovaki");
    namesMap.put("SL", "Serra Leon");
    namesMap.put("SO", "Somali");
    namesMap.put("SV", "Salvadoor");
    namesMap.put("TD", "Cad");
    namesMap.put("TH", "Tailand");
  }

}
