/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.ui.tools.processor;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import org.apache.commons.io.IOUtils;
import org.dominokit.domino.apt.commons.AbstractProcessingStep;
import org.dominokit.domino.apt.commons.ExceptionUtil;
import org.dominokit.domino.apt.commons.StepBuilder;
import org.dominokit.ui.tools.processor.MdiIconsSourceWriter;
import org.dominokit.ui.tools.processor.MetaIconInfo;
import org.dominokit.ui.tools.processor.MetaIconInfo_MapperImpl;

public class MdiIconsProcessingStep
extends AbstractProcessingStep {
    public MdiIconsProcessingStep(ProcessingEnvironment processingEnv) {
        super(processingEnv);
    }

    public void process(Set<? extends Element> elementsByAnnotation) {
        for (Element element : elementsByAnnotation) {
            try {
                this.generateProxy(element);
            }
            catch (Exception e) {
                ExceptionUtil.messageStackTrace((Messager)this.messager, (Exception)e);
            }
        }
    }

    private void generateProxy(Element presenterElement) {
        this.writeSource(new MdiIconsSourceWriter(presenterElement, this.loadIconMetaInfo(), this.processingEnv).asTypeBuilder(), this.elements.getPackageOf(presenterElement).getQualifiedName().toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<MetaIconInfo> loadIconMetaInfo() {
        try (InputStream meta = new URL("https://raw.githubusercontent.com/Templarian/MaterialDesign-SVG/v3.0.39/meta.json").openStream();){
            String metaJson = IOUtils.toString((InputStream)meta, (String)"UTF-8");
            List<Object> list = Arrays.asList(MetaIconInfo_MapperImpl.INSTANCE.readArray(metaJson, MetaIconInfo[]::new));
            return list;
        }
        catch (IOException e) {
            ExceptionUtil.messageStackTrace((Messager)this.messager, (Exception)e);
            return new ArrayList<MetaIconInfo>();
        }
    }

    public static class Builder
    extends StepBuilder<MdiIconsProcessingStep> {
        public MdiIconsProcessingStep build() {
            return new MdiIconsProcessingStep(this.processingEnv);
        }
    }
}

