/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.ui.tools.processor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.apache.commons.io.IOUtils;
import org.dominokit.domino.apt.commons.AbstractProcessingStep;
import org.dominokit.domino.apt.commons.ExceptionUtil;
import org.dominokit.domino.apt.commons.StepBuilder;
import org.dominokit.ui.tools.processor.MdiIconsSourceWriter;
import org.dominokit.ui.tools.processor.MetaIconInfo;
import org.dominokit.ui.tools.processor.MetaIconInfo_MapperImpl;

public class MdiIconsProcessingStep
extends AbstractProcessingStep {
    private final String mdiVersion;

    public MdiIconsProcessingStep(ProcessingEnvironment processingEnv) {
        super(processingEnv);
        this.mdiVersion = Objects.isNull(processingEnv.getOptions().get("mdi.version")) ? "master" : processingEnv.getOptions().get("mdi.version");
        this.messager.printMessage(Diagnostic.Kind.NOTE, ">> MDI Version  : " + this.mdiVersion);
    }

    public void process(Set<? extends Element> elementsByAnnotation) {
        for (Element element : elementsByAnnotation) {
            try {
                this.generateIcons(element);
                this.updateFonts();
                this.updateCss();
            }
            catch (Exception e) {
                ExceptionUtil.messageStackTrace((Messager)this.messager, (Exception)e);
            }
        }
    }

    private void updateFonts() {
        this.copyFont("materialdesignicons-webfont.eot");
        this.copyFont("materialdesignicons-webfont.svg");
        this.copyFont("materialdesignicons-webfont.ttf");
        this.copyFont("materialdesignicons-webfont.woff");
        this.copyFont("materialdesignicons-webfont.woff2");
    }

    private void updateCss() {
        this.copyCss("materialdesignicons.css");
        this.copyCss("materialdesignicons.css.map");
        this.copyCss("materialdesignicons.min.css");
        this.copyCss("materialdesignicons.min.css.map");
    }

    private void copyFont(String fontName) {
        try (InputStream inputStream = new URL("https://github.com/Templarian/MaterialDesign-Webfont/blob/" + this.mdiVersion + "/fonts/" + fontName + "?raw=true").openStream();){
            FileObject resource = this.filer.createResource(StandardLocation.SOURCE_OUTPUT, "org.dominokit.domino.ui", "public/fonts/" + fontName, new Element[0]);
            OutputStream outputStream = resource.openOutputStream();
            IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
            outputStream.close();
        }
        catch (IOException e) {
            ExceptionUtil.messageStackTrace((Messager)this.messager, (Exception)e);
        }
    }

    private void copyCss(String cssName) {
        try (InputStream inputStream = new URL("https://raw.githubusercontent.com/Templarian/MaterialDesign-Webfont/" + this.mdiVersion + "/css/" + cssName + "?raw=true").openStream();){
            FileObject resource = this.filer.createResource(StandardLocation.SOURCE_OUTPUT, "org.dominokit.domino.ui", "public/css/mdi/css/" + cssName, new Element[0]);
            OutputStream outputStream = resource.openOutputStream();
            IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
            outputStream.close();
        }
        catch (IOException e) {
            ExceptionUtil.messageStackTrace((Messager)this.messager, (Exception)e);
        }
    }

    private void generateIcons(Element presenterElement) {
        this.writeSource(new MdiIconsSourceWriter(presenterElement, this.loadIconMetaInfo(), this.processingEnv).asTypeBuilder(), this.elements.getPackageOf(presenterElement).getQualifiedName().toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<MetaIconInfo> loadIconMetaInfo() {
        try (InputStream meta = new URL("https://raw.githubusercontent.com/Templarian/MaterialDesign-SVG/" + this.mdiVersion + "/meta.json").openStream();){
            String metaJson = IOUtils.toString((InputStream)meta, (String)"UTF-8");
            List<Object> list = Arrays.asList(MetaIconInfo_MapperImpl.INSTANCE.readArray(metaJson, MetaIconInfo[]::new));
            return list;
        }
        catch (IOException e) {
            ExceptionUtil.messageStackTrace((Messager)this.messager, (Exception)e);
            return new ArrayList<MetaIconInfo>();
        }
    }

    public static class Builder
    extends StepBuilder<MdiIconsProcessingStep> {
        public MdiIconsProcessingStep build() {
            return new MdiIconsProcessingStep(this.processingEnv);
        }
    }
}

