package org.dominokit.ui.tools.processor;

import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import org.dominokit.jacksonapt.JsonSerializationContext;
import org.dominokit.jacksonapt.JsonSerializer;
import org.dominokit.jacksonapt.ser.CollectionJsonSerializer;
import org.dominokit.jacksonapt.ser.StringJsonSerializer;
import org.dominokit.jacksonapt.ser.bean.AbstractBeanJsonSerializer;
import org.dominokit.jacksonapt.ser.bean.BeanPropertySerializer;

public final class MetaIconInfoBeanJsonSerializerImpl extends AbstractBeanJsonSerializer<MetaIconInfo> {
  public MetaIconInfoBeanJsonSerializerImpl() {
  }

  @Override
  public Class getSerializedType() {
    return MetaIconInfo.class;
  }

  @Override
  protected BeanPropertySerializer[] initSerializers() {
    BeanPropertySerializer[] result = new BeanPropertySerializer[6];
    result[0] = new BeanPropertySerializer<MetaIconInfo, String>("name") {
      @Override
      protected JsonSerializer<?> newSerializer() {
        return StringJsonSerializer.getInstance();
      }

      @Override
      public String getValue(MetaIconInfo bean, JsonSerializationContext ctx) {
        return bean.getName();
      }
    };
    result[1] = new BeanPropertySerializer<MetaIconInfo, String>("codepoint") {
      @Override
      protected JsonSerializer<?> newSerializer() {
        return StringJsonSerializer.getInstance();
      }

      @Override
      public String getValue(MetaIconInfo bean, JsonSerializationContext ctx) {
        return bean.getCodepoint();
      }
    };
    result[2] = new BeanPropertySerializer<MetaIconInfo, List<String>>("aliases") {
      @Override
      protected JsonSerializer<?> newSerializer() {
        return CollectionJsonSerializer.newInstance(StringJsonSerializer.getInstance());
      }

      @Override
      public List<String> getValue(MetaIconInfo bean, JsonSerializationContext ctx) {
        return bean.getAliases();
      }
    };
    result[3] = new BeanPropertySerializer<MetaIconInfo, List<String>>("tags") {
      @Override
      protected JsonSerializer<?> newSerializer() {
        return CollectionJsonSerializer.newInstance(StringJsonSerializer.getInstance());
      }

      @Override
      public List<String> getValue(MetaIconInfo bean, JsonSerializationContext ctx) {
        return bean.getTags();
      }
    };
    result[4] = new BeanPropertySerializer<MetaIconInfo, String>("author") {
      @Override
      protected JsonSerializer<?> newSerializer() {
        return StringJsonSerializer.getInstance();
      }

      @Override
      public String getValue(MetaIconInfo bean, JsonSerializationContext ctx) {
        return bean.getAuthor();
      }
    };
    result[5] = new BeanPropertySerializer<MetaIconInfo, String>("version") {
      @Override
      protected JsonSerializer<?> newSerializer() {
        return StringJsonSerializer.getInstance();
      }

      @Override
      public String getValue(MetaIconInfo bean, JsonSerializationContext ctx) {
        return bean.getVersion();
      }
    };
    return result;
  }
}
