/*
 * Decompiled with CFR 0.152.
 */
package org.dominokit.ui.tools.processor;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import org.dominokit.domino.apt.commons.AbstractSourceBuilder;
import org.dominokit.domino.apt.commons.DominoTypeBuilder;
import org.dominokit.domino.ui.icons.MdiIcon;
import org.dominokit.domino.ui.icons.MdiIconsByTagFactory;
import org.dominokit.domino.ui.icons.MdiMeta;
import org.dominokit.ui.tools.processor.MdiIconsProcessor;
import org.dominokit.ui.tools.processor.MetaIconInfo;

public class MdiIconsSourceWriter
extends AbstractSourceBuilder {
    public static final String UNTAGGED = "UnTagged";
    private final List<MetaIconInfo> metaIconInfos;
    private final String rootPackageName;

    protected MdiIconsSourceWriter(Element rootPackage, List<MetaIconInfo> metaIconInfos, ProcessingEnvironment processingEnv) {
        super(processingEnv);
        this.metaIconInfos = metaIconInfos;
        this.rootPackageName = this.elements.getPackageOf(rootPackage).getQualifiedName().toString();
    }

    public List<TypeSpec.Builder> asTypeBuilder() {
        ArrayList<TypeSpec.Builder> types = new ArrayList<TypeSpec.Builder>();
        types.addAll(this.generateIconsByTag());
        return types;
    }

    private List<TypeSpec.Builder> generateIconsByTag() {
        ArrayList<TypeSpec.Builder> types = new ArrayList<TypeSpec.Builder>();
        Set<String> tags = this.metaIconInfos.stream().map(MetaIconInfo::getTags).flatMap(Collection::stream).collect(Collectors.toSet());
        tags.forEach(tag -> types.addAll(this.generateByTagInterface((String)tag, this.metaIconInfos.stream().filter(metaIconInfo -> metaIconInfo.getTags().contains(tag)).collect(Collectors.toList()))));
        types.addAll(this.generateByTagInterface("", this.metaIconInfos.stream().filter(metaIconInfo -> metaIconInfo.getTags().isEmpty()).collect(Collectors.toList())));
        types.add(this.generateMdiIconsByTagInterface(tags));
        types.add(this.generateAllMdiIconsInterface());
        types.add(this.generateMdiTagsConstants(tags));
        types.add(this.generateMdiByTagFactory(tags));
        return types;
    }

    private TypeSpec.Builder generateMdiByTagFactory(Set<String> tags) {
        ParameterizedTypeName listType = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)ClassName.get(Supplier.class), (TypeName[])new TypeName[]{TypeName.get(MdiIcon.class)})});
        TypeSpec.Builder factoryBuilder = DominoTypeBuilder.classBuilder((String)"MdiByTagFactory", MdiIconsProcessor.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethod(MethodSpec.methodBuilder((String)"get").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)listType).addParameter(ParameterSpec.builder((TypeName)TypeName.get(String.class), (String)"tag", (Modifier[])new Modifier[0]).build()).addCode(this.switchCodeBuilder(tags).build()).build());
        return factoryBuilder;
    }

    private CodeBlock.Builder switchCodeBuilder(Set<String> tags) {
        ClassName tagsConstants = ClassName.bestGuess((String)(this.rootPackageName + ".MdiTags"));
        CodeBlock.Builder builder = CodeBlock.builder();
        builder.beginControlFlow("switch(tag)", new Object[0]);
        tags.forEach(tag -> builder.addStatement("case $T.$L : return new $T().icons()", new Object[]{tagsConstants, this.tagToClassName((String)tag).toUpperCase(), ClassName.bestGuess((String)(this.rootPackageName + "." + this.tagToClassName((String)tag) + "_Factory"))}));
        builder.addStatement("case $T.$L : return new $T().icons()", new Object[]{tagsConstants, this.tagToClassName(UNTAGGED).toUpperCase(), ClassName.bestGuess((String)(this.rootPackageName + "." + this.tagToClassName(UNTAGGED) + "_Factory"))});
        builder.addStatement("default : throw new $T(tag)", new Object[]{TypeName.get(IllegalArgumentException.class)});
        builder.endControlFlow();
        return builder;
    }

    private TypeSpec.Builder generateMdiTagsConstants(Set<String> tags) {
        TypeSpec.Builder builder = DominoTypeBuilder.interfaceBuilder((String)"MdiTags", MdiIconsProcessor.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        tags.forEach(tag -> builder.addField(FieldSpec.builder((TypeName)TypeName.get(String.class), (String)this.tagToClassName((String)tag).toUpperCase(), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{tag}).build()));
        builder.addField(FieldSpec.builder((TypeName)TypeName.get(String.class), (String)UNTAGGED.toUpperCase(), (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{""}).build());
        builder.addField(FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{TypeName.get(String.class)}), (String)"TAGS", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$T.asList($L)", new Object[]{TypeName.get(Arrays.class), tags.stream().map(tag -> this.tagToClassName((String)tag).toUpperCase()).collect(Collectors.joining(","))}).build());
        return builder;
    }

    private TypeSpec.Builder generateAllMdiIconsInterface() {
        TypeSpec.Builder builder = DominoTypeBuilder.interfaceBuilder((String)"MdiIcons", MdiIconsProcessor.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.metaIconInfos.forEach(metaIconInfo -> {
            MethodSpec.Builder iconMethod = MethodSpec.methodBuilder((String)(metaIconInfo.getName().replace("-", "_") + "_mdi")).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.DEFAULT}).returns(MdiIcon.class).addStatement("return $T.create($S, new $T($S, $S, $T.asList($L), $T.asList($L), $S, $S))", new Object[]{TypeName.get(MdiIcon.class), "mdi-" + metaIconInfo.getName(), TypeName.get(MdiMeta.class), metaIconInfo.getName(), metaIconInfo.getCodepoint(), TypeName.get(Arrays.class), this.getStringLiteral(metaIconInfo.getTags()), TypeName.get(Arrays.class), this.getStringLiteral(metaIconInfo.getAliases()), metaIconInfo.getAuthor(), metaIconInfo.getVersion()});
            builder.addMethod(iconMethod.build());
        });
        return builder;
    }

    private TypeSpec.Builder generateMdiIconsByTagInterface(Set<String> tags) {
        TypeSpec.Builder builder = DominoTypeBuilder.interfaceBuilder((String)"MdiIconsByTag", MdiIconsProcessor.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        tags.forEach(tag -> builder.addSuperinterface((TypeName)ClassName.bestGuess((String)(this.rootPackageName + "." + this.tagToClassName((String)tag)))));
        builder.addSuperinterface((TypeName)ClassName.bestGuess((String)(this.rootPackageName + "." + UNTAGGED)));
        return builder;
    }

    private List<TypeSpec.Builder> generateByTagInterface(String tag, List<MetaIconInfo> icons) {
        ArrayList<TypeSpec.Builder> types = new ArrayList<TypeSpec.Builder>();
        String typeName = this.tagToClassName(tag);
        if (typeName.isEmpty()) {
            typeName = UNTAGGED;
        }
        TypeSpec.Builder builder = DominoTypeBuilder.interfaceBuilder((String)typeName, MdiIconsProcessor.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        ParameterizedTypeName listType = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)ClassName.get(Supplier.class), (TypeName[])new TypeName[]{TypeName.get(MdiIcon.class)})});
        CodeBlock.Builder staticInitializer = CodeBlock.builder();
        TypeSpec.Builder factoryBuilder = DominoTypeBuilder.classBuilder((String)(typeName + "_Factory"), MdiIconsProcessor.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface(TypeName.get(MdiIconsByTagFactory.class)).addField(FieldSpec.builder((TypeName)listType, (String)"icons", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("new $T()", new Object[]{TypeName.get(ArrayList.class)}).build()).addField(FieldSpec.builder((TypeName)ClassName.bestGuess((String)(this.rootPackageName + "." + typeName)), (String)"tagIcons", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("new $T(){}", new Object[]{ClassName.bestGuess((String)(this.rootPackageName + "." + typeName))}).build());
        icons.forEach(metaIconInfo -> {
            String methodName = metaIconInfo.getName().replace("-", "_") + this.methodPostFix(tag);
            MethodSpec.Builder iconMethod = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.DEFAULT}).returns(MdiIcon.class).addStatement("return $T.create($S, new $T($S, $S, $T.asList($L), $T.asList($L), $S, $S))", new Object[]{TypeName.get(MdiIcon.class), "mdi-" + metaIconInfo.getName(), TypeName.get(MdiMeta.class), metaIconInfo.getName(), metaIconInfo.getCodepoint(), TypeName.get(Arrays.class), this.getStringLiteral(metaIconInfo.getTags()), TypeName.get(Arrays.class), this.getStringLiteral(metaIconInfo.getAliases()), metaIconInfo.getAuthor(), metaIconInfo.getVersion()});
            builder.addMethod(iconMethod.build());
            staticInitializer.addStatement("icons.add(()-> tagIcons." + methodName + "())", new Object[0]);
        });
        factoryBuilder.addStaticBlock(staticInitializer.build()).addMethod(MethodSpec.methodBuilder((String)"icons").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)listType).addStatement("return new $T<>(icons)", new Object[]{TypeName.get(ArrayList.class)}).build());
        types.add(builder);
        types.add(factoryBuilder);
        return types;
    }

    private String methodPostFix(String tag) {
        if (tag.isEmpty()) {
            return "_mdi";
        }
        return "_" + this.tagToClassName(tag).toLowerCase() + "_mdi";
    }

    private String tagToClassName(String tag) {
        return tag.replace("/", "_").replace("+", "_").replace(" ", "");
    }

    private String getStringLiteral(List<String> stringList) {
        String literal = stringList.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(","));
        return Objects.isNull(literal) || literal.isEmpty() ? "" : literal;
    }
}

