/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.flexess.client.impl.spel;

import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.jresearch.flexess.client.IConstraintEvaluator;
import org.jresearch.flexess.client.impl.spel.EmfPropertyAccessor;
import org.jresearch.flexess.core.model.uam.PObject;
import org.jresearch.flexess.core.model.uam.POperation;
import org.jresearch.flexess.core.model.uam.Permission;
import org.jresearch.flexess.core.model.uam.UamElement;
import org.jresearch.flexess.core.model.uam.UamPackage;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class SpElEvaluator
implements IConstraintEvaluator {
    private final SpelExpressionParser parser = new SpelExpressionParser();

    @Override
    public boolean evaluate(EObject pObjectInstance, EObject roleInstance, POperation operation) {
        PObject pObject = (PObject)pObjectInstance.eClass();
        Collection<EObject> permissionInstances = SpElEvaluator.findPermission(pObject, roleInstance, operation);
        return StreamEx.of(permissionInstances).anyMatch(p -> this.checkPermission(pObjectInstance, (EObject)p));
    }

    private boolean checkPermission(EObject pObjectInstance, EObject permissionInstance) {
        Permission permission = (Permission)permissionInstance.eClass();
        permissionInstance.eSet(permission.getEStructuralFeature("object"), (Object)pObjectInstance);
        String expession = permission.getConstraint().getExpession();
        Expression exp = this.parser.parseExpression(expession);
        StandardEvaluationContext context = new StandardEvaluationContext((Object)permissionInstance);
        context.addPropertyAccessor((PropertyAccessor)new EmfPropertyAccessor());
        return (Boolean)exp.getValue((EvaluationContext)context, Boolean.class);
    }

    private static Collection<EObject> findPermission(PObject object, EObject roleInstance, POperation operation) {
        assert (object.getEOperations().contains((Object)operation));
        EList structuralFeatures = roleInstance.eClass().getEStructuralFeatures();
        return ((StreamEx)StreamEx.of((Collection)structuralFeatures).filter(f -> UamPackage.eINSTANCE.getPermission().isInstance((Object)f.getEType()) && SpElEvaluator.isOperationPermission((Permission)f.getEType(), operation))).map(arg_0 -> ((EObject)roleInstance).eGet(arg_0)).map(EObject.class::cast).toList();
    }

    private static boolean isOperationPermission(Permission permission, POperation operation) {
        EList operations = permission.getPOperation();
        return operations.isEmpty() && ((UamElement)operation.getEContainingClass()).getId().equals(permission.getPObject().getId()) || SpElEvaluator.contains((List<POperation>)operations, operation);
    }

    private static boolean contains(List<POperation> operations, POperation testOperation) {
        return StreamEx.of(operations).anyMatch(o -> o.getId().equals(testOperation.getId()));
    }
}

