/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.flexess.client.impl;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.jresearch.flexess.client.UamClientException;
import org.jresearch.flexess.client.impl.ICheckerFlow;
import org.jresearch.flexess.client.mappers.IInstanceMapper;
import org.jresearch.flexess.client.mappers.impl.AbstractMapper;
import org.jresearch.flexess.client.mappers.impl.CustomObjectMapper;
import org.jresearch.flexess.client.mappers.impl.DefaultMapper;
import org.jresearch.flexess.client.mappers.impl.GenericMapper;
import org.jresearch.flexess.client.mappers.impl.JavaInstanceMapper;
import org.jresearch.flexess.client.mappers.impl.LegacyJavaInstanceMapper;
import org.jresearch.flexess.core.model.uam.PObject;

public class SimpleCheckerFlow
implements ICheckerFlow {
    private static Map<String, IInstanceMapper> mappers = new HashMap<String, IInstanceMapper>();
    private final Object object;

    public SimpleCheckerFlow(Object object) {
        assert (object != null);
        this.object = object;
    }

    @Override
    public Class<?> getObjectClass() {
        return this.object.getClass();
    }

    @Override
    public EObject getPOInstance(PObject po) {
        assert (po != null);
        String mapperId = EcoreUtil.getAnnotation((EModelElement)po, (String)"http://www.jresearchsoft.com/schemas/uam", (String)"#mapper_name");
        if (mapperId == null) {
            throw new UamClientException("Mapper is not specified");
        }
        IInstanceMapper mapper = mappers.get(mapperId);
        if (mapper == null) {
            throw new UamClientException(MessageFormat.format("Unable to create EObject: can''t find {0} mapper ", mapperId));
        }
        try {
            return mapper.createPObjectInstance(this.object, po);
        }
        catch (Exception e) {
            throw new UamClientException("Unable to create EObject", (Throwable)e);
        }
    }

    static {
        AbstractMapper mapper = new CustomObjectMapper();
        mappers.put(mapper.getMapperId(), mapper);
        mapper = new DefaultMapper();
        mappers.put(mapper.getMapperId(), mapper);
        mapper = new GenericMapper();
        mappers.put(mapper.getMapperId(), mapper);
        mapper = new JavaInstanceMapper();
        mappers.put(mapper.getMapperId(), mapper);
        mapper = new LegacyJavaInstanceMapper();
        mappers.put(mapper.getMapperId(), mapper);
    }
}

