/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.flexess.client.context;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.jresearch.flexess.client.context.AbstractUserContext;

public class UserContext
extends AbstractUserContext
implements Serializable {
    private static final long serialVersionUID = 2498167262395290752L;
    private String userId;
    private final Map<String, Serializable> serializableUserObjects = new HashMap<String, Serializable>();
    private final transient Map<String, Object> userObjects = new HashMap<String, Object>();
    private final transient Map<String, List<EObject>> roles = new HashMap<String, List<EObject>>();
    private final transient Map<String, EPackage> models = new HashMap<String, EPackage>();

    public UserContext(String userId) {
        this.userId = userId;
    }

    public List<EObject> getRoles() {
        LinkedList<EObject> result = new LinkedList<EObject>();
        Collection<List<EObject>> modelsRoles = this.roles.values();
        for (List<EObject> modelRoles : modelsRoles) {
            result.addAll(modelRoles);
        }
        return result;
    }

    @Override
    @Nonnull
    public List<EObject> getRoles(String modelId) {
        List<EObject> result = this.roles.get(modelId);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    @Override
    public void setRoles(String modelId, List<EObject> roles) {
        assert (modelId != null && roles != null);
        this.roles.put(modelId, Collections.unmodifiableList(roles));
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public void setUserId(String userId) {
        assert (userId != null);
        this.userId = userId;
    }

    public boolean equals(Object arg0) {
        if (!(arg0 instanceof String)) {
            return false;
        }
        UserContext comparable = (UserContext)arg0;
        if (comparable.getUserId() == null && this.getUserId() == null) {
            return true;
        }
        if (comparable.getUserId() != null && this.getUserId() != null) {
            return this.getUserId().equals(comparable.getUserId());
        }
        return false;
    }

    public int hashCode() {
        if (this.getUserId() == null) {
            return 1;
        }
        return this.getUserId().hashCode();
    }

    @Override
    public boolean isEnrolled() {
        Collection<List<EObject>> values = this.roles.values();
        for (List<EObject> list : values) {
            if (list.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean addSecurityModels(String id, EPackage model) {
        assert (id != null && model != null);
        return this.models.put(id, model) == null;
    }

    public List<EPackage> getSecurityModels() {
        return new LinkedList<EPackage>(this.models.values());
    }

    public EPackage getSecurityModel(String modelId) {
        return this.models.get(modelId);
    }

    public Collection<String> getModelIds() {
        return Collections.unmodifiableSet(this.models.keySet());
    }

    public boolean isValid() {
        return this.roles != null && this.models != null && !this.models.isEmpty();
    }

    public <U> void putUserObject(String key, U userObject) {
        if (userObject instanceof Serializable) {
            this.serializableUserObjects.put(key, (Serializable)userObject);
        } else {
            this.userObjects.put(key, userObject);
        }
    }

    public <U> U getUserObject(String key) {
        return (U)(this.serializableUserObjects.containsKey(key) ? this.serializableUserObjects : this.userObjects).get(key);
    }
}

