/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.flexess.client.impl;

import com.google.common.base.Strings;
import java.security.AccessControlException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.jresearch.flexess.client.AuthorizationRequest;
import org.jresearch.flexess.client.FlexessConnectException;
import org.jresearch.flexess.client.IChecker;
import org.jresearch.flexess.client.IMultimodelAuthorizationManager;
import org.jresearch.flexess.client.IUserManager;
import org.jresearch.flexess.client.InconsistentModelException;
import org.jresearch.flexess.client.ObjectNotFoundException;
import org.jresearch.flexess.client.OperationNotFoundException;
import org.jresearch.flexess.client.PObjectNotFoundException;
import org.jresearch.flexess.client.UamClientException;
import org.jresearch.flexess.client.context.IUserContext;
import org.jresearch.flexess.client.context.UserContext;
import org.jresearch.flexess.client.context.UserContextManager;
import org.jresearch.flexess.client.impl.DefaultCheckerFlow;
import org.jresearch.flexess.client.impl.GenericCheckerFlow;
import org.jresearch.flexess.client.impl.ICheckerFlow;
import org.jresearch.flexess.client.impl.SimpleCheckerFlow;
import org.jresearch.flexess.core.IModelService;
import org.jresearch.flexess.core.IUserRoleService;
import org.jresearch.flexess.core.model.IRoleMetaInfo;
import org.jresearch.flexess.core.model.uam.PObject;
import org.jresearch.flexess.core.model.uam.Permission;
import org.jresearch.flexess.core.model.uam.Role;
import org.jresearch.flexess.core.model.uam.SecurityModel;
import org.jresearch.flexess.core.model.uam.UamPackage;
import org.jresearch.flexess.core.model.util.EMFUtil;
import org.jresearch.flexess.umi.api.IUser;
import org.jresearch.flexess.umi.api.UserAttributeNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.remoting.RemoteAccessException;

public class AuthorizationManager
implements IMultimodelAuthorizationManager {
    private static final Pattern spliter = Pattern.compile(",");
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private IChecker checker;
    private IUserRoleService userRoles;
    private IUserManager userManager;
    private String defaultRole;
    @Autowired
    private IModelService modelService;

    public void setDefaultRole(String defaultRole) {
        this.defaultRole = defaultRole;
    }

    protected IUserContext getUserContext() {
        IUserContext context = UserContextManager.getContext();
        if (!context.isValid()) {
            context = this.updateUserContext(context);
        }
        return context;
    }

    protected SecurityModel getSecurityModel(String modelId) {
        IUserContext ctx = this.getUserContext();
        return (SecurityModel)ctx.getSecurityModel(modelId);
    }

    protected List<SecurityModel> getSecurityModels() {
        List securityModels = this.getUserContext().getSecurityModels();
        LinkedList<SecurityModel> result = new LinkedList<SecurityModel>();
        for (EPackage ePackage : securityModels) {
            result.add((SecurityModel)ePackage);
        }
        return result;
    }

    public void setChecker(IChecker checker) {
        this.checker = checker;
    }

    private List<EObject> getRoles(String modelId) {
        assert (modelId != null);
        IUserContext ctx = this.getUserContext();
        return ctx.getRoles(modelId);
    }

    private List<EObject> getRoles(SecurityModel model) {
        assert (model != null);
        return this.getRoles(model.getId());
    }

    public void check(Object object, String operation) throws AccessControlException, UamClientException {
        if (object == null) {
            throw new UamClientException("The object in check method can't be a null");
        }
        if (operation == null) {
            throw new UamClientException("The operation in check method can't be a null");
        }
        this.checkAllModels(this.getSecurityModels(), object, operation, new SimpleCheckerFlow(object));
    }

    private void checkAllModels(List<SecurityModel> securityModels, Object object, String operation, ICheckerFlow checkerFlow) {
        boolean objectFound = false;
        boolean operationFound = false;
        for (SecurityModel securityModel : securityModels) {
            try {
                List<EObject> roles = this.getRoles(securityModel);
                if (roles.isEmpty()) continue;
                this.checkPermissions(securityModel, roles, object, operation, checkerFlow);
                objectFound = true;
                operationFound = true;
                break;
            }
            catch (PObjectNotFoundException e) {
                this.logger.trace("Security object {} is not found.", object, (Object)e);
            }
            catch (OperationNotFoundException e) {
                this.logger.trace("Security operation {} is not found.", (Object)operation, (Object)e);
            }
        }
        if (!objectFound || !operationFound) {
            throw new AccessControlException(MessageFormat.format("Access is denied. Object {0}, operation {1}", object, operation));
        }
    }

    protected void checkPermissions(SecurityModel model, List<EObject> roles, Object object, String operation, ICheckerFlow checkerFlow) throws PObjectNotFoundException, OperationNotFoundException {
        boolean isPermitted = false;
        boolean objectFound = false;
        boolean operationFound = false;
        Class<?> currentClass = checkerFlow.getObjectClass();
        List<Class<?>> classes = this.getCandidateClasses(currentClass);
        for (Class<?> candidatClass : classes) {
            try {
                PObject po = AuthorizationManager.findPObject(model, candidatClass.getName(), object);
                objectFound = true;
                isPermitted = this.internalCheck(po, roles, operation, checkerFlow);
                operationFound = true;
                break;
            }
            catch (PObjectNotFoundException e) {
                this.logger.trace("Security object {} is not found.", object, (Object)e);
            }
            catch (OperationNotFoundException e) {
                this.logger.trace("Security operation {} is not found.", (Object)operation, (Object)e);
            }
            catch (ObjectNotFoundException e) {
                throw new UamClientException((Throwable)e);
            }
        }
        if (!objectFound) {
            throw new PObjectNotFoundException(MessageFormat.format("Can''t find pObject mapping for {0} class", currentClass.getName()), operation);
        }
        if (!operationFound) {
            throw new OperationNotFoundException(MessageFormat.format("Can''t find operation {0}", operation), operation);
        }
        if (!isPermitted) {
            throw new AccessControlException(MessageFormat.format("Access is denied. Object {0}, operation {1}, user roles {2}", object, operation, roles));
        }
    }

    private List<Class<?>> getCandidateClasses(Class<?> currentClass) {
        ArrayList result = new ArrayList();
        result.add(currentClass);
        result.addAll(AuthorizationManager.getInterfaces(currentClass));
        Class<?> superclass = currentClass.getSuperclass();
        if (superclass != null) {
            result.addAll(this.getCandidateClasses(superclass));
        }
        return result;
    }

    private static List<Class<?>> getInterfaces(Class<?> currentClass) {
        Class<?>[] interfaces;
        ArrayList result = new ArrayList();
        for (Class<?> interf : interfaces = currentClass.getInterfaces()) {
            result.add(interf);
            Class<?>[] classes = interf.getInterfaces();
            result.addAll(Arrays.asList(classes));
        }
        return result;
    }

    protected void checkObjectRequest(String modelId, Object object, String operation) {
        List<SecurityModel> securityModels = modelId == null ? this.getSecurityModels() : Collections.singletonList(this.getSecurityModel(modelId));
        this.checkAllModels(securityModels, object, operation, new SimpleCheckerFlow(object));
    }

    private List<EObject> loadRoles(SecurityModel securityModel, String userId) {
        IUser user = this.userManager.getUser(userId);
        if (user == null) {
            throw new UamClientException(MessageFormat.format("User {0} is not found.", userId));
        }
        try {
            IRoleMetaInfo[] roleInstances = this.userRoles.getRoles(securityModel.getId(), userId);
            ArrayList<EObject> emfRoles = new ArrayList<EObject>();
            try {
                if (roleInstances.length == 0 && !Strings.nullToEmpty((String)this.defaultRole).isEmpty()) {
                    emfRoles.add(AuthorizationManager.loadRoleInstance(this.defaultRole, user, securityModel));
                } else {
                    for (IRoleMetaInfo roleInst : roleInstances) {
                        emfRoles.add(AuthorizationManager.loadRoleInstance(roleInst.getId(), user, securityModel));
                    }
                }
            }
            catch (InconsistentModelException e) {
                throw new UamClientException(MessageFormat.format("Unable to load role instance {0}", e.getLocalizedMessage()), (Throwable)e);
            }
            return emfRoles;
        }
        catch (RemoteAccessException e) {
            throw new FlexessConnectException(MessageFormat.format("Can''t connect: {0}.", e.getLocalizedMessage()), (Throwable)e);
        }
    }

    private boolean internalCheck(PObject po, List<EObject> roles, String operation, ICheckerFlow checkerFlow) throws ObjectNotFoundException {
        if (roles == null || roles.isEmpty()) {
            throw new AccessControlException("Role list is empty");
        }
        EObject eObject = checkerFlow.getPOInstance(po);
        if (eObject == null) {
            throw new UamClientException(MessageFormat.format("Error creating EObject for PObject{0}", po));
        }
        return this.checker.check(roles, eObject, operation);
    }

    private static PObject findPObject(SecurityModel model, String classname, Object object) throws PObjectNotFoundException {
        PObject po = null;
        if (object != null && classname.equals(String.class.getName())) {
            po = AuthorizationManager.findCustomPObject(model, object.toString());
        }
        if (po == null && (po = AuthorizationManager.findPObject(model, classname)) == null) {
            throw new PObjectNotFoundException(MessageFormat.format("PObject for class {0} is not found", classname), classname);
        }
        return po;
    }

    private static EObject loadRoleInstance(String roleInstId, IUser user, SecurityModel securityModel) throws InconsistentModelException {
        Role emfRole = AuthorizationManager.findRole(securityModel, roleInstId);
        if (emfRole == null) {
            throw new InconsistentModelException("Role is not found" + roleInstId);
        }
        EFactory securityFactory = securityModel.getEFactoryInstance();
        EObject emfRoleInstance = securityFactory.create((EClass)emfRole);
        List emfPermissions = EMFUtil.getPermissions((Role)emfRole);
        for (Permission permission : emfPermissions) {
            EReference permissionRef = EMFUtil.getPermission((Role)emfRole, (Permission)permission);
            EObject permissionInstance = securityFactory.create((EClass)permission);
            emfRoleInstance.eSet((EStructuralFeature)permissionRef, (Object)permissionInstance);
            EList attrs = permission.getEAttributes();
            for (EAttribute attr : attrs) {
                ArrayList<Object> value = null;
                if ("uid".equals(attr.getName())) {
                    value = user.getUid();
                } else {
                    try {
                        value = user.getAttribute(attr.getName());
                    }
                    catch (UserAttributeNotFoundException e) {
                        e.printStackTrace();
                    }
                }
                if (value instanceof String) {
                    EDataType type = attr.getEAttributeType();
                    if (attr.isMany()) {
                        String[] values;
                        ArrayList<Object> list = new ArrayList<Object>();
                        for (String string : values = spliter.split((CharSequence)((Object)value))) {
                            list.add(EcoreUtil.createFromString((EDataType)type, (String)string.trim()));
                        }
                        value = list;
                    } else {
                        value = EcoreUtil.createFromString((EDataType)type, (String)((String)((Object)value)));
                    }
                }
                permissionInstance.eSet((EStructuralFeature)attr, (Object)value);
            }
        }
        return emfRoleInstance;
    }

    private static Role findRole(SecurityModel model, String roleId) {
        Collection objects = EcoreUtil.getObjectsByType((Collection)model.getEClassifiers(), (EClassifier)UamPackage.eINSTANCE.getRole());
        for (Role object : objects) {
            if (!object.getId().equals(roleId)) continue;
            return object;
        }
        return null;
    }

    private static PObject findPObject(SecurityModel model, String classname) {
        Collection allPObjects = EcoreUtil.getObjectsByType((Collection)model.getEClassifiers(), (EClassifier)UamPackage.eINSTANCE.getPObject());
        for (PObject object : allPObjects) {
            String className = EcoreUtil.getAnnotation((EModelElement)object, (String)"http://www.jresearchsoft.com/schemas/uam", (String)"#class_name");
            if (!classname.equals(className)) continue;
            return object;
        }
        return null;
    }

    private static PObject findCustomPObject(SecurityModel model, String objectName) {
        assert (model != null && objectName != null);
        Collection allPObjects = EcoreUtil.getObjectsByType((Collection)model.getEClassifiers(), (EClassifier)UamPackage.eINSTANCE.getPObject());
        for (PObject object : allPObjects) {
            if (!objectName.equals(object.getName())) continue;
            return object;
        }
        return null;
    }

    public void check(Class<?> pObjectClass, String operation) {
        assert (pObjectClass != null && operation != null);
        this.checkAllModels(this.getSecurityModels(), null, operation, new DefaultCheckerFlow(pObjectClass));
    }

    public void check(Map<String, Object> attributeMap, Class<?> pObjectClass, String operation) {
        assert (pObjectClass != null);
        HashMap<String, Object> map = attributeMap == null ? new HashMap<String, Object>() : attributeMap;
        this.checkAllModels(this.getSecurityModels(), null, operation, new GenericCheckerFlow(map, pObjectClass));
    }

    protected void checkClassRequest(String modelId, Map<String, Object> attributeMap, Class<?> pObjectClass, String operation) {
        HashMap<String, Object> map = attributeMap == null ? new HashMap<String, Object>() : attributeMap;
        GenericCheckerFlow cf = new GenericCheckerFlow(map, pObjectClass);
        List<SecurityModel> securityModels = modelId == null ? this.getSecurityModels() : Collections.singletonList(this.getSecurityModel(modelId));
        this.checkAllModels(securityModels, null, operation, cf);
    }

    public void check(String attributeName, String attributeValue, Class<?> pObjectClass, String operation) {
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        attributeMap.put(attributeName, attributeValue);
        GenericCheckerFlow cf = new GenericCheckerFlow(attributeMap, pObjectClass);
        this.checkAllModels(this.getSecurityModels(), null, operation, cf);
    }

    public void check(AuthorizationRequest request) {
        String modelId = request.getModelId();
        Object objectInstance = request.getObjectInstance();
        String operation = request.getOperation();
        if (objectInstance != null) {
            this.checkObjectRequest(modelId, objectInstance, operation);
            return;
        }
        Class objectClass = request.getObjectClass();
        if (objectClass == null) {
            throw new UamClientException("Incomplete authorization request: both object and class are missing");
        }
        this.checkClassRequest(modelId, request.getAttributeMap(), objectClass, operation);
    }

    public Collection<String> getModelIdList() {
        IUserContext ctx = this.getUserContext();
        return ctx.getModelIds();
    }

    public boolean isEnrolled(String modelId) {
        assert (modelId != null);
        return !this.getRoles(modelId).isEmpty();
    }

    public boolean isEnrolled() {
        return this.getUserContext().isEnrolled();
    }

    public synchronized IUserContext updateUserContext(IUserContext context) {
        assert (context != null);
        return context.isValid() ? context : this.initUserContext(context.getUserId());
    }

    public synchronized IUserContext initUserContext(String userId) {
        IUserContext context = UserContextManager.getContext();
        if (userId.equals(context.getUserId()) && context.isValid()) {
            return context;
        }
        UserContext userContext = new UserContext(userId);
        UserContextManager.setContext(userContext);
        List models = this.modelService.getModels();
        for (SecurityModel securityModel : models) {
            String modelId = securityModel.getId();
            try {
                userContext.setRoles(modelId, this.loadRoles(securityModel, userId));
                userContext.addSecurityModels(modelId, (EPackage)securityModel);
            }
            catch (UamClientException e) {
                this.logger.trace("Error while loading the model {}. Ignore it", (Object)modelId, (Object)e);
            }
        }
        return userContext;
    }

    @Required
    public void setUserRoles(IUserRoleService userRoles) {
        this.userRoles = userRoles;
    }

    @Required
    public void setUserManager(IUserManager userManager) {
        this.userManager = userManager;
    }
}

