/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.flexess.client.impl.spel;

import java.util.Collection;
import java.util.Optional;
import one.util.streamex.StreamEx;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;

public class EmfPropertyAccessor
implements PropertyAccessor {
    private static final Class<?>[] TARGET_CLASSES = new Class[]{EObject.class};

    public Class<?>[] getSpecificTargetClasses() {
        return TARGET_CLASSES;
    }

    public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
        if (target instanceof EObject) {
            EObject eobject = (EObject)target;
            return this.hasEStructuralFeature(eobject, name);
        }
        return false;
    }

    private boolean hasEStructuralFeature(EObject eobject, String name) {
        return StreamEx.of((Collection)eobject.eClass().getEAllStructuralFeatures()).anyMatch(f -> EmfPropertyAccessor.check(f, name));
    }

    private Optional<EStructuralFeature> getEStructuralFeature(EObject eobject, String name) {
        return StreamEx.of((Collection)eobject.eClass().getEAllStructuralFeatures()).findAny(f -> EmfPropertyAccessor.check(f, name));
    }

    private static boolean check(EStructuralFeature feature, String name) {
        return name.equalsIgnoreCase(feature.getName());
    }

    public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
        if (target instanceof EObject) {
            EObject eobject = (EObject)target;
            Optional<EStructuralFeature> feature = this.getEStructuralFeature(eobject, name);
            Object value = eobject.eGet(feature.get());
            return new TypedValue(value);
        }
        throw new IllegalStateException("Target object isn't a EMF object");
    }

    public boolean canWrite(EvaluationContext context, Object target, String name) throws AccessException {
        return false;
    }

    public void write(EvaluationContext context, Object target, String name, Object newValue) throws AccessException {
        throw new UnsupportedOperationException();
    }
}

