/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.flexess.client.impl;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.OCL;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.Query;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.helper.OCLHelper;
import org.jresearch.flexess.client.IConstraintEvaluator;
import org.jresearch.flexess.client.UamClientException;
import org.jresearch.flexess.core.model.uam.PObject;
import org.jresearch.flexess.core.model.uam.POperation;
import org.jresearch.flexess.core.model.uam.Permission;
import org.jresearch.flexess.core.model.uam.UamElement;
import org.jresearch.flexess.core.model.uam.UamPackage;

public class EmfOclEvaluator
implements IConstraintEvaluator {
    @Override
    public boolean evaluate(EObject pObjectInstance, EObject roleInstance, POperation operation) {
        PObject pObject = (PObject)pObjectInstance.eClass();
        Collection<EObject> permissionInstances = EmfOclEvaluator.findPermission(pObject, roleInstance, operation);
        for (EObject permissionInstance : permissionInstances) {
            if (!EmfOclEvaluator.checkPermission(pObjectInstance, permissionInstance)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkPermission(EObject pObjectInstance, EObject permissionInstance) {
        Permission permission = (Permission)permissionInstance.eClass();
        permissionInstance.eSet(permission.getEStructuralFeature("object"), (Object)pObjectInstance);
        String expession = permission.getConstraint().getExpession();
        OCL ocl = OCL.newInstance((EnvironmentFactory)EcoreEnvironmentFactory.INSTANCE);
        OCLHelper helper = ocl.createOCLHelper();
        helper.setContext((Object)permission);
        try {
            Constraint constraint = (Constraint)helper.createInvariant(expession);
            Query constraintEval = ocl.createQuery((Object)constraint);
            return constraintEval.check((Object)permissionInstance);
        }
        catch (ParserException e) {
            throw new UamClientException(MessageFormat.format("Incorrect expression: {0}. {1}", expession, e.getLocalizedMessage()), (Throwable)e);
        }
    }

    private static Collection<EObject> findPermission(PObject object, EObject roleInstance, POperation operation) {
        assert (object.getEOperations().contains((Object)operation));
        LinkedList<EObject> result = new LinkedList<EObject>();
        EList structuralFeatures = roleInstance.eClass().getEStructuralFeatures();
        for (EStructuralFeature feature : structuralFeatures) {
            EClassifier type = feature.getEType();
            if (!UamPackage.eINSTANCE.getPermission().isInstance((Object)type) || !EmfOclEvaluator.isOperationPermission((Permission)type, operation)) continue;
            result.add((EObject)roleInstance.eGet(feature));
        }
        return result;
    }

    private static boolean isOperationPermission(Permission permission, POperation operation) {
        EList operations = permission.getPOperation();
        return EmfOclEvaluator.contains((List<POperation>)operations, operation) || operations.isEmpty() && ((UamElement)operation.getEContainingClass()).getId().equals(permission.getPObject().getId());
    }

    private static boolean contains(List<POperation> operations, POperation testOperation) {
        for (POperation operation : operations) {
            if (!operation.getId().equals(testOperation.getId())) continue;
            return true;
        }
        return false;
    }
}

