/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.flexess.client.impl;

import java.text.MessageFormat;
import org.jresearch.flexess.client.FlexessConnectException;
import org.jresearch.flexess.client.IUserManager;
import org.jresearch.flexess.client.UamClientException;
import org.jresearch.flexess.core.IUserService;
import org.jresearch.flexess.umi.api.AuthenticationException;
import org.jresearch.flexess.umi.api.IAuthenticationData;
import org.jresearch.flexess.umi.api.IResetAuthenticationData;
import org.jresearch.flexess.umi.api.ISignUpData;
import org.jresearch.flexess.umi.api.IUser;
import org.jresearch.flexess.umi.api.ResetAuthenticationException;
import org.jresearch.flexess.umi.api.SignUpException;
import org.jresearch.flexess.umi.api.UmiException;
import org.jresearch.flexess.umi.api.UnsupportedAuthenticationMethodException;
import org.springframework.remoting.RemoteAccessException;

public class UserManager
implements IUserManager {
    private IUserService userService;

    public IUserService getUserService() {
        return this.userService;
    }

    public void setUserService(IUserService userService) {
        this.userService = userService;
    }

    @Override
    public IUser getUser(String userId) throws UamClientException {
        try {
            return this.userService.getUser(userId);
        }
        catch (UmiException e) {
            throw new UamClientException(MessageFormat.format("Unable to find application: {0}.", e.getLocalizedMessage()), (Throwable)e);
        }
        catch (RemoteAccessException e) {
            throw new FlexessConnectException(MessageFormat.format("Can't connect: {0}.", e.getLocalizedMessage()), (Throwable)e);
        }
    }

    public IUser authenticate(IAuthenticationData authenticationData) throws AuthenticationException, UnsupportedAuthenticationMethodException {
        return this.userService.authenticate(authenticationData);
    }

    public boolean isResetEnable() {
        try {
            return this.userService.isResetEnable();
        }
        catch (UmiException e) {
            throw new UamClientException(MessageFormat.format("Some UNI problem: {0}.", e.getLocalizedMessage()), (Throwable)e);
        }
    }

    public void reset(IResetAuthenticationData resetAuthData) throws ResetAuthenticationException, UnsupportedAuthenticationMethodException {
        try {
            this.userService.reset(resetAuthData);
        }
        catch (UmiException e) {
            throw new UamClientException(MessageFormat.format("Some UMI problem: {0}.", e.getLocalizedMessage()), (Throwable)e);
        }
    }

    public boolean isSignUpEnable() {
        try {
            return this.userService.isSignUpEnable();
        }
        catch (UmiException e) {
            throw new UamClientException(MessageFormat.format("Some UNI problem: {0}.", e.getLocalizedMessage()), (Throwable)e);
        }
    }

    public void signUp(ISignUpData signUpData) throws SignUpException, UnsupportedAuthenticationMethodException {
        try {
            this.userService.signUp(signUpData);
        }
        catch (UmiException e) {
            throw new SignUpException((Throwable)e);
        }
    }
}

