/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.flexess.core.model.conf.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.jresearch.flexess.core.model.conf.Application;
import org.jresearch.flexess.core.model.conf.ApplicationType;
import org.jresearch.flexess.core.model.conf.ConfFactory;
import org.jresearch.flexess.core.model.conf.ConfPackage;
import org.jresearch.flexess.core.model.conf.UserManagement;
import org.jresearch.flexess.core.model.conf.impl.ApplicationImpl;
import org.jresearch.flexess.core.model.conf.impl.UserManagementImpl;

public class ConfFactoryImpl
extends EFactoryImpl
implements ConfFactory {
    public static ConfFactory init() {
        try {
            ConfFactory theConfFactory = (ConfFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.jresearchsoft.com/schemas/conf");
            if (theConfFactory != null) {
                return theConfFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new ConfFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createApplication();
            }
            case 1: {
                return this.createUserManagement();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 2: {
                return this.createApplicationTypeFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 2: {
                return this.convertApplicationTypeToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Application createApplication() {
        ApplicationImpl application = new ApplicationImpl();
        return application;
    }

    @Override
    public UserManagement createUserManagement() {
        UserManagementImpl userManagement = new UserManagementImpl();
        return userManagement;
    }

    public ApplicationType createApplicationTypeFromString(EDataType eDataType, String initialValue) {
        ApplicationType result = ApplicationType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertApplicationTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public ConfPackage getConfPackage() {
        return (ConfPackage)this.getEPackage();
    }

    public static ConfPackage getPackage() {
        return ConfPackage.eINSTANCE;
    }
}

