/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.flexess.core.model.conf;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class ApplicationType
extends AbstractEnumerator {
    public static final int STANDALONE_SINGLE = 0;
    public static final int STANDALONE_SERVER = 1;
    public static final int WEB_SINGLE = 2;
    public static final int WEB_SERVER = 3;
    public static final ApplicationType STANDALONE_SINGLE_LITERAL = new ApplicationType(0, "Standalone with local Flexess", "standaloneSingle");
    public static final ApplicationType STANDALONE_SERVER_LITERAL = new ApplicationType(1, "Standalone with Flexess server", "standaloneServer");
    public static final ApplicationType WEB_SINGLE_LITERAL = new ApplicationType(2, "Web application with local Flexess", "webSingle");
    public static final ApplicationType WEB_SERVER_LITERAL = new ApplicationType(3, "Web application with Flexess server", "webServer");
    private static final ApplicationType[] VALUES_ARRAY = new ApplicationType[]{STANDALONE_SINGLE_LITERAL, STANDALONE_SERVER_LITERAL, WEB_SINGLE_LITERAL, WEB_SERVER_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static ApplicationType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ApplicationType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static ApplicationType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ApplicationType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static ApplicationType get(int value) {
        switch (value) {
            case 0: {
                return STANDALONE_SINGLE_LITERAL;
            }
            case 1: {
                return STANDALONE_SERVER_LITERAL;
            }
            case 2: {
                return WEB_SINGLE_LITERAL;
            }
            case 3: {
                return WEB_SERVER_LITERAL;
            }
        }
        return null;
    }

    private ApplicationType(int value, String name, String literal) {
        super(value, name, literal);
    }
}

