/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.flexess.core.model.util;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.jresearch.flexess.core.model.uam.SecurityModel;
import org.jresearch.flexess.core.model.uam.UamFactory;

public class SecurityModelHelper {
    private SecurityModelHelper() {
    }

    public static Resource loadSecurityModel(String securityFile) {
        File secFile = new File(securityFile);
        URI securityFileURI = URI.createFileURI((String)secFile.getAbsolutePath());
        return SecurityModelHelper.loadSecurityModel(securityFileURI);
    }

    public static Resource loadSecurityModel(URI securityFileURI) {
        assert (securityFileURI != null);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        try {
            return resourceSet.getResource(securityFileURI, true);
        }
        catch (Exception e) {
            Resource secResource = resourceSet.createResource(securityFileURI);
            SecurityModel secPackage = UamFactory.eINSTANCE.createSecurityModel();
            secPackage.setName(SecurityModelHelper.getModelName(securityFileURI));
            secResource.getContents().add((Object)secPackage);
            return secResource;
        }
    }

    private static String getModelName(URI securityFileURI) {
        assert (securityFileURI != null);
        return securityFileURI.trimFileExtension().lastSegment();
    }

    public static Resource loadInstanceModel(String instanceFile) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File instFile = new File(instanceFile);
        URI instanceFileURI = URI.createFileURI((String)instFile.getAbsolutePath());
        Resource instResource = !instFile.exists() ? resourceSet.createResource(instanceFileURI) : resourceSet.getResource(instanceFileURI, true);
        return instResource;
    }

    public static void save(Resource res) throws IOException {
        res.save(Collections.EMPTY_MAP);
    }

    public static void save(SecurityModel model, String fileName) throws IOException {
        File file = new File(fileName);
        URI fileURI = URI.createFileURI((String)file.getAbsolutePath());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource secResource = resourceSet.createResource(fileURI);
        model.setName(SecurityModelHelper.getModelName(fileURI));
        secResource.getContents().add((Object)model);
        SecurityModelHelper.save(secResource);
    }

    public static void saveAs(Resource resource, String fileName) throws IOException {
        File file = new File(fileName);
        URI fileURI = URI.createFileURI((String)file.getAbsolutePath());
        resource.setURI(fileURI);
        SecurityModelHelper.save(resource);
    }
}

