/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.flexess.core.model.category.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.jresearch.flexess.core.model.category.ICategoryManager;
import org.jresearch.flexess.core.model.uam.Permission;
import org.jresearch.flexess.core.model.uam.SecurityModel;
import org.jresearch.flexess.core.model.uam.UamPackage;

public class CategoryManager
implements ICategoryManager {
    private static CategoryManager manager;
    private static String delimeter;

    private CategoryManager() {
    }

    public static ICategoryManager getInstance() {
        if (manager == null) {
            manager = new CategoryManager();
        }
        return manager;
    }

    @Override
    public void addCategory(String category, Permission permission) {
        if (!this.isValidCategory(category)) {
            throw new IllegalArgumentException("Category must be alphanumeric");
        }
        this.addCategoryToModelElement(category, (EModelElement)permission);
        this.addCategoryToModelElement(category, (EModelElement)permission.getEPackage());
    }

    private void addCategoryToModelElement(String category, EModelElement modelElement) {
        if (!this.hasCategory(category, modelElement)) {
            String categoryString = this.getCategoryString(modelElement);
            if (categoryString.length() == 0) {
                this.setCategoryString(category, modelElement);
            } else {
                this.setCategoryString(categoryString + delimeter + category, modelElement);
            }
        }
    }

    private void removeCategoryFromModelElement(String category, EModelElement modelElement) {
        String categoryString = this.getCategoryString(modelElement);
        if (categoryString.equals(category)) {
            categoryString = new String();
        }
        categoryString = categoryString.endsWith(category) ? categoryString.replace(delimeter + category, "") : categoryString.replace(category + delimeter, "");
        this.setCategoryString(categoryString, modelElement);
    }

    @Override
    public void removeCategory(String category, Permission permission) {
        if (category == null) {
            throw new IllegalArgumentException("Category must not be null");
        }
        this.removeCategoryFromModelElement(category, (EModelElement)permission);
        Collection permissions = EcoreUtil.getObjectsByType((Collection)permission.getEPackage().getEClassifiers(), (EClassifier)UamPackage.eINSTANCE.getPermission());
        boolean found = false;
        for (Permission perm : permissions) {
            if (!this.hasCategory(category, (EModelElement)perm)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.removeCategoryFromModelElement(category, (EModelElement)permission.getEPackage());
        }
    }

    @Override
    public void removeCategory(String category, SecurityModel model) {
        if (category == null) {
            throw new IllegalArgumentException("Category must not be null");
        }
        Collection permissions = EcoreUtil.getObjectsByType((Collection)model.getEClassifiers(), (EClassifier)UamPackage.eINSTANCE.getPermission());
        for (Permission permission : permissions) {
            this.removeCategoryFromModelElement(category, (EModelElement)permission);
        }
        this.removeCategoryFromModelElement(category, (EModelElement)model);
    }

    @Override
    public boolean isValidCategory(String str) {
        if (str == null) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isLetterOrDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private void setCategoryString(String category, EModelElement modelElement) {
        EcoreUtil.setAnnotation((EModelElement)modelElement, (String)"http://www.jresearchsoft.com/schemas/uam", (String)"category", (String)category);
    }

    private String getCategoryString(EModelElement modelElement) {
        String result = EcoreUtil.getAnnotation((EModelElement)modelElement, (String)"http://www.jresearchsoft.com/schemas/uam", (String)"category");
        if (result == null) {
            return "";
        }
        return result;
    }

    @Override
    public boolean hasCategory(EModelElement modelElement) {
        String result = EcoreUtil.getAnnotation((EModelElement)modelElement, (String)"http://www.jresearchsoft.com/schemas/uam", (String)"category");
        return result != null;
    }

    @Override
    public boolean hasCategory(String category, EModelElement modelElement) {
        if (category == null) {
            throw new IllegalArgumentException("Category must not be null");
        }
        String categories = this.getCategoryString(modelElement);
        StringTokenizer tokenizer = new StringTokenizer(categories, delimeter);
        while (tokenizer.hasMoreTokens()) {
            if (!category.equals(tokenizer.nextToken())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> getCategories(EModelElement modelElement) {
        ArrayList<String> result = new ArrayList<String>();
        String categories = this.getCategoryString(modelElement);
        StringTokenizer tokenizer = new StringTokenizer(categories, delimeter);
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result;
    }

    static {
        delimeter = ",";
    }
}

