/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.flexess.core.model.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EStructuralFeatureImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.jresearch.flexess.core.model.uam.PObject;
import org.jresearch.flexess.core.model.uam.Permission;
import org.jresearch.flexess.core.model.uam.Role;
import org.jresearch.flexess.core.model.uam.UamPackage;

public class EMFUtil {
    private static final EcoreFactory ECORE_FACTORY = EcoreFactory.eINSTANCE;
    private static final boolean IS_CONTAINMENT = true;
    private static final boolean IS_RESOLVE_PROXIES = true;
    private static final boolean IS_UNIQUE = true;
    private static final boolean IS_TRANSIENT = true;
    private static final boolean IS_VOLATILE = true;
    private static final boolean IS_CHANGEABLE = true;
    private static final boolean IS_UNSETTABLE = true;
    private static final boolean IS_DERIVED = true;
    private static final boolean IS_ORDERED = true;

    public static void setAnnotation(EModelElement modelElement, String key, String value) {
        EcoreUtil.setAnnotation((EModelElement)modelElement, (String)"http://www.jresearchsoft.com/schemas/uam", (String)key, (String)value);
    }

    public static String getAnnotation(EModelElement modelElement, String key) {
        return EcoreUtil.getAnnotation((EModelElement)modelElement, (String)"http://www.jresearchsoft.com/schemas/uam", (String)key);
    }

    public static EDataType findType(String typeName) {
        for (EClassifier classifier : EcorePackage.eINSTANCE.getEClassifiers()) {
            if (!EcorePackage.eINSTANCE.getEDataType().isInstance((Object)classifier)) continue;
            String instanceClassName = classifier.getInstanceClassName();
            if (!typeName.equals(classifier.getName()) && !instanceClassName.equals(typeName) && !instanceClassName.equals("java.lang." + typeName)) continue;
            return (EDataType)classifier;
        }
        return null;
    }

    public static EReference addPermission(Role role, Permission permission) {
        EReference backReference = ECORE_FACTORY.createEReference();
        permission.getEStructuralFeatures().add((Object)backReference);
        EReference reference = ECORE_FACTORY.createEReference();
        role.getEStructuralFeatures().add((Object)reference);
        EMFUtil.initEReference(backReference, (EClassifier)role, reference, role.getName(), null, 0, 1, Permission.class, false, false, true, false, true, false, true, false, false);
        EMFUtil.initEReference(reference, (EClassifier)permission, backReference, permission.getName(), null, 0, 1, Role.class, false, false, true, false, true, false, true, false, false);
        return reference;
    }

    public static EReference getPermission(Role role, Permission permission) {
        EList structuralFeatures = role.getEReferences();
        for (EReference feature : structuralFeatures) {
            EClassifier type = feature.getEType();
            if (!UamPackage.eINSTANCE.getPermission().isInstance((Object)type) || !feature.getEType().getName().equals(permission.getName())) continue;
            return feature;
        }
        return null;
    }

    public static EReference addPobject(Permission permission, PObject pObject) {
        assert (permission != null && pObject != null);
        EMFUtil.removePObject(permission);
        EReference reference = ECORE_FACTORY.createEReference();
        permission.getEStructuralFeatures().add((Object)reference);
        EMFUtil.initEReference(reference, (EClassifier)pObject, null, "object", null, 0, 1, Permission.class, false, false, true, false, true, false, true, false, false);
        return reference;
    }

    public static boolean removePObject(Permission permission, PObject pObject) {
        EList structuralFeatures = permission.getEStructuralFeatures();
        for (EStructuralFeature feature : structuralFeatures) {
            String name = feature.getName();
            if (!name.equals("object") || !EcoreUtil.equals((EObject)feature.getEType(), (EObject)pObject)) continue;
            return structuralFeatures.remove(feature);
        }
        return false;
    }

    public static List<Permission> getPermissions(Role role) {
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        EList structuralFeatures = role.getEStructuralFeatures();
        for (EStructuralFeature feature : structuralFeatures) {
            EClassifier type = feature.getEType();
            if (!UamPackage.eINSTANCE.getPermission().isInstance((Object)type)) continue;
            permissions.add((Permission)type);
        }
        return permissions;
    }

    public static HashMap<String, Permission> getPermissionsMap(Role role) {
        HashMap<String, Permission> permissions = new HashMap<String, Permission>();
        EList structuralFeatures = role.getEStructuralFeatures();
        for (EStructuralFeature feature : structuralFeatures) {
            EClassifier type = feature.getEType();
            if (!UamPackage.eINSTANCE.getPermission().isInstance((Object)type)) continue;
            Permission perm = (Permission)type;
            permissions.put(perm.getId(), perm);
        }
        return permissions;
    }

    public static List<Role> getRoles(Permission permission) {
        ArrayList<Role> roles = new ArrayList<Role>();
        EList structuralFeatures = permission.getEStructuralFeatures();
        for (EStructuralFeature feature : structuralFeatures) {
            EClassifier type = feature.getEType();
            if (!UamPackage.eINSTANCE.getRole().isInstance((Object)type)) continue;
            roles.add((Role)type);
        }
        return roles;
    }

    public static void removePObject(Permission permission) {
        EList structuralFeatures = permission.getEStructuralFeatures();
        Iterator iterator = structuralFeatures.iterator();
        while (iterator.hasNext()) {
            EStructuralFeature feature = (EStructuralFeature)iterator.next();
            if (!"object".equals(feature.getName())) continue;
            iterator.remove();
        }
    }

    public static void initEStructuralFeature(EStructuralFeature s, EClassifier type, String name, int lowerBound, int upperBound, Class containerClass) {
        s.setName(name);
        ((EStructuralFeatureImpl)s).setContainerClass(containerClass);
        s.setTransient(false);
        s.setVolatile(false);
        s.setChangeable(true);
        s.setUnsettable(false);
        s.setUnique(true);
        s.setDerived(false);
        s.setOrdered(true);
        s.setLowerBound(lowerBound);
        s.setUpperBound(upperBound);
        s.setEType(type);
    }

    public static EReference initEReference(EReference r, EClassifier type, String name, int lowerBound, int upperBound, Class containerClass) {
        EMFUtil.initEStructuralFeature((EStructuralFeature)r, type, name, lowerBound, upperBound, containerClass);
        r.setContainment(false);
        r.setResolveProxies(true);
        return r;
    }

    public static EReference initOneToOneEReference(EReference r, EClassifier type, String name, int lowerBound, int upperBound, Class containerClass) {
        EMFUtil.initEStructuralFeature((EStructuralFeature)r, type, name, lowerBound, upperBound, containerClass);
        r.setContainment(false);
        r.setResolveProxies(true);
        return r;
    }

    public static EReference initEReference(EReference r, EClassifier type, EReference otherEnd, String name, String defaultValue, int lowerBound, int upperBound, boolean isTransient, boolean isVolatile, boolean isChangeable, boolean isContainment, boolean isResolveProxies, boolean isUnsettable, boolean isUnique, boolean isDerived) {
        EMFUtil.initEReference(r, type, otherEnd, name, defaultValue, lowerBound, upperBound, isTransient, isVolatile, isChangeable, isContainment, isResolveProxies, isUnsettable, isUnique, isDerived, true);
        return r;
    }

    public static EReference initEReference(EReference r, EClassifier type, EReference otherEnd, String name, String defaultValue, int lowerBound, int upperBound, boolean isTransient, boolean isVolatile, boolean isChangeable, boolean isContainment, boolean isResolveProxies, boolean isUnsettable, boolean isUnique, boolean isDerived, boolean isOrdered) {
        EMFUtil.initEReference(r, type, otherEnd, name, defaultValue, lowerBound, upperBound, ((EClassifier)r.eContainer()).getInstanceClass(), isTransient, isVolatile, isChangeable, isContainment, isResolveProxies, isUnsettable, isUnique, isDerived, isOrdered);
        return r;
    }

    public static EReference initEReference(EReference r, EClassifier type, EReference otherEnd, String name, String defaultValue, int lowerBound, int upperBound, Class containerClass, boolean isTransient, boolean isVolatile, boolean isChangeable, boolean isContainment, boolean isResolveProxies, boolean isUnsettable, boolean isUnique, boolean isDerived, boolean isOrdered) {
        EMFUtil.initEStructuralFeature((EStructuralFeature)r, type, name, defaultValue, lowerBound, upperBound, containerClass, isTransient, isVolatile, isChangeable, isUnsettable, isUnique, isDerived, isOrdered);
        r.setContainment(isContainment);
        if (otherEnd != null) {
            r.setEOpposite(otherEnd);
        }
        r.setResolveProxies(isResolveProxies);
        return r;
    }

    public static void initEStructuralFeature(EStructuralFeature s, EClassifier type, String name, String defaultValue, int lowerBound, int upperBound, Class containerClass, boolean isTransient, boolean isVolatile, boolean isChangeable, boolean isUnsettable, boolean isUnique, boolean isDerived, boolean isOrdered) {
        s.setName(name);
        ((EStructuralFeatureImpl)s).setContainerClass(containerClass);
        s.setTransient(isTransient);
        s.setVolatile(isVolatile);
        s.setChangeable(isChangeable);
        s.setUnsettable(isUnsettable);
        s.setUnique(isUnique);
        s.setDerived(isDerived);
        s.setOrdered(isOrdered);
        s.setLowerBound(lowerBound);
        s.setUpperBound(upperBound);
        s.setEType(type);
        if (defaultValue != null) {
            s.setDefaultValueLiteral(defaultValue);
        }
    }

    public static EDataType getClassifier(int type) {
        for (EClassifier ecoreEClassifier : EcorePackage.eINSTANCE.getEClassifiers()) {
            if (!(ecoreEClassifier instanceof EDataType) || ((EDataType)ecoreEClassifier).getClassifierID() != type) continue;
            return (EDataType)ecoreEClassifier;
        }
        return null;
    }
}

