/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.flexess.models.xml.loader;

import java.text.MessageFormat;
import org.eclipse.emf.ecore.EObject;
import org.jresearch.flexess.models.xml.AttributeType;
import org.jresearch.flexess.models.xml.UamElementType;

public class LoadModelException
extends Exception {
    private static final long serialVersionUID = -5804074154463848802L;
    private final UamElementType element;
    private final AttributeType attribute;

    public LoadModelException(UamElementType element) {
        this.element = element;
        this.attribute = null;
    }

    public LoadModelException(AttributeType attribute) {
        this.attribute = attribute;
        this.element = null;
    }

    public LoadModelException(UamElementType element, String pattern, Object ... parameters) {
        super(MessageFormat.format(pattern, parameters));
        this.element = element;
        this.attribute = null;
    }

    public LoadModelException(AttributeType attribute, String pattern, Object ... parameters) {
        super(MessageFormat.format(pattern, parameters));
        this.attribute = attribute;
        this.element = null;
    }

    public LoadModelException(Throwable cause, UamElementType element) {
        super(cause);
        this.element = element;
        this.attribute = null;
    }

    public LoadModelException(Throwable cause, AttributeType attribute) {
        super(cause);
        this.attribute = attribute;
        this.element = null;
    }

    public LoadModelException(Throwable cause, UamElementType element, String pattern, Object ... parameters) {
        super(MessageFormat.format(pattern, parameters), cause);
        this.element = element;
        this.attribute = null;
    }

    public LoadModelException(Throwable cause, AttributeType attribute, String pattern, Object ... parameters) {
        super(MessageFormat.format(pattern, parameters), cause);
        this.attribute = attribute;
        this.element = null;
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        if (this.element != null) {
            message = MessageFormat.format("Error loading element with Id {0} ({1}): {2}", this.element.getId(), this.element.eResource().getURIFragment((EObject)this.element), message);
        } else if (this.attribute != null) {
            message = MessageFormat.format("Error loading attribute with name {0} ({1}): {2}", this.attribute.getName(), this.attribute.eResource().getURIFragment((EObject)this.attribute), message);
        }
        return message;
    }
}

