/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.flexess.models.xml.loader;

import java.util.HashMap;
import org.jresearch.flexess.core.model.uam.PObject;
import org.jresearch.flexess.core.model.uam.Permission;
import org.jresearch.flexess.core.model.uam.SecurityModel;
import org.jresearch.flexess.core.model.uam.UamElement;
import org.jresearch.flexess.core.model.uam.UamFactory;
import org.jresearch.flexess.models.xml.ProtectedObjectType;
import org.jresearch.flexess.models.xml.RoleTemplateType;
import org.jresearch.flexess.models.xml.SecurityModelType;
import org.jresearch.flexess.models.xml.loader.ElementConverter;
import org.jresearch.flexess.models.xml.loader.LoadModelException;
import org.jresearch.flexess.models.xml.loader.PObjectConverter;
import org.jresearch.flexess.models.xml.loader.RoleTemplateConverter;

public class ModelConverter
extends ElementConverter<SecurityModelType, SecurityModel> {
    public ModelConverter(SecurityModelType xmlElement) {
        super(xmlElement, new HashMap<String, UamElement>());
    }

    @Override
    public SecurityModel rawConvert() throws LoadModelException {
        SecurityModel result = (SecurityModel)super.rawConvert();
        for (ProtectedObjectType object : ((SecurityModelType)this.getXmlElement()).getProtectedObject()) {
            PObject pObject = (PObject)new PObjectConverter(object, this.getConverted()).convert();
            result.getEClassifiers().add((Object)pObject);
            for (Permission permission : pObject.getPermission()) {
                result.getEClassifiers().add((Object)permission);
            }
        }
        for (RoleTemplateType role : ((SecurityModelType)this.getXmlElement()).getRoleTemplate()) {
            result.getEClassifiers().add(new RoleTemplateConverter(role, this.getConverted()).convert());
        }
        return result;
    }

    @Override
    public SecurityModel create() {
        return UamFactory.eINSTANCE.createSecurityModel();
    }
}

