/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.flexess.models.xml.loader;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.jresearch.flexess.core.model.uam.UamElement;
import org.jresearch.flexess.core.model.util.EMFUtil;
import org.jresearch.flexess.models.xml.UamElementType;
import org.jresearch.flexess.models.xml.loader.IConverter;
import org.jresearch.flexess.models.xml.loader.LoadModelException;

public abstract class ElementConverter<X extends UamElementType, U extends UamElement & ENamedElement>
implements IConverter<U> {
    private final X xmlElement;
    private final Map<String, UamElement> converted;

    public ElementConverter(X xmlElement, Map<String, UamElement> converted) {
        this.xmlElement = xmlElement;
        this.converted = converted;
    }

    public X getXmlElement() {
        return this.xmlElement;
    }

    @Override
    public final U convert() throws LoadModelException {
        Object result = this.getConverted().get(this.xmlElement.getId());
        if (result == null) {
            result = this.rawConvert();
            this.converted.put(this.xmlElement.getId(), (UamElement)result);
        }
        return (U)result;
    }

    public U rawConvert() throws LoadModelException {
        U result = this.create();
        result.setId(this.xmlElement.getId());
        ((ENamedElement)result).setName(StringUtils.isNotBlank((String)this.xmlElement.getName()) ? this.xmlElement.getName() : this.xmlElement.getId());
        EMFUtil.setAnnotation((EModelElement)((EModelElement)result), (String)"#description", (String)this.xmlElement.getDescription());
        return result;
    }

    public abstract U create();

    public Map<String, UamElement> getConverted() {
        return this.converted;
    }
}

