/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.flexess.models.xml.loader;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EcoreFactory;
import org.jresearch.flexess.core.model.util.EMFUtil;
import org.jresearch.flexess.models.xml.AttributeType;
import org.jresearch.flexess.models.xml.loader.IConverter;
import org.jresearch.flexess.models.xml.loader.LoadModelException;

public class AttributeConverter<X extends AttributeType>
implements IConverter<EAttribute> {
    private final X xmlElement;

    public AttributeConverter(X xmlElement) {
        this.xmlElement = xmlElement;
    }

    @Override
    public EAttribute convert() throws LoadModelException {
        EAttribute result = EcoreFactory.eINSTANCE.createEAttribute();
        result.setName(this.getXmlElement().getName());
        EDataType type = EMFUtil.findType((String)this.getXmlElement().getType());
        if (type == null) {
            throw new LoadModelException((AttributeType)this.xmlElement, "Can''t find mapping for Java class: {0}", this.getXmlElement().getType());
        }
        result.setEType((EClassifier)type);
        return result;
    }

    public X getXmlElement() {
        return this.xmlElement;
    }
}

