/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.flexess.test.umi;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.RandomStringUtils;
import org.jresearch.flexess.umi.api.ConnectionException;
import org.jresearch.flexess.umi.api.IAttributeInfo;
import org.jresearch.flexess.umi.api.IAuthenticationData;
import org.jresearch.flexess.umi.api.IListSettings;
import org.jresearch.flexess.umi.api.ISearchCriteria;
import org.jresearch.flexess.umi.api.IUser;
import org.jresearch.flexess.umi.api.UnknownUserException;
import org.jresearch.flexess.umi.api.UnsupportedAuthenticationMethodException;
import org.jresearch.flexess.umi.api.connection.ConnectionStatusType;
import org.jresearch.flexess.umi.api.connection.IConnectionStatus;
import org.jresearch.flexess.umi.api.connection.impl.ConnectionStatus;
import org.jresearch.flexess.umi.api.impl.AbstractUserManager;
import org.jresearch.flexess.umi.api.impl.User;

public class TestUserManager
extends AbstractUserManager {
    private final ConnectionStatus initStatus = new ConnectionStatus(ConnectionStatusType.OK, "Communicate with test user manager");
    private final Map<String, User> users = Maps.newHashMap();

    public IUser createNewUser() {
        return this.createNewUser(RandomStringUtils.randomAlphabetic((int)10));
    }

    @Nonnull
    public IUser createNewUser(@Nonnull String id) {
        User result = this.users.get(id);
        if (result == null) {
            result = new User(id);
            this.users.put(id, result);
        }
        return result;
    }

    public IUser authenticate(IAuthenticationData data) throws UnsupportedAuthenticationMethodException {
        return (IUser)this.users.get(data.getUserName());
    }

    public long countUsers() {
        return this.users.size();
    }

    public long countUsers(ISearchCriteria criteria) {
        throw new UnsupportedOperationException();
    }

    public Collection<IAttributeInfo> getAttributeInfo() {
        return Lists.newArrayList();
    }

    public Collection<String> getUserIds() {
        return ImmutableList.copyOf(this.users.keySet());
    }

    public Collection<IUser> getUsers() {
        return ImmutableList.copyOf(this.users.values());
    }

    public Collection<IUser> getUsers(IListSettings settings) {
        throw new UnsupportedOperationException();
    }

    public boolean supportsCounting() {
        return true;
    }

    public IConnectionStatus testConnection() {
        return this.initStatus;
    }

    public <T> T getAttributeValue(String userId, Object attributeId) throws UnknownUserException, ConnectionException {
        if (!this.users.containsKey(userId)) {
            throw new UnknownUserException(userId);
        }
        return null;
    }

    public IUser getUserByName(@Nonnull String userName) {
        return (IUser)this.users.get(userName);
    }

    @Nonnull
    public IUser registerUser(@Nonnull String userName) {
        return this.createNewUser(userName);
    }

    protected IUser getApplicationUser(String userId) {
        return (IUser)this.users.get(userId);
    }

    public void reset() {
        this.users.clear();
    }
}

