/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.flexess.umi.api.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.jresearch.flexess.umi.api.IUser;
import org.jresearch.flexess.umi.api.UserAttributeNotFoundException;

public class User
implements IUser,
Serializable {
    private static final long serialVersionUID = 905744715624022881L;
    @Nonnull
    private String uid;
    private final Map<String, Object> attributes = new HashMap<String, Object>();

    public User() {
        this.uid = "";
    }

    public User(@Nonnull String id) {
        this.uid = id;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    @Override
    public <T> T getAttribute(@Nonnull String attributeName) throws UserAttributeNotFoundException {
        if (!this.attributes.containsKey(attributeName)) {
            throw new UserAttributeNotFoundException(attributeName, new Object[0]);
        }
        return (T)this.attributes.get(attributeName);
    }

    public void addAttribute(String attribute, Object value) {
        this.attributes.put(attribute, value);
    }

    public void removeAttribute(String attribute) {
        this.attributes.remove(attribute);
    }

    @Override
    @Nonnull
    public String getUid() {
        return this.uid;
    }
}

