/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.flexess.umi.service.impl;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jresearch.flexess.umi.api.IUmiUserManager;
import org.jresearch.flexess.umi.api.admin.IUmiProviderRegistry;
import org.jresearch.flexess.umi.api.admin.IUmiSettingsManager;
import org.jresearch.flexess.umi.dao.IUmiSettingsDao;
import org.jresearch.flexess.umi.internal.IUserManagement;
import org.jresearch.flexess.umi.internal.UmiSettingsManagerException;
import org.jresearch.flexess.umi.internal.UmiUserManagementException;
import org.jresearch.flexess.umi.provider.IProviderInfo;
import org.jresearch.flexess.umi.provider.IProviderPropertyGroupInfo;
import org.jresearch.flexess.umi.provider.IProviderPropertyInfo;
import org.jresearch.flexess.umi.provider.ISettings;
import org.jresearch.flexess.umi.provider.IUserManagerFactory;
import org.jresearch.flexess.umi.provider.impl.NamedValue;
import org.jresearch.flexess.umi.provider.impl.PropertyGroup;
import org.jresearch.flexess.umi.provider.impl.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class UmiSettingsManager
implements IUmiSettingsManager,
IUserManagement {
    private IUmiSettingsDao dao;
    private IUmiProviderRegistry registry;
    private final Map<String, IUmiUserManager> managers = new HashMap<String, IUmiUserManager>();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public List<? extends ISettings> getSettingsList() {
        return this.dao.getSettingsList();
    }

    public ISettings saveSettings(ISettings settings) {
        ISettings dbsettings = this.dao.saveSettings(settings);
        this.managers.remove(dbsettings.getId());
        return dbsettings;
    }

    public ISettings getSettings(String id) {
        return this.dao.getSettings(id);
    }

    public void deleteSettings(String id) {
        this.dao.deleteSettings(id);
        this.managers.remove(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IUmiUserManager getUserManager(String id) throws UmiUserManagementException {
        ISettings settings = this.getSettings(id);
        if (settings == null) {
            String message = "unable to retrive settings by id= " + id;
            this.logger.debug(message);
            throw new UmiUserManagementException(message);
        }
        if (!this.managers.containsKey(id)) {
            Map<String, IUmiUserManager> map = this.managers;
            synchronized (map) {
                if (!this.managers.containsKey(id)) {
                    this.managers.put(id, this.createUserManager(settings));
                }
                return this.managers.get(id);
            }
        }
        return this.managers.get(id);
    }

    @Override
    public IUmiUserManager createUserManager(ISettings settings) throws UmiUserManagementException {
        IProviderInfo providerInfo = this.registry.getProviderInfo(settings.getProviderId());
        if (providerInfo == null) {
            throw new UmiUserManagementException(MessageFormat.format("Can''t find provider information with id {0}", settings.getProviderId()));
        }
        try {
            IUserManagerFactory factory = providerInfo.getFactory();
            return factory.createManager(settings);
        }
        catch (Exception ex) {
            throw new UmiUserManagementException(MessageFormat.format("Unable to create IUserManager: {0}", ex.getLocalizedMessage()), ex);
        }
    }

    public void setDao(IUmiSettingsDao dao) {
        this.dao = dao;
    }

    public void setRegistry(IUmiProviderRegistry registry) {
        this.registry = registry;
    }

    public IUmiProviderRegistry getRegistry() {
        return this.registry;
    }

    public Collection<ISettings> getSettingsList(String providerId) {
        return this.dao.getSettingsList(providerId);
    }

    public ISettings getSettingsImpl(String providerId) {
        IProviderInfo providerInfo = this.registry.getProviderInfo(providerId);
        if (providerInfo == null) {
            throw new UmiSettingsManagerException("There is no registered provider found  by id= " + providerId);
        }
        Settings settings = new Settings();
        settings.setProviderId(providerInfo.getId());
        Collection groups = providerInfo.getPropertyGroups();
        for (IProviderPropertyGroupInfo group : groups) {
            Collection properties = group.getConfigurationInfo();
            PropertyGroup propertyGroup = new PropertyGroup();
            propertyGroup.setName(group.getName());
            for (IProviderPropertyInfo property : properties) {
                NamedValue nv = new NamedValue();
                nv.setName(property.getName());
                nv.setValue(property.getDefaultValue());
                propertyGroup.addProperty(nv);
            }
            settings.addGroup(propertyGroup);
        }
        return settings;
    }
}

