/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.flexess.umi.internal.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jresearch.flexess.umi.api.admin.IUmiProviderRegistry;
import org.jresearch.flexess.umi.provider.IProviderInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class UmiProviderRegistry
implements IUmiProviderRegistry,
ApplicationListener<ContextRefreshedEvent> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, IProviderInfo> providers = new HashMap<String, IProviderInfo>();

    public Collection<? extends IProviderInfo> getRegisteredProviderInfoList() {
        return Collections.unmodifiableCollection(this.providers.values());
    }

    public IProviderInfo getProviderInfo(String id) {
        return this.providers.get(id);
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        ApplicationContext ap = event.getApplicationContext();
        Map beans = ap.getBeansOfType(IProviderInfo.class);
        for (IProviderInfo pi : beans.values()) {
            if (pi.getFactory() != null) {
                this.providers.put(pi.getId(), pi);
                continue;
            }
            this.logger.warn("Skip UMI provider {} - factory is null", (Object)pi.getId());
        }
    }
}

