/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.flexess.umi.provider.impl;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.jresearch.flexess.umi.api.IUmiUserManager;
import org.jresearch.flexess.umi.api.UmiException;
import org.jresearch.flexess.umi.api.admin.IUmiSettingsManager;
import org.jresearch.flexess.umi.provider.IPropertyGroup;
import org.jresearch.flexess.umi.provider.ISettings;
import org.jresearch.flexess.umi.provider.IUserManagerFactory;
import org.jresearch.flexess.umi.provider.impl.NamedValue;
import org.jresearch.flexess.umi.provider.impl.PropertyGroup;
import org.jresearch.flexess.umi.provider.impl.Settings;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public final class SingleInstanceUserManagerFactory
implements IUserManagerFactory,
ApplicationContextAware {
    private static final String PROPERTY = "beanId";
    public static final String GROUP_NAME = "General";
    private Map<String, IUmiUserManager> singleUserManagers;
    private IUmiSettingsManager umiManagement;
    private ApplicationContext applicationContext;

    public IUmiUserManager createManager(ISettings settings) throws UmiException {
        assert (settings != null);
        IPropertyGroup group = (IPropertyGroup)settings.getPropertyGroups().get(GROUP_NAME);
        if (group == null) {
            throw new UmiException("Can''t find property {0} in group {1}.", new Object[]{PROPERTY, GROUP_NAME});
        }
        String beanId = group.getPropertyValue(PROPERTY);
        IUmiUserManager manager = this.singleUserManagers.get(beanId);
        if (manager == null) {
            throw new UmiException("User manager with id {0} doesn''t exists. Check the Spring beans definitions if bean with such id exists", new Object[]{beanId});
        }
        return manager;
    }

    public void init() {
        this.singleUserManagers = this.getUserManagerBeans(this.applicationContext);
        if (this.singleUserManagers.isEmpty()) {
            return;
        }
        Collection existSettings = this.umiManagement.getSettingsList("jresearchsoft.flexess.single");
        this.check(existSettings);
        for (String beanId : this.singleUserManagers.keySet()) {
            if (SingleInstanceUserManagerFactory.exists(beanId, existSettings)) continue;
            Settings settings = new Settings();
            settings.setProviderId("jresearchsoft.flexess.single");
            settings.setName(MessageFormat.format("User manager ({0})", beanId));
            NamedValue property = new NamedValue(PROPERTY, beanId);
            PropertyGroup propertyGroup = new PropertyGroup(GROUP_NAME);
            propertyGroup.addProperty(property);
            settings.addGroup(propertyGroup);
            this.umiManagement.saveSettings((ISettings)settings);
        }
    }

    private void check(Collection<ISettings> existSettings) {
        Iterator<ISettings> iterator = existSettings.iterator();
        while (iterator.hasNext()) {
            String beanId;
            ISettings settings = iterator.next();
            IPropertyGroup group = (IPropertyGroup)settings.getPropertyGroups().get(GROUP_NAME);
            if (group != null && (beanId = group.getPropertyValue(PROPERTY)) != null && this.applicationContext.containsBean(beanId)) continue;
            this.umiManagement.deleteSettings(settings.getId());
            iterator.remove();
        }
    }

    private Map<String, IUmiUserManager> getUserManagerBeans(ApplicationContext context) {
        if (context == null) {
            return Collections.emptyMap();
        }
        Map result = context.getBeansOfType(IUmiUserManager.class);
        result.putAll(this.getUserManagerBeans(context.getParent()));
        return result;
    }

    private static boolean exists(String beanId, Collection<ISettings> existSettings) {
        for (ISettings settings : existSettings) {
            IPropertyGroup group = (IPropertyGroup)settings.getPropertyGroups().get(GROUP_NAME);
            if (group == null || !beanId.equals(group.getPropertyValue(PROPERTY))) continue;
            return true;
        }
        return false;
    }

    @Required
    public void setUmiManagement(IUmiSettingsManager umiManagement) {
        this.umiManagement = umiManagement;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

