/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.gavka.web;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jresearch.commons.gwt.server.tool.ServerDates;
import org.jresearch.commons.gwt.shared.model.time.GwtLocalDateModel;
import org.jresearch.commons.gwt.shared.model.time.GwtLocalDateTimeModel;
import org.jresearch.commons.gwt.shared.model.time.GwtLocalTimeModel;
import org.jresearch.gavka.domain.KeyFormat;
import org.jresearch.gavka.domain.MessageFilter;
import org.jresearch.gavka.domain.MessageFormat;
import org.jresearch.gavka.rest.api.GavkaMessageService;
import org.jresearch.gavka.rest.api.MessageParameters;
import org.jresearch.gavka.rest.api.MessagePortion;
import org.jresearch.gavka.rest.api.PagingParameters;
import org.jresearch.gavka.rest.api.RequestMessagesParameters;
import org.jresearch.gavka.srv.MessageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/messages"})
public class GavkaController
implements GavkaMessageService {
    @Autowired
    private MessageService messageService;

    @PostMapping(value={"/get"})
    public MessagePortion get(@RequestBody RequestMessagesParameters parameters) {
        MessageParameters messageParameters = parameters.getMessageParameters();
        PagingParameters pagingParameters = parameters.getPagingParameters();
        return this.messageService.getMessages(pagingParameters, GavkaController.toMessageFilter((MessageParameters)messageParameters));
    }

    private static MessageFilter toMessageFilter(MessageParameters parameters) {
        MessageFilter result = new MessageFilter();
        GwtLocalDateTimeModel gwtFrom = parameters.getFrom();
        result.setFrom(gwtFrom == null ? null : ServerDates.localDateTime((GwtLocalDateModel)gwtFrom.getDate(), (GwtLocalTimeModel)gwtFrom.getTime()));
        result.setKey(parameters.getKey());
        result.setKeyFormat(parameters.getKeyFormat());
        result.setMessageFormat(parameters.getMessageFormat());
        result.setTopic(parameters.getTopic());
        return result;
    }

    @GetMapping(value={"/topics"})
    public List<String> topics() {
        return this.messageService.getMessageTopics();
    }

    @GetMapping(value={"/keyFormats"})
    public List<KeyFormat> keyFormats() {
        return ImmutableList.copyOf((Object[])KeyFormat.values());
    }

    @GetMapping(value={"/messageFormats"})
    public List<MessageFormat> messageFormats() {
        return ImmutableList.copyOf((Object[])MessageFormat.values());
    }
}

