/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.gavka.web;

import java.time.LocalDateTime;
import java.util.Optional;
import org.jresearch.gavka.domain.KeyFormat;
import org.jresearch.gavka.domain.MessageFilter;
import org.jresearch.gavka.domain.MessageFormat;
import org.jresearch.gavka.srv.MessageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ContentDisposition;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"/messages"})
public class ExportController {
    @Autowired
    private MessageService messageService;

    @PostMapping(value={"/export"})
    public ResponseEntity<StreamingResponseBody> export(@RequestParam Optional<String> topic, @RequestParam Optional<String> key, @RequestParam @DateTimeFormat(pattern="yyyy-MM-dd HH:mm") Optional<LocalDateTime> from, @RequestParam Optional<KeyFormat> keyFormat, @RequestParam Optional<MessageFormat> messageFormat) {
        MessageFilter filter = ExportController.toMessageFilter(topic, key, from, keyFormat, messageFormat);
        ContentDisposition disposition = ContentDisposition.builder((String)"attachment").filename("gavka.export").build();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.APPLICATION_OCTET_STREAM).header("Content-Disposition", new String[]{disposition.toString()})).body(out -> this.messageService.exportMessages(out, filter));
    }

    private static MessageFilter toMessageFilter(Optional<String> topic, Optional<String> key, Optional<LocalDateTime> from, Optional<KeyFormat> keyFormat, Optional<MessageFormat> messageFormat) {
        MessageFilter result = new MessageFilter();
        from.ifPresent(arg_0 -> ((MessageFilter)result).setFrom(arg_0));
        key.ifPresent(arg_0 -> ((MessageFilter)result).setKey(arg_0));
        keyFormat.ifPresent(arg_0 -> ((MessageFilter)result).setKeyFormat(arg_0));
        messageFormat.ifPresent(arg_0 -> ((MessageFilter)result).setMessageFormat(arg_0));
        topic.ifPresent(arg_0 -> ((MessageFilter)result).setTopic(arg_0));
        return result;
    }
}

