package org.jresearch.gavka.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Connection}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableConnection.Builder()}.
 */
@Generated(from = "Connection", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableConnection implements Connection {
  private final String id;
  private final String label;
  private final String icon;
  private final String color;
  private final ImmutableList<String> bootstrapServers;
  private final @Nullable String schemaRegistryUrl;
  private final ImmutableMap<String, String> properties;

  private ImmutableConnection(ImmutableConnection.Builder builder) {
    this.bootstrapServers = builder.bootstrapServers.build();
    this.schemaRegistryUrl = builder.schemaRegistryUrl;
    this.properties = builder.properties.build();
    if (builder.id != null) {
      initShim.id(builder.id);
    }
    if (builder.label != null) {
      initShim.label(builder.label);
    }
    if (builder.icon != null) {
      initShim.icon(builder.icon);
    }
    if (builder.color != null) {
      initShim.color(builder.color);
    }
    this.id = initShim.getId();
    this.label = initShim.getLabel();
    this.icon = initShim.getIcon();
    this.color = initShim.getColor();
    this.initShim = null;
  }

  private ImmutableConnection(
      String id,
      String label,
      String icon,
      String color,
      ImmutableList<String> bootstrapServers,
      @Nullable String schemaRegistryUrl,
      ImmutableMap<String, String> properties) {
    this.id = id;
    this.label = label;
    this.icon = icon;
    this.color = color;
    this.bootstrapServers = bootstrapServers;
    this.schemaRegistryUrl = schemaRegistryUrl;
    this.properties = properties;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "Connection", generator = "Immutables")
  private final class InitShim {
    private byte idBuildStage = STAGE_UNINITIALIZED;
    private String id;

    String getId() {
      if (idBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (idBuildStage == STAGE_UNINITIALIZED) {
        idBuildStage = STAGE_INITIALIZING;
        this.id = Objects.requireNonNull(getIdInitialize(), "id");
        idBuildStage = STAGE_INITIALIZED;
      }
      return this.id;
    }

    void id(String id) {
      this.id = id;
      idBuildStage = STAGE_INITIALIZED;
    }

    private byte labelBuildStage = STAGE_UNINITIALIZED;
    private String label;

    String getLabel() {
      if (labelBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (labelBuildStage == STAGE_UNINITIALIZED) {
        labelBuildStage = STAGE_INITIALIZING;
        this.label = Objects.requireNonNull(getLabelInitialize(), "label");
        labelBuildStage = STAGE_INITIALIZED;
      }
      return this.label;
    }

    void label(String label) {
      this.label = label;
      labelBuildStage = STAGE_INITIALIZED;
    }

    private byte iconBuildStage = STAGE_UNINITIALIZED;
    private String icon;

    String getIcon() {
      if (iconBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (iconBuildStage == STAGE_UNINITIALIZED) {
        iconBuildStage = STAGE_INITIALIZING;
        this.icon = Objects.requireNonNull(getIconInitialize(), "icon");
        iconBuildStage = STAGE_INITIALIZED;
      }
      return this.icon;
    }

    void icon(String icon) {
      this.icon = icon;
      iconBuildStage = STAGE_INITIALIZED;
    }

    private byte colorBuildStage = STAGE_UNINITIALIZED;
    private String color;

    String getColor() {
      if (colorBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (colorBuildStage == STAGE_UNINITIALIZED) {
        colorBuildStage = STAGE_INITIALIZING;
        this.color = Objects.requireNonNull(getColorInitialize(), "color");
        colorBuildStage = STAGE_INITIALIZED;
      }
      return this.color;
    }

    void color(String color) {
      this.color = color;
      colorBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (idBuildStage == STAGE_INITIALIZING) attributes.add("id");
      if (labelBuildStage == STAGE_INITIALIZING) attributes.add("label");
      if (iconBuildStage == STAGE_INITIALIZING) attributes.add("icon");
      if (colorBuildStage == STAGE_INITIALIZING) attributes.add("color");
      return "Cannot build Connection, attribute initializers form cycle " + attributes;
    }
  }

  private String getIdInitialize() {
    return Connection.super.getId();
  }

  private String getLabelInitialize() {
    return Connection.super.getLabel();
  }

  private String getIconInitialize() {
    return Connection.super.getIcon();
  }

  private String getColorInitialize() {
    return Connection.super.getColor();
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getId()
        : this.id;
  }

  /**
   * @return The value of the {@code label} attribute
   */
  @JsonProperty("label")
  @Override
  public String getLabel() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getLabel()
        : this.label;
  }

  /**
   * @return The value of the {@code icon} attribute
   */
  @JsonProperty("icon")
  @Override
  public String getIcon() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getIcon()
        : this.icon;
  }

  /**
   * @return The value of the {@code color} attribute
   */
  @JsonProperty("color")
  @Override
  public String getColor() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getColor()
        : this.color;
  }

  /**
   * @return The value of the {@code bootstrapServers} attribute
   */
  @JsonProperty("bootstrapServers")
  @Override
  public ImmutableList<String> getBootstrapServers() {
    return bootstrapServers;
  }

  /**
   * @return The value of the {@code schemaRegistryUrl} attribute
   */
  @JsonProperty("schemaRegistryUrl")
  @Override
  public Optional<String> getSchemaRegistryUrl() {
    return Optional.ofNullable(schemaRegistryUrl);
  }

  /**
   * @return The value of the {@code properties} attribute
   */
  @JsonProperty("properties")
  @Override
  public ImmutableMap<String, String> getProperties() {
    return properties;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Connection#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConnection withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableConnection(
        newValue,
        this.label,
        this.icon,
        this.color,
        this.bootstrapServers,
        this.schemaRegistryUrl,
        this.properties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Connection#getLabel() label} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for label
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConnection withLabel(String value) {
    String newValue = Objects.requireNonNull(value, "label");
    if (this.label.equals(newValue)) return this;
    return new ImmutableConnection(
        this.id,
        newValue,
        this.icon,
        this.color,
        this.bootstrapServers,
        this.schemaRegistryUrl,
        this.properties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Connection#getIcon() icon} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for icon
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConnection withIcon(String value) {
    String newValue = Objects.requireNonNull(value, "icon");
    if (this.icon.equals(newValue)) return this;
    return new ImmutableConnection(
        this.id,
        this.label,
        newValue,
        this.color,
        this.bootstrapServers,
        this.schemaRegistryUrl,
        this.properties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Connection#getColor() color} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for color
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConnection withColor(String value) {
    String newValue = Objects.requireNonNull(value, "color");
    if (this.color.equals(newValue)) return this;
    return new ImmutableConnection(
        this.id,
        this.label,
        this.icon,
        newValue,
        this.bootstrapServers,
        this.schemaRegistryUrl,
        this.properties);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Connection#getBootstrapServers() bootstrapServers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableConnection withBootstrapServers(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableConnection(this.id, this.label, this.icon, this.color, newValue, this.schemaRegistryUrl, this.properties);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Connection#getBootstrapServers() bootstrapServers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of bootstrapServers elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableConnection withBootstrapServers(Iterable<String> elements) {
    if (this.bootstrapServers == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableConnection(this.id, this.label, this.icon, this.color, newValue, this.schemaRegistryUrl, this.properties);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Connection#getSchemaRegistryUrl() schemaRegistryUrl} attribute.
   * @param value The value for schemaRegistryUrl, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ImmutableConnection withSchemaRegistryUrl(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.schemaRegistryUrl, newValue)) return this;
    return new ImmutableConnection(this.id, this.label, this.icon, this.color, this.bootstrapServers, newValue, this.properties);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Connection#getSchemaRegistryUrl() schemaRegistryUrl} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for schemaRegistryUrl
   * @return A modified copy of {@code this} object
   */
  public final ImmutableConnection withSchemaRegistryUrl(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.schemaRegistryUrl, value)) return this;
    return new ImmutableConnection(this.id, this.label, this.icon, this.color, this.bootstrapServers, value, this.properties);
  }

  /**
   * Copy the current immutable object by replacing the {@link Connection#getProperties() properties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the properties map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableConnection withProperties(Map<String, ? extends String> entries) {
    if (this.properties == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableConnection(
        this.id,
        this.label,
        this.icon,
        this.color,
        this.bootstrapServers,
        this.schemaRegistryUrl,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableConnection} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableConnection
        && equalTo((ImmutableConnection) another);
  }

  private boolean equalTo(ImmutableConnection another) {
    return id.equals(another.id)
        && label.equals(another.label)
        && icon.equals(another.icon)
        && color.equals(another.color)
        && bootstrapServers.equals(another.bootstrapServers)
        && Objects.equals(schemaRegistryUrl, another.schemaRegistryUrl)
        && properties.equals(another.properties);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code label}, {@code icon}, {@code color}, {@code bootstrapServers}, {@code schemaRegistryUrl}, {@code properties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + label.hashCode();
    h += (h << 5) + icon.hashCode();
    h += (h << 5) + color.hashCode();
    h += (h << 5) + bootstrapServers.hashCode();
    h += (h << 5) + Objects.hashCode(schemaRegistryUrl);
    h += (h << 5) + properties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Connection} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Connection")
        .omitNullValues()
        .add("id", id)
        .add("label", label)
        .add("icon", icon)
        .add("color", color)
        .add("bootstrapServers", bootstrapServers)
        .add("schemaRegistryUrl", schemaRegistryUrl)
        .add("properties", properties)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link Connection} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Connection instance
   */
  public static ImmutableConnection copyOf(Connection instance) {
    if (instance instanceof ImmutableConnection) {
      return (ImmutableConnection) instance;
    }
    return new ImmutableConnection.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableConnection ImmutableConnection}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Connection", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String id;
    private @Nullable String label;
    private @Nullable String icon;
    private @Nullable String color;
    private ImmutableList.Builder<String> bootstrapServers = ImmutableList.builder();
    private @Nullable String schemaRegistryUrl;
    private ImmutableMap.Builder<String, String> properties = ImmutableMap.builder();

    /**
     * Creates a builder for {@link ImmutableConnection ImmutableConnection} instances.
     * <pre>
     * new ImmutableConnection.Builder()
     *    .id(String) // optional {@link Connection#getId() id}
     *    .label(String) // optional {@link Connection#getLabel() label}
     *    .icon(String) // optional {@link Connection#getIcon() icon}
     *    .color(String) // optional {@link Connection#getColor() color}
     *    .addBootstrapServers|addAllBootstrapServers(String) // {@link Connection#getBootstrapServers() bootstrapServers} elements
     *    .schemaRegistryUrl(String) // optional {@link Connection#getSchemaRegistryUrl() schemaRegistryUrl}
     *    .putProperties|putAllProperties(String =&gt; String) // {@link Connection#getProperties() properties} mappings
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableConnection} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ModifiableConnection instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      label(instance.getLabel());
      icon(instance.getIcon());
      color(instance.getColor());
      addAllBootstrapServers(instance.getBootstrapServers());
      Optional<String> schemaRegistryUrlOptional = instance.getSchemaRegistryUrl();
      if (schemaRegistryUrlOptional.isPresent()) {
        schemaRegistryUrl(schemaRegistryUrlOptional);
      }
      putAllProperties(instance.getProperties());
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code Connection} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Connection instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableConnection) {
        return from((ModifiableConnection) instance);
      }
      id(instance.getId());
      label(instance.getLabel());
      icon(instance.getIcon());
      color(instance.getColor());
      addAllBootstrapServers(instance.getBootstrapServers());
      Optional<String> schemaRegistryUrlOptional = instance.getSchemaRegistryUrl();
      if (schemaRegistryUrlOptional.isPresent()) {
        schemaRegistryUrl(schemaRegistryUrlOptional);
      }
      putAllProperties(instance.getProperties());
      return this;
    }

    /**
     * Initializes the value for the {@link Connection#getId() id} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Connection#getId() id}.</em>
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      return this;
    }

    /**
     * Initializes the value for the {@link Connection#getLabel() label} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Connection#getLabel() label}.</em>
     * @param label The value for label 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("label")
    public final Builder label(String label) {
      this.label = Objects.requireNonNull(label, "label");
      return this;
    }

    /**
     * Initializes the value for the {@link Connection#getIcon() icon} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Connection#getIcon() icon}.</em>
     * @param icon The value for icon 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("icon")
    public final Builder icon(String icon) {
      this.icon = Objects.requireNonNull(icon, "icon");
      return this;
    }

    /**
     * Initializes the value for the {@link Connection#getColor() color} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Connection#getColor() color}.</em>
     * @param color The value for color 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("color")
    public final Builder color(String color) {
      this.color = Objects.requireNonNull(color, "color");
      return this;
    }

    /**
     * Adds one element to {@link Connection#getBootstrapServers() bootstrapServers} list.
     * @param element A bootstrapServers element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addBootstrapServers(String element) {
      this.bootstrapServers.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Connection#getBootstrapServers() bootstrapServers} list.
     * @param elements An array of bootstrapServers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addBootstrapServers(String... elements) {
      this.bootstrapServers.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Connection#getBootstrapServers() bootstrapServers} list.
     * @param elements An iterable of bootstrapServers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("bootstrapServers")
    public final Builder bootstrapServers(Iterable<String> elements) {
      this.bootstrapServers = ImmutableList.builder();
      return addAllBootstrapServers(elements);
    }

    /**
     * Adds elements to {@link Connection#getBootstrapServers() bootstrapServers} list.
     * @param elements An iterable of bootstrapServers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllBootstrapServers(Iterable<String> elements) {
      this.bootstrapServers.addAll(elements);
      return this;
    }

    /**
     * Initializes the optional value {@link Connection#getSchemaRegistryUrl() schemaRegistryUrl} to schemaRegistryUrl.
     * @param schemaRegistryUrl The value for schemaRegistryUrl, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder schemaRegistryUrl(@Nullable String schemaRegistryUrl) {
      this.schemaRegistryUrl = schemaRegistryUrl;
      return this;
    }

    /**
     * Initializes the optional value {@link Connection#getSchemaRegistryUrl() schemaRegistryUrl} to schemaRegistryUrl.
     * @param schemaRegistryUrl The value for schemaRegistryUrl
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("schemaRegistryUrl")
    public final Builder schemaRegistryUrl(Optional<String> schemaRegistryUrl) {
      this.schemaRegistryUrl = schemaRegistryUrl.orElse(null);
      return this;
    }

    /**
     * Put one entry to the {@link Connection#getProperties() properties} map.
     * @param key The key in the properties map
     * @param value The associated value in the properties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putProperties(String key, String value) {
      this.properties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Connection#getProperties() properties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putProperties(Map.Entry<String, ? extends String> entry) {
      this.properties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Connection#getProperties() properties} map. Nulls are not permitted
     * @param entries The entries that will be added to the properties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("properties")
    public final Builder properties(Map<String, ? extends String> entries) {
      this.properties = ImmutableMap.builder();
      return putAllProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Connection#getProperties() properties} map. Nulls are not permitted
     * @param entries The entries that will be added to the properties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllProperties(Map<String, ? extends String> entries) {
      this.properties.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableConnection ImmutableConnection}.
     * @return An immutable instance of Connection
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableConnection build() {
      return new ImmutableConnection(this);
    }
  }
}
