package org.jresearch.gavka.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ConnectionCheck}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableConnectionCheck.Builder()}.
 */
@Generated(from = "ConnectionCheck", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableConnectionCheck implements ConnectionCheck {
  private final ConnectionParameters subject;
  private final CheckStatus status;
  private final @Nullable String reason;
  private final ListCheck<String> bootstrapServerCheck;
  private final SimpleCheck<String> schemaRegistryUrlCheck;
  private final ListCheck<String> propertiesCheck;

  private ImmutableConnectionCheck(
      ConnectionParameters subject,
      CheckStatus status,
      @Nullable String reason,
      ListCheck<String> bootstrapServerCheck,
      SimpleCheck<String> schemaRegistryUrlCheck,
      ListCheck<String> propertiesCheck) {
    this.subject = subject;
    this.status = status;
    this.reason = reason;
    this.bootstrapServerCheck = bootstrapServerCheck;
    this.schemaRegistryUrlCheck = schemaRegistryUrlCheck;
    this.propertiesCheck = propertiesCheck;
  }

  /**
   *Object to check 
   */
  @JsonProperty("subject")
  @Override
  public ConnectionParameters subject() {
    return subject;
  }

  /**
   * @return The value of the {@code status} attribute
   */
  @JsonProperty("status")
  @Override
  public CheckStatus status() {
    return status;
  }

  /**
   * @return The value of the {@code reason} attribute
   */
  @JsonProperty("reason")
  @Override
  public Optional<String> reason() {
    return Optional.ofNullable(reason);
  }

  /**
   * @return The value of the {@code bootstrapServerCheck} attribute
   */
  @JsonProperty("bootstrapServerCheck")
  @Override
  public ListCheck<String> bootstrapServerCheck() {
    return bootstrapServerCheck;
  }

  /**
   * @return The value of the {@code schemaRegistryUrlCheck} attribute
   */
  @JsonProperty("schemaRegistryUrlCheck")
  @Override
  public SimpleCheck<String> schemaRegistryUrlCheck() {
    return schemaRegistryUrlCheck;
  }

  /**
   * @return The value of the {@code propertiesCheck} attribute
   */
  @JsonProperty("propertiesCheck")
  @Override
  public ListCheck<String> propertiesCheck() {
    return propertiesCheck;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConnectionCheck#subject() subject} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for subject
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConnectionCheck withSubject(ConnectionParameters value) {
    if (this.subject == value) return this;
    ConnectionParameters newValue = Objects.requireNonNull(value, "subject");
    return new ImmutableConnectionCheck(
        newValue,
        this.status,
        this.reason,
        this.bootstrapServerCheck,
        this.schemaRegistryUrlCheck,
        this.propertiesCheck);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConnectionCheck#status() status} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for status
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConnectionCheck withStatus(CheckStatus value) {
    if (this.status == value) return this;
    CheckStatus newValue = Objects.requireNonNull(value, "status");
    if (this.status.equals(newValue)) return this;
    return new ImmutableConnectionCheck(
        this.subject,
        newValue,
        this.reason,
        this.bootstrapServerCheck,
        this.schemaRegistryUrlCheck,
        this.propertiesCheck);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ConnectionCheck#reason() reason} attribute.
   * @param value The value for reason, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ImmutableConnectionCheck withReason(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.reason, newValue)) return this;
    return new ImmutableConnectionCheck(
        this.subject,
        this.status,
        newValue,
        this.bootstrapServerCheck,
        this.schemaRegistryUrlCheck,
        this.propertiesCheck);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ConnectionCheck#reason() reason} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for reason
   * @return A modified copy of {@code this} object
   */
  public final ImmutableConnectionCheck withReason(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.reason, value)) return this;
    return new ImmutableConnectionCheck(
        this.subject,
        this.status,
        value,
        this.bootstrapServerCheck,
        this.schemaRegistryUrlCheck,
        this.propertiesCheck);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConnectionCheck#bootstrapServerCheck() bootstrapServerCheck} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bootstrapServerCheck
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConnectionCheck withBootstrapServerCheck(ListCheck<String> value) {
    if (this.bootstrapServerCheck == value) return this;
    ListCheck<String> newValue = Objects.requireNonNull(value, "bootstrapServerCheck");
    return new ImmutableConnectionCheck(
        this.subject,
        this.status,
        this.reason,
        newValue,
        this.schemaRegistryUrlCheck,
        this.propertiesCheck);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConnectionCheck#schemaRegistryUrlCheck() schemaRegistryUrlCheck} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for schemaRegistryUrlCheck
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConnectionCheck withSchemaRegistryUrlCheck(SimpleCheck<String> value) {
    if (this.schemaRegistryUrlCheck == value) return this;
    SimpleCheck<String> newValue = Objects.requireNonNull(value, "schemaRegistryUrlCheck");
    return new ImmutableConnectionCheck(
        this.subject,
        this.status,
        this.reason,
        this.bootstrapServerCheck,
        newValue,
        this.propertiesCheck);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConnectionCheck#propertiesCheck() propertiesCheck} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for propertiesCheck
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConnectionCheck withPropertiesCheck(ListCheck<String> value) {
    if (this.propertiesCheck == value) return this;
    ListCheck<String> newValue = Objects.requireNonNull(value, "propertiesCheck");
    return new ImmutableConnectionCheck(
        this.subject,
        this.status,
        this.reason,
        this.bootstrapServerCheck,
        this.schemaRegistryUrlCheck,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableConnectionCheck} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableConnectionCheck
        && equalTo((ImmutableConnectionCheck) another);
  }

  private boolean equalTo(ImmutableConnectionCheck another) {
    return subject.equals(another.subject)
        && status.equals(another.status)
        && Objects.equals(reason, another.reason)
        && bootstrapServerCheck.equals(another.bootstrapServerCheck)
        && schemaRegistryUrlCheck.equals(another.schemaRegistryUrlCheck)
        && propertiesCheck.equals(another.propertiesCheck);
  }

  /**
   * Computes a hash code from attributes: {@code subject}, {@code status}, {@code reason}, {@code bootstrapServerCheck}, {@code schemaRegistryUrlCheck}, {@code propertiesCheck}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + subject.hashCode();
    h += (h << 5) + status.hashCode();
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + bootstrapServerCheck.hashCode();
    h += (h << 5) + schemaRegistryUrlCheck.hashCode();
    h += (h << 5) + propertiesCheck.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ConnectionCheck} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ConnectionCheck")
        .omitNullValues()
        .add("subject", subject)
        .add("status", status)
        .add("reason", reason)
        .add("bootstrapServerCheck", bootstrapServerCheck)
        .add("schemaRegistryUrlCheck", schemaRegistryUrlCheck)
        .add("propertiesCheck", propertiesCheck)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ConnectionCheck} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ConnectionCheck instance
   */
  public static ImmutableConnectionCheck copyOf(ConnectionCheck instance) {
    if (instance instanceof ImmutableConnectionCheck) {
      return (ImmutableConnectionCheck) instance;
    }
    return new ImmutableConnectionCheck.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableConnectionCheck ImmutableConnectionCheck}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ConnectionCheck", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SUBJECT = 0x1L;
    private static final long INIT_BIT_STATUS = 0x2L;
    private static final long INIT_BIT_BOOTSTRAP_SERVER_CHECK = 0x4L;
    private static final long INIT_BIT_SCHEMA_REGISTRY_URL_CHECK = 0x8L;
    private static final long INIT_BIT_PROPERTIES_CHECK = 0x10L;
    private long initBits = 0x1fL;

    private @Nullable ConnectionParameters subject;
    private @Nullable CheckStatus status;
    private @Nullable String reason;
    private @Nullable ListCheck<String> bootstrapServerCheck;
    private @Nullable SimpleCheck<String> schemaRegistryUrlCheck;
    private @Nullable ListCheck<String> propertiesCheck;

    /**
     * Creates a builder for {@link ImmutableConnectionCheck ImmutableConnectionCheck} instances.
     * <pre>
     * new ImmutableConnectionCheck.Builder()
     *    .subject(org.jresearch.gavka.domain.ConnectionParameters) // required {@link ConnectionCheck#subject() subject}
     *    .status(org.jresearch.gavka.domain.CheckStatus) // required {@link ConnectionCheck#status() status}
     *    .reason(String) // optional {@link ConnectionCheck#reason() reason}
     *    .bootstrapServerCheck(org.jresearch.gavka.domain.ListCheck&amp;lt;String&amp;gt;) // required {@link ConnectionCheck#bootstrapServerCheck() bootstrapServerCheck}
     *    .schemaRegistryUrlCheck(org.jresearch.gavka.domain.SimpleCheck&amp;lt;String&amp;gt;) // required {@link ConnectionCheck#schemaRegistryUrlCheck() schemaRegistryUrlCheck}
     *    .propertiesCheck(org.jresearch.gavka.domain.ListCheck&amp;lt;String&amp;gt;) // required {@link ConnectionCheck#propertiesCheck() propertiesCheck}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ConnectionCheck} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ConnectionCheck instance) {
      Objects.requireNonNull(instance, "instance");
      subject(instance.subject());
      status(instance.status());
      Optional<String> reasonOptional = instance.reason();
      if (reasonOptional.isPresent()) {
        reason(reasonOptional);
      }
      bootstrapServerCheck(instance.bootstrapServerCheck());
      schemaRegistryUrlCheck(instance.schemaRegistryUrlCheck());
      propertiesCheck(instance.propertiesCheck());
      return this;
    }

    /**
     * Initializes the value for the {@link ConnectionCheck#subject() subject} attribute.
     * @param subject The value for subject 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("subject")
    public final Builder subject(ConnectionParameters subject) {
      this.subject = Objects.requireNonNull(subject, "subject");
      initBits &= ~INIT_BIT_SUBJECT;
      return this;
    }

    /**
     * Initializes the value for the {@link ConnectionCheck#status() status} attribute.
     * @param status The value for status 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("status")
    public final Builder status(CheckStatus status) {
      this.status = Objects.requireNonNull(status, "status");
      initBits &= ~INIT_BIT_STATUS;
      return this;
    }

    /**
     * Initializes the optional value {@link ConnectionCheck#reason() reason} to reason.
     * @param reason The value for reason, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder reason(@Nullable String reason) {
      this.reason = reason;
      return this;
    }

    /**
     * Initializes the optional value {@link ConnectionCheck#reason() reason} to reason.
     * @param reason The value for reason
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("reason")
    public final Builder reason(Optional<String> reason) {
      this.reason = reason.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link ConnectionCheck#bootstrapServerCheck() bootstrapServerCheck} attribute.
     * @param bootstrapServerCheck The value for bootstrapServerCheck 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("bootstrapServerCheck")
    public final Builder bootstrapServerCheck(ListCheck<String> bootstrapServerCheck) {
      this.bootstrapServerCheck = Objects.requireNonNull(bootstrapServerCheck, "bootstrapServerCheck");
      initBits &= ~INIT_BIT_BOOTSTRAP_SERVER_CHECK;
      return this;
    }

    /**
     * Initializes the value for the {@link ConnectionCheck#schemaRegistryUrlCheck() schemaRegistryUrlCheck} attribute.
     * @param schemaRegistryUrlCheck The value for schemaRegistryUrlCheck 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("schemaRegistryUrlCheck")
    public final Builder schemaRegistryUrlCheck(SimpleCheck<String> schemaRegistryUrlCheck) {
      this.schemaRegistryUrlCheck = Objects.requireNonNull(schemaRegistryUrlCheck, "schemaRegistryUrlCheck");
      initBits &= ~INIT_BIT_SCHEMA_REGISTRY_URL_CHECK;
      return this;
    }

    /**
     * Initializes the value for the {@link ConnectionCheck#propertiesCheck() propertiesCheck} attribute.
     * @param propertiesCheck The value for propertiesCheck 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("propertiesCheck")
    public final Builder propertiesCheck(ListCheck<String> propertiesCheck) {
      this.propertiesCheck = Objects.requireNonNull(propertiesCheck, "propertiesCheck");
      initBits &= ~INIT_BIT_PROPERTIES_CHECK;
      return this;
    }

    /**
     * Builds a new {@link ImmutableConnectionCheck ImmutableConnectionCheck}.
     * @return An immutable instance of ConnectionCheck
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableConnectionCheck build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableConnectionCheck(subject, status, reason, bootstrapServerCheck, schemaRegistryUrlCheck, propertiesCheck);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SUBJECT) != 0) attributes.add("subject");
      if ((initBits & INIT_BIT_STATUS) != 0) attributes.add("status");
      if ((initBits & INIT_BIT_BOOTSTRAP_SERVER_CHECK) != 0) attributes.add("bootstrapServerCheck");
      if ((initBits & INIT_BIT_SCHEMA_REGISTRY_URL_CHECK) != 0) attributes.add("schemaRegistryUrlCheck");
      if ((initBits & INIT_BIT_PROPERTIES_CHECK) != 0) attributes.add("propertiesCheck");
      return "Cannot build ConnectionCheck, some of required attributes are not set " + attributes;
    }
  }
}
