package org.jresearch.gavka.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ConnectionParameters}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableConnectionParameters.Builder()}.
 */
@Generated(from = "ConnectionParameters", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableConnectionParameters implements ConnectionParameters {
  private final ImmutableList<String> bootstrapServers;
  private final @Nullable String schemaRegistryUrl;
  private final ImmutableMap<String, String> properties;

  private ImmutableConnectionParameters(
      ImmutableList<String> bootstrapServers,
      @Nullable String schemaRegistryUrl,
      ImmutableMap<String, String> properties) {
    this.bootstrapServers = bootstrapServers;
    this.schemaRegistryUrl = schemaRegistryUrl;
    this.properties = properties;
  }

  /**
   * @return The value of the {@code bootstrapServers} attribute
   */
  @JsonProperty("bootstrapServers")
  @Override
  public ImmutableList<String> getBootstrapServers() {
    return bootstrapServers;
  }

  /**
   * @return The value of the {@code schemaRegistryUrl} attribute
   */
  @JsonProperty("schemaRegistryUrl")
  @Override
  public Optional<String> getSchemaRegistryUrl() {
    return Optional.ofNullable(schemaRegistryUrl);
  }

  /**
   * @return The value of the {@code properties} attribute
   */
  @JsonProperty("properties")
  @Override
  public ImmutableMap<String, String> getProperties() {
    return properties;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ConnectionParameters#getBootstrapServers() bootstrapServers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableConnectionParameters withBootstrapServers(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableConnectionParameters(newValue, this.schemaRegistryUrl, this.properties);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ConnectionParameters#getBootstrapServers() bootstrapServers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of bootstrapServers elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableConnectionParameters withBootstrapServers(Iterable<String> elements) {
    if (this.bootstrapServers == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableConnectionParameters(newValue, this.schemaRegistryUrl, this.properties);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ConnectionParameters#getSchemaRegistryUrl() schemaRegistryUrl} attribute.
   * @param value The value for schemaRegistryUrl, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ImmutableConnectionParameters withSchemaRegistryUrl(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.schemaRegistryUrl, newValue)) return this;
    return new ImmutableConnectionParameters(this.bootstrapServers, newValue, this.properties);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ConnectionParameters#getSchemaRegistryUrl() schemaRegistryUrl} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for schemaRegistryUrl
   * @return A modified copy of {@code this} object
   */
  public final ImmutableConnectionParameters withSchemaRegistryUrl(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.schemaRegistryUrl, value)) return this;
    return new ImmutableConnectionParameters(this.bootstrapServers, value, this.properties);
  }

  /**
   * Copy the current immutable object by replacing the {@link ConnectionParameters#getProperties() properties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the properties map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableConnectionParameters withProperties(Map<String, ? extends String> entries) {
    if (this.properties == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableConnectionParameters(this.bootstrapServers, this.schemaRegistryUrl, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableConnectionParameters} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableConnectionParameters
        && equalTo((ImmutableConnectionParameters) another);
  }

  private boolean equalTo(ImmutableConnectionParameters another) {
    return bootstrapServers.equals(another.bootstrapServers)
        && Objects.equals(schemaRegistryUrl, another.schemaRegistryUrl)
        && properties.equals(another.properties);
  }

  /**
   * Computes a hash code from attributes: {@code bootstrapServers}, {@code schemaRegistryUrl}, {@code properties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + bootstrapServers.hashCode();
    h += (h << 5) + Objects.hashCode(schemaRegistryUrl);
    h += (h << 5) + properties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ConnectionParameters} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ConnectionParameters")
        .omitNullValues()
        .add("bootstrapServers", bootstrapServers)
        .add("schemaRegistryUrl", schemaRegistryUrl)
        .add("properties", properties)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ConnectionParameters} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ConnectionParameters instance
   */
  public static ImmutableConnectionParameters copyOf(ConnectionParameters instance) {
    if (instance instanceof ImmutableConnectionParameters) {
      return (ImmutableConnectionParameters) instance;
    }
    return new ImmutableConnectionParameters.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableConnectionParameters ImmutableConnectionParameters}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ConnectionParameters", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<String> bootstrapServers = ImmutableList.builder();
    private @Nullable String schemaRegistryUrl;
    private ImmutableMap.Builder<String, String> properties = ImmutableMap.builder();

    /**
     * Creates a builder for {@link ImmutableConnectionParameters ImmutableConnectionParameters} instances.
     * <pre>
     * new ImmutableConnectionParameters.Builder()
     *    .addBootstrapServers|addAllBootstrapServers(String) // {@link ConnectionParameters#getBootstrapServers() bootstrapServers} elements
     *    .schemaRegistryUrl(String) // optional {@link ConnectionParameters#getSchemaRegistryUrl() schemaRegistryUrl}
     *    .putProperties|putAllProperties(String =&gt; String) // {@link ConnectionParameters#getProperties() properties} mappings
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ConnectionParameters} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ConnectionParameters instance) {
      Objects.requireNonNull(instance, "instance");
      addAllBootstrapServers(instance.getBootstrapServers());
      Optional<String> schemaRegistryUrlOptional = instance.getSchemaRegistryUrl();
      if (schemaRegistryUrlOptional.isPresent()) {
        schemaRegistryUrl(schemaRegistryUrlOptional);
      }
      putAllProperties(instance.getProperties());
      return this;
    }

    /**
     * Adds one element to {@link ConnectionParameters#getBootstrapServers() bootstrapServers} list.
     * @param element A bootstrapServers element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addBootstrapServers(String element) {
      this.bootstrapServers.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ConnectionParameters#getBootstrapServers() bootstrapServers} list.
     * @param elements An array of bootstrapServers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addBootstrapServers(String... elements) {
      this.bootstrapServers.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ConnectionParameters#getBootstrapServers() bootstrapServers} list.
     * @param elements An iterable of bootstrapServers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("bootstrapServers")
    public final Builder bootstrapServers(Iterable<String> elements) {
      this.bootstrapServers = ImmutableList.builder();
      return addAllBootstrapServers(elements);
    }

    /**
     * Adds elements to {@link ConnectionParameters#getBootstrapServers() bootstrapServers} list.
     * @param elements An iterable of bootstrapServers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllBootstrapServers(Iterable<String> elements) {
      this.bootstrapServers.addAll(elements);
      return this;
    }

    /**
     * Initializes the optional value {@link ConnectionParameters#getSchemaRegistryUrl() schemaRegistryUrl} to schemaRegistryUrl.
     * @param schemaRegistryUrl The value for schemaRegistryUrl, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder schemaRegistryUrl(@Nullable String schemaRegistryUrl) {
      this.schemaRegistryUrl = schemaRegistryUrl;
      return this;
    }

    /**
     * Initializes the optional value {@link ConnectionParameters#getSchemaRegistryUrl() schemaRegistryUrl} to schemaRegistryUrl.
     * @param schemaRegistryUrl The value for schemaRegistryUrl
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("schemaRegistryUrl")
    public final Builder schemaRegistryUrl(Optional<String> schemaRegistryUrl) {
      this.schemaRegistryUrl = schemaRegistryUrl.orElse(null);
      return this;
    }

    /**
     * Put one entry to the {@link ConnectionParameters#getProperties() properties} map.
     * @param key The key in the properties map
     * @param value The associated value in the properties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putProperties(String key, String value) {
      this.properties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ConnectionParameters#getProperties() properties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putProperties(Map.Entry<String, ? extends String> entry) {
      this.properties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ConnectionParameters#getProperties() properties} map. Nulls are not permitted
     * @param entries The entries that will be added to the properties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("properties")
    public final Builder properties(Map<String, ? extends String> entries) {
      this.properties = ImmutableMap.builder();
      return putAllProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ConnectionParameters#getProperties() properties} map. Nulls are not permitted
     * @param entries The entries that will be added to the properties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllProperties(Map<String, ? extends String> entries) {
      this.properties.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableConnectionParameters ImmutableConnectionParameters}.
     * @return An immutable instance of ConnectionParameters
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableConnectionParameters build() {
      return new ImmutableConnectionParameters(bootstrapServers.build(), schemaRegistryUrl, properties.build());
    }
  }
}
