package org.jresearch.gavka.domain;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ConnectionList}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableConnectionList.builder()}.
 */
@Generated(from = "ConnectionList", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableConnectionList implements ConnectionList {
  private final LocalDateTime timestamp;
  private final ImmutableList<Connection> connections;

  private ImmutableConnectionList(
      LocalDateTime timestamp,
      ImmutableList<Connection> connections) {
    this.timestamp = timestamp;
    this.connections = connections;
  }

  /**
   * @return The value of the {@code timestamp} attribute
   */
  @JsonProperty("timestamp")
  @JsonFormat(pattern = "yyyy-MM-dd hh:mm:ss")
  @Override
  public LocalDateTime timestamp() {
    return timestamp;
  }

  /**
   * @return The value of the {@code connections} attribute
   */
  @JsonProperty("connections")
  @Override
  public ImmutableList<Connection> connections() {
    return connections;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConnectionList#timestamp() timestamp} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for timestamp
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConnectionList withTimestamp(LocalDateTime value) {
    if (this.timestamp == value) return this;
    LocalDateTime newValue = Objects.requireNonNull(value, "timestamp");
    return new ImmutableConnectionList(newValue, this.connections);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ConnectionList#connections() connections}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableConnectionList withConnections(Connection... elements) {
    ImmutableList<Connection> newValue = ImmutableList.copyOf(elements);
    return new ImmutableConnectionList(this.timestamp, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ConnectionList#connections() connections}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of connections elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableConnectionList withConnections(Iterable<? extends Connection> elements) {
    if (this.connections == elements) return this;
    ImmutableList<Connection> newValue = ImmutableList.copyOf(elements);
    return new ImmutableConnectionList(this.timestamp, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableConnectionList} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableConnectionList
        && equalTo((ImmutableConnectionList) another);
  }

  private boolean equalTo(ImmutableConnectionList another) {
    return timestamp.equals(another.timestamp)
        && connections.equals(another.connections);
  }

  /**
   * Computes a hash code from attributes: {@code timestamp}, {@code connections}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + timestamp.hashCode();
    h += (h << 5) + connections.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ConnectionList} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ConnectionList")
        .omitNullValues()
        .add("timestamp", timestamp)
        .add("connections", connections)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ConnectionList", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ConnectionList {
    @Nullable LocalDateTime timestamp;
    @Nullable List<Connection> connections = ImmutableList.of();
    @JsonProperty("timestamp")
    @JsonFormat(pattern = "yyyy-MM-dd hh:mm:ss")
    public void setTimestamp(LocalDateTime timestamp) {
      this.timestamp = timestamp;
    }
    @JsonProperty("connections")
    public void setConnections(List<Connection> connections) {
      this.connections = connections;
    }
    @Override
    public LocalDateTime timestamp() { throw new UnsupportedOperationException(); }
    @Override
    public List<Connection> connections() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableConnectionList fromJson(Json json) {
    ImmutableConnectionList.Builder builder = ImmutableConnectionList.builder();
    if (json.timestamp != null) {
      builder.timestamp(json.timestamp);
    }
    if (json.connections != null) {
      builder.addAllConnections(json.connections);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ConnectionList} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ConnectionList instance
   */
  public static ImmutableConnectionList copyOf(ConnectionList instance) {
    if (instance instanceof ImmutableConnectionList) {
      return (ImmutableConnectionList) instance;
    }
    return ImmutableConnectionList.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableConnectionList ImmutableConnectionList}.
   * <pre>
   * ImmutableConnectionList.builder()
   *    .timestamp(java.time.LocalDateTime) // required {@link ConnectionList#timestamp() timestamp}
   *    .addConnections|addAllConnections(org.jresearch.gavka.domain.Connection) // {@link ConnectionList#connections() connections} elements
   *    .build();
   * </pre>
   * @return A new ImmutableConnectionList builder
   */
  public static ImmutableConnectionList.Builder builder() {
    return new ImmutableConnectionList.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableConnectionList ImmutableConnectionList}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ConnectionList", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TIMESTAMP = 0x1L;
    private long initBits = 0x1L;

    private @Nullable LocalDateTime timestamp;
    private ImmutableList.Builder<Connection> connections = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ConnectionList} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ConnectionList instance) {
      Objects.requireNonNull(instance, "instance");
      timestamp(instance.timestamp());
      addAllConnections(instance.connections());
      return this;
    }

    /**
     * Initializes the value for the {@link ConnectionList#timestamp() timestamp} attribute.
     * @param timestamp The value for timestamp 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("timestamp")
    @JsonFormat(pattern = "yyyy-MM-dd hh:mm:ss")
    public final Builder timestamp(LocalDateTime timestamp) {
      this.timestamp = Objects.requireNonNull(timestamp, "timestamp");
      initBits &= ~INIT_BIT_TIMESTAMP;
      return this;
    }

    /**
     * Adds one element to {@link ConnectionList#connections() connections} list.
     * @param element A connections element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addConnections(Connection element) {
      this.connections.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ConnectionList#connections() connections} list.
     * @param elements An array of connections elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addConnections(Connection... elements) {
      this.connections.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ConnectionList#connections() connections} list.
     * @param elements An iterable of connections elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("connections")
    public final Builder connections(Iterable<? extends Connection> elements) {
      this.connections = ImmutableList.builder();
      return addAllConnections(elements);
    }

    /**
     * Adds elements to {@link ConnectionList#connections() connections} list.
     * @param elements An iterable of connections elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllConnections(Iterable<? extends Connection> elements) {
      this.connections.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableConnectionList ImmutableConnectionList}.
     * @return An immutable instance of ConnectionList
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableConnectionList build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableConnectionList(timestamp, connections.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TIMESTAMP) != 0) attributes.add("timestamp");
      return "Cannot build ConnectionList, some of required attributes are not set " + attributes;
    }
  }
}
