package org.jresearch.gavka.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ListCheck}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableListCheck.Builder()}.
 */
@Generated(from = "ListCheck", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableListCheck<O> implements ListCheck<O> {
  private final ImmutableList<O> subject;
  private final CheckStatus status;
  private final @Nullable String reason;
  private final ImmutableList<SimpleCheck<O>> checks;

  private ImmutableListCheck(
      ImmutableList<O> subject,
      CheckStatus status,
      @Nullable String reason,
      ImmutableList<SimpleCheck<O>> checks) {
    this.subject = subject;
    this.status = status;
    this.reason = reason;
    this.checks = checks;
  }

  /**
   *Object to check 
   */
  @JsonProperty("subject")
  @Override
  public ImmutableList<O> subject() {
    return subject;
  }

  /**
   * @return The value of the {@code status} attribute
   */
  @JsonProperty("status")
  @Override
  public CheckStatus status() {
    return status;
  }

  /**
   * @return The value of the {@code reason} attribute
   */
  @JsonProperty("reason")
  @Override
  public Optional<String> reason() {
    return Optional.ofNullable(reason);
  }

  /**
   * @return The value of the {@code checks} attribute
   */
  @JsonProperty("checks")
  @Override
  public ImmutableList<SimpleCheck<O>> checks() {
    return checks;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ListCheck#subject() subject}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableListCheck<O> withSubject(O... elements) {
    ImmutableList<O> newValue = ImmutableList.copyOf(elements);
    return new ImmutableListCheck<>(newValue, this.status, this.reason, this.checks);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ListCheck#subject() subject}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of subject elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableListCheck<O> withSubject(Iterable<? extends O> elements) {
    if (this.subject == elements) return this;
    ImmutableList<O> newValue = ImmutableList.copyOf(elements);
    return new ImmutableListCheck<>(newValue, this.status, this.reason, this.checks);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ListCheck#status() status} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for status
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableListCheck<O> withStatus(CheckStatus value) {
    if (this.status == value) return this;
    CheckStatus newValue = Objects.requireNonNull(value, "status");
    if (this.status.equals(newValue)) return this;
    return new ImmutableListCheck<>(this.subject, newValue, this.reason, this.checks);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ListCheck#reason() reason} attribute.
   * @param value The value for reason, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ImmutableListCheck<O> withReason(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.reason, newValue)) return this;
    return new ImmutableListCheck<>(this.subject, this.status, newValue, this.checks);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ListCheck#reason() reason} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for reason
   * @return A modified copy of {@code this} object
   */
  public final ImmutableListCheck<O> withReason(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.reason, value)) return this;
    return new ImmutableListCheck<>(this.subject, this.status, value, this.checks);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ListCheck#checks() checks}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableListCheck<O> withChecks(SimpleCheck<O>... elements) {
    ImmutableList<SimpleCheck<O>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableListCheck<>(this.subject, this.status, this.reason, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ListCheck#checks() checks}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of checks elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableListCheck<O> withChecks(Iterable<? extends SimpleCheck<O>> elements) {
    if (this.checks == elements) return this;
    ImmutableList<SimpleCheck<O>> newValue = ImmutableList.copyOf(elements);
    return new ImmutableListCheck<>(this.subject, this.status, this.reason, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableListCheck} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableListCheck<?>
        && equalTo((ImmutableListCheck<?>) another);
  }

  private boolean equalTo(ImmutableListCheck<?> another) {
    return subject.equals(another.subject)
        && status.equals(another.status)
        && Objects.equals(reason, another.reason)
        && checks.equals(another.checks);
  }

  /**
   * Computes a hash code from attributes: {@code subject}, {@code status}, {@code reason}, {@code checks}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + subject.hashCode();
    h += (h << 5) + status.hashCode();
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + checks.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ListCheck} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ListCheck")
        .omitNullValues()
        .add("subject", subject)
        .add("status", status)
        .add("reason", reason)
        .add("checks", checks)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ListCheck} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <O> generic parameter O
   * @param instance The instance to copy
   * @return A copied immutable ListCheck instance
   */
  public static <O> ImmutableListCheck<O> copyOf(ListCheck<O> instance) {
    if (instance instanceof ImmutableListCheck<?>) {
      return (ImmutableListCheck<O>) instance;
    }
    return new ImmutableListCheck.Builder<O>()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableListCheck ImmutableListCheck}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ListCheck", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<O> {
    private static final long INIT_BIT_STATUS = 0x1L;
    private long initBits = 0x1L;

    private ImmutableList.Builder<O> subject = ImmutableList.builder();
    private @Nullable CheckStatus status;
    private @Nullable String reason;
    private ImmutableList.Builder<SimpleCheck<O>> checks = ImmutableList.builder();

    /**
     * Creates a builder for {@link ImmutableListCheck ImmutableListCheck} instances.
     * <pre>
     * new ImmutableListCheck.Builder&amp;lt;O&amp;gt;()
     *    .addSubject|addAllSubject(O) // {@link ListCheck#subject() subject} elements
     *    .status(org.jresearch.gavka.domain.CheckStatus) // required {@link ListCheck#status() status}
     *    .reason(String) // optional {@link ListCheck#reason() reason}
     *    .addChecks|addAllChecks(org.jresearch.gavka.domain.SimpleCheck&amp;lt;O&amp;gt;) // {@link ListCheck#checks() checks} elements
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListCheck} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<O> from(ListCheck<O> instance) {
      Objects.requireNonNull(instance, "instance");
      addAllSubject(instance.subject());
      status(instance.status());
      Optional<String> reasonOptional = instance.reason();
      if (reasonOptional.isPresent()) {
        reason(reasonOptional);
      }
      addAllChecks(instance.checks());
      return this;
    }

    /**
     * Adds one element to {@link ListCheck#subject() subject} list.
     * @param element A subject element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<O> addSubject(O element) {
      this.subject.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ListCheck#subject() subject} list.
     * @param elements An array of subject elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder<O> addSubject(O... elements) {
      this.subject.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListCheck#subject() subject} list.
     * @param elements An iterable of subject elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("subject")
    public final Builder<O> subject(Iterable<? extends O> elements) {
      this.subject = ImmutableList.builder();
      return addAllSubject(elements);
    }

    /**
     * Adds elements to {@link ListCheck#subject() subject} list.
     * @param elements An iterable of subject elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<O> addAllSubject(Iterable<? extends O> elements) {
      this.subject.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link ListCheck#status() status} attribute.
     * @param status The value for status 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("status")
    public final Builder<O> status(CheckStatus status) {
      this.status = Objects.requireNonNull(status, "status");
      initBits &= ~INIT_BIT_STATUS;
      return this;
    }

    /**
     * Initializes the optional value {@link ListCheck#reason() reason} to reason.
     * @param reason The value for reason, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<O> reason(@Nullable String reason) {
      this.reason = reason;
      return this;
    }

    /**
     * Initializes the optional value {@link ListCheck#reason() reason} to reason.
     * @param reason The value for reason
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("reason")
    public final Builder<O> reason(Optional<String> reason) {
      this.reason = reason.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link ListCheck#checks() checks} list.
     * @param element A checks element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<O> addChecks(SimpleCheck<O> element) {
      this.checks.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ListCheck#checks() checks} list.
     * @param elements An array of checks elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder<O> addChecks(SimpleCheck<O>... elements) {
      this.checks.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListCheck#checks() checks} list.
     * @param elements An iterable of checks elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("checks")
    public final Builder<O> checks(Iterable<? extends SimpleCheck<O>> elements) {
      this.checks = ImmutableList.builder();
      return addAllChecks(elements);
    }

    /**
     * Adds elements to {@link ListCheck#checks() checks} list.
     * @param elements An iterable of checks elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<O> addAllChecks(Iterable<? extends SimpleCheck<O>> elements) {
      this.checks.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableListCheck ImmutableListCheck}.
     * @return An immutable instance of ListCheck
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableListCheck<O> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableListCheck<>(subject.build(), status, reason, checks.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_STATUS) != 0) attributes.add("status");
      return "Cannot build ListCheck, some of required attributes are not set " + attributes;
    }
  }
}
