package org.jresearch.gavka.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SimpleCheck}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableSimpleCheck.Builder()}.
 */
@Generated(from = "SimpleCheck", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSimpleCheck<O> implements SimpleCheck<O> {
  private final O subject;
  private final CheckStatus status;
  private final @Nullable String reason;

  private ImmutableSimpleCheck(
      O subject,
      CheckStatus status,
      @Nullable String reason) {
    this.subject = subject;
    this.status = status;
    this.reason = reason;
  }

  /**
   *Object to check 
   */
  @JsonProperty("subject")
  @Override
  public O subject() {
    return subject;
  }

  /**
   * @return The value of the {@code status} attribute
   */
  @JsonProperty("status")
  @Override
  public CheckStatus status() {
    return status;
  }

  /**
   * @return The value of the {@code reason} attribute
   */
  @JsonProperty("reason")
  @Override
  public Optional<String> reason() {
    return Optional.ofNullable(reason);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SimpleCheck#subject() subject} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for subject
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSimpleCheck<O> withSubject(O value) {
    if (this.subject == value) return this;
    O newValue = Objects.requireNonNull(value, "subject");
    return new ImmutableSimpleCheck<>(newValue, this.status, this.reason);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SimpleCheck#status() status} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for status
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSimpleCheck<O> withStatus(CheckStatus value) {
    if (this.status == value) return this;
    CheckStatus newValue = Objects.requireNonNull(value, "status");
    if (this.status.equals(newValue)) return this;
    return new ImmutableSimpleCheck<>(this.subject, newValue, this.reason);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SimpleCheck#reason() reason} attribute.
   * @param value The value for reason, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSimpleCheck<O> withReason(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.reason, newValue)) return this;
    return new ImmutableSimpleCheck<>(this.subject, this.status, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SimpleCheck#reason() reason} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for reason
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSimpleCheck<O> withReason(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.reason, value)) return this;
    return new ImmutableSimpleCheck<>(this.subject, this.status, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSimpleCheck} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSimpleCheck<?>
        && equalTo((ImmutableSimpleCheck<?>) another);
  }

  private boolean equalTo(ImmutableSimpleCheck<?> another) {
    return subject.equals(another.subject)
        && status.equals(another.status)
        && Objects.equals(reason, another.reason);
  }

  /**
   * Computes a hash code from attributes: {@code subject}, {@code status}, {@code reason}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + subject.hashCode();
    h += (h << 5) + status.hashCode();
    h += (h << 5) + Objects.hashCode(reason);
    return h;
  }

  /**
   * Prints the immutable value {@code SimpleCheck} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SimpleCheck")
        .omitNullValues()
        .add("subject", subject)
        .add("status", status)
        .add("reason", reason)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link SimpleCheck} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <O> generic parameter O
   * @param instance The instance to copy
   * @return A copied immutable SimpleCheck instance
   */
  public static <O> ImmutableSimpleCheck<O> copyOf(SimpleCheck<O> instance) {
    if (instance instanceof ImmutableSimpleCheck<?>) {
      return (ImmutableSimpleCheck<O>) instance;
    }
    return new ImmutableSimpleCheck.Builder<O>()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableSimpleCheck ImmutableSimpleCheck}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SimpleCheck", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<O> {
    private static final long INIT_BIT_SUBJECT = 0x1L;
    private static final long INIT_BIT_STATUS = 0x2L;
    private long initBits = 0x3L;

    private @Nullable O subject;
    private @Nullable CheckStatus status;
    private @Nullable String reason;

    /**
     * Creates a builder for {@link ImmutableSimpleCheck ImmutableSimpleCheck} instances.
     * <pre>
     * new ImmutableSimpleCheck.Builder&amp;lt;O&amp;gt;()
     *    .subject(O) // required {@link SimpleCheck#subject() subject}
     *    .status(org.jresearch.gavka.domain.CheckStatus) // required {@link SimpleCheck#status() status}
     *    .reason(String) // optional {@link SimpleCheck#reason() reason}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SimpleCheck} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<O> from(SimpleCheck<O> instance) {
      Objects.requireNonNull(instance, "instance");
      subject(instance.subject());
      status(instance.status());
      Optional<String> reasonOptional = instance.reason();
      if (reasonOptional.isPresent()) {
        reason(reasonOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link SimpleCheck#subject() subject} attribute.
     * @param subject The value for subject 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("subject")
    public final Builder<O> subject(O subject) {
      this.subject = Objects.requireNonNull(subject, "subject");
      initBits &= ~INIT_BIT_SUBJECT;
      return this;
    }

    /**
     * Initializes the value for the {@link SimpleCheck#status() status} attribute.
     * @param status The value for status 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("status")
    public final Builder<O> status(CheckStatus status) {
      this.status = Objects.requireNonNull(status, "status");
      initBits &= ~INIT_BIT_STATUS;
      return this;
    }

    /**
     * Initializes the optional value {@link SimpleCheck#reason() reason} to reason.
     * @param reason The value for reason, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<O> reason(@Nullable String reason) {
      this.reason = reason;
      return this;
    }

    /**
     * Initializes the optional value {@link SimpleCheck#reason() reason} to reason.
     * @param reason The value for reason
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("reason")
    public final Builder<O> reason(Optional<String> reason) {
      this.reason = reason.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableSimpleCheck ImmutableSimpleCheck}.
     * @return An immutable instance of SimpleCheck
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSimpleCheck<O> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSimpleCheck<>(subject, status, reason);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SUBJECT) != 0) attributes.add("subject");
      if ((initBits & INIT_BIT_STATUS) != 0) attributes.add("status");
      return "Cannot build SimpleCheck, some of required attributes are not set " + attributes;
    }
  }
}
