package org.jresearch.gavka.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link Connection Connection} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableConnection is not thread-safe</em>
 * @see ImmutableConnection
 */
@Generated(from = "Connection", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "Connection"})
@NotThreadSafe
public final class ModifiableConnection implements Connection {
  private final ArrayList<String> bootstrapServers = new ArrayList<String>();
  private final ArrayList<String> schemaRegistryUrl = new ArrayList<String>();
  private final Map<String, String> properties = new LinkedHashMap<String, String>();
  private String id;
  private String label;
  private String icon;
  private String color;
  private Optional<ConnectionCheck> connectionCheck = Optional.empty();

  private ModifiableConnection() {}

  /**
   * Construct a modifiable instance of {@code Connection}.
   * @return A new modifiable instance
   */
  public static ModifiableConnection create() {
    return new ModifiableConnection();
  }

  /**
   * @return modifiable list {@code bootstrapServers}
   */
  @JsonProperty("bootstrapServers")
  @Override
  public final List<String> getBootstrapServers() {
    return bootstrapServers;
  }

  /**
   * @return modifiable list {@code schemaRegistryUrl}
   */
  @JsonProperty("schemaRegistryUrl")
  @Override
  public final List<String> getSchemaRegistryUrl() {
    return schemaRegistryUrl;
  }

  /**
   * @return value of {@code properties} attribute
   */
  @JsonProperty("properties")
  @Override
  public final Map<String, String> getProperties() {
    return properties;
  }

  /**
   * @return assigned or, otherwise, newly computed, not cached value of {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public final String getId() {
    return idIsSet()
        ? id
        : Connection.super.getId();
  }

  /**
   * @return assigned or, otherwise, newly computed, not cached value of {@code label} attribute
   */
  @JsonProperty("label")
  @Override
  public final String getLabel() {
    return labelIsSet()
        ? label
        : Connection.super.getLabel();
  }

  /**
   * @return assigned or, otherwise, newly computed, not cached value of {@code icon} attribute
   */
  @JsonProperty("icon")
  @Override
  public final String getIcon() {
    return iconIsSet()
        ? icon
        : Connection.super.getIcon();
  }

  /**
   * @return assigned or, otherwise, newly computed, not cached value of {@code color} attribute
   */
  @JsonProperty("color")
  @Override
  public final String getColor() {
    return colorIsSet()
        ? color
        : Connection.super.getColor();
  }

  /**
   * @return value of {@code connectionCheck} attribute
   */
  @JsonProperty("connectionCheck")
  @Override
  public final Optional<ConnectionCheck> connectionCheck() {
    return connectionCheck;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableConnection clear() {
    bootstrapServers.clear();
    schemaRegistryUrl.clear();
    properties.clear();
    id = null;
    label = null;
    icon = null;
    color = null;
    connectionCheck = Optional.empty();
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link org.jresearch.gavka.domain.ConnectionParameters} instance.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableConnection from(ConnectionParameters instance) {
    Objects.requireNonNull(instance, "instance");
    from((Object) instance);
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link org.jresearch.gavka.domain.Connection} instance.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableConnection from(Connection instance) {
    Objects.requireNonNull(instance, "instance");
    from((Object) instance);
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Connection} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableConnection from(ModifiableConnection instance) {
    Objects.requireNonNull(instance, "instance");
    from((Object) instance);
    return this;
  }

  private void from(Object object) {
    if (object instanceof ModifiableConnection) {
      ModifiableConnection instance = (ModifiableConnection) object;
      addAllBootstrapServers(instance.getBootstrapServers());
      addAllSchemaRegistryUrl(instance.getSchemaRegistryUrl());
      putAllProperties(instance.getProperties());
      setId(instance.getId());
      setLabel(instance.getLabel());
      setIcon(instance.getIcon());
      setColor(instance.getColor());
      Optional<ConnectionCheck> connectionCheckOptional = instance.connectionCheck();
      if (connectionCheckOptional.isPresent()) {
        setConnectionCheck(connectionCheckOptional);
      }
      return;
    }
    if (object instanceof ConnectionParameters) {
      ConnectionParameters instance = (ConnectionParameters) object;
      addAllSchemaRegistryUrl(instance.getSchemaRegistryUrl());
      addAllBootstrapServers(instance.getBootstrapServers());
      putAllProperties(instance.getProperties());
    }
    if (object instanceof Connection) {
      Connection instance = (Connection) object;
      setIcon(instance.getIcon());
      setId(instance.getId());
      setLabel(instance.getLabel());
      setColor(instance.getColor());
      Optional<ConnectionCheck> connectionCheckOptional = instance.connectionCheck();
      if (connectionCheckOptional.isPresent()) {
        setConnectionCheck(connectionCheckOptional);
      }
    }
  }

  /**
   * Adds one element to {@link Connection#getBootstrapServers() bootstrapServers} list.
   * @param element The bootstrapServers element
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableConnection addBootstrapServers(String element) {
    Objects.requireNonNull(element, "bootstrapServers element");
    this.bootstrapServers.add(element);
    return this;
  }

  /**
   * Adds elements to {@link Connection#getBootstrapServers() bootstrapServers} list.
   * @param elements An array of bootstrapServers elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableConnection addBootstrapServers(String... elements) {
    for (String e : elements) {
      addBootstrapServers(e);
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link Connection#getBootstrapServers() bootstrapServers} list.
   * @param elements An iterable of bootstrapServers elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableConnection setBootstrapServers(Iterable<String> elements) {
    this.bootstrapServers.clear();
    addAllBootstrapServers(elements);
    return this;
  }

  /**
   * Adds elements to {@link Connection#getBootstrapServers() bootstrapServers} list.
   * @param elements An iterable of bootstrapServers elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableConnection addAllBootstrapServers(Iterable<String> elements) {
    for (String e : elements) {
      addBootstrapServers(e);
    }
    return this;
  }

  /**
   * Adds one element to {@link Connection#getSchemaRegistryUrl() schemaRegistryUrl} list.
   * @param element The schemaRegistryUrl element
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableConnection addSchemaRegistryUrl(String element) {
    Objects.requireNonNull(element, "schemaRegistryUrl element");
    this.schemaRegistryUrl.add(element);
    return this;
  }

  /**
   * Adds elements to {@link Connection#getSchemaRegistryUrl() schemaRegistryUrl} list.
   * @param elements An array of schemaRegistryUrl elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableConnection addSchemaRegistryUrl(String... elements) {
    for (String e : elements) {
      addSchemaRegistryUrl(e);
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link Connection#getSchemaRegistryUrl() schemaRegistryUrl} list.
   * @param elements An iterable of schemaRegistryUrl elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableConnection setSchemaRegistryUrl(Iterable<String> elements) {
    this.schemaRegistryUrl.clear();
    addAllSchemaRegistryUrl(elements);
    return this;
  }

  /**
   * Adds elements to {@link Connection#getSchemaRegistryUrl() schemaRegistryUrl} list.
   * @param elements An iterable of schemaRegistryUrl elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableConnection addAllSchemaRegistryUrl(Iterable<String> elements) {
    for (String e : elements) {
      addSchemaRegistryUrl(e);
    }
    return this;
  }

  /**
   * Put one entry to the {@link Connection#getProperties() properties} map.
   * @param key The key in properties map
   * @param value The associated value in the properties map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableConnection putProperties(String key, String value) {
    this.properties.put(
        Objects.requireNonNull(key, "properties key"),
        Objects.requireNonNull(value, "properties value"));
    return this;
  }

  /**
   * Sets or replaces all mappings from the specified map as entries for the {@link Connection#getProperties() properties} map.
   * Nulls are not permitted as keys or values.
   * @param entries The entries that will be added to the properties map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableConnection setProperties(Map<String, ? extends String> entries) {
    this.properties.clear();
    for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
      String k = e.getKey();
      String v = e.getValue();
      this.properties.put(
          Objects.requireNonNull(k, "properties key"),
          Objects.requireNonNull(v, "properties value"));
    }
    return this;
  }

  /**
   * Put all mappings from the specified map as entries to the {@link Connection#getProperties() properties} map.
   * Nulls are not permitted as keys or values.
   * @param entries to be added to properties map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableConnection putAllProperties(Map<String, ? extends String> entries) {
    for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
      String k = e.getKey();
      String v = e.getValue();
      this.properties.put(
          Objects.requireNonNull(k, "properties key"),
          Objects.requireNonNull(v, "properties value"));
    }
    return this;
  }

  /**
   * Assigns a value to the {@link Connection#getId() id} attribute.
   * <p><em>If not set, this attribute will have a default value returned by the initializer of {@link Connection#getId() id}.</em>
   * @param id The value for id
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableConnection setId(String id) {
    this.id = Objects.requireNonNull(id, "id");
    return this;
  }

  /**
   * Assigns a value to the {@link Connection#getLabel() label} attribute.
   * <p><em>If not set, this attribute will have a default value returned by the initializer of {@link Connection#getLabel() label}.</em>
   * @param label The value for label
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableConnection setLabel(String label) {
    this.label = Objects.requireNonNull(label, "label");
    return this;
  }

  /**
   * Assigns a value to the {@link Connection#getIcon() icon} attribute.
   * <p><em>If not set, this attribute will have a default value returned by the initializer of {@link Connection#getIcon() icon}.</em>
   * @param icon The value for icon
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableConnection setIcon(String icon) {
    this.icon = Objects.requireNonNull(icon, "icon");
    return this;
  }

  /**
   * Assigns a value to the {@link Connection#getColor() color} attribute.
   * <p><em>If not set, this attribute will have a default value returned by the initializer of {@link Connection#getColor() color}.</em>
   * @param color The value for color
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableConnection setColor(String color) {
    this.color = Objects.requireNonNull(color, "color");
    return this;
  }

  /**
   * Assigns a <i>present</i> value for the optional {@link Connection#connectionCheck() connectionCheck} attribute.
   * @param connectionCheck A value for connectionCheck, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableConnection setConnectionCheck(@Nullable ConnectionCheck connectionCheck) {
    this.connectionCheck = Optional.ofNullable(connectionCheck);
    return this;
  }

  /**
   * Assigns an optional value for {@link Connection#connectionCheck() connectionCheck}.
   * @param connectionCheck A value for connectionCheck
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableConnection setConnectionCheck(Optional<ConnectionCheck> connectionCheck) {
    this.connectionCheck = Objects.requireNonNull(connectionCheck, "connectionCheck");
    return this;
  }

  /**
   * Returns {@code true} if the default attribute {@link Connection#getId() id} is set.
   * @return {@code true} if set
   */
  public final boolean idIsSet() {
    return id != null;
  }

  /**
   * Returns {@code true} if the default attribute {@link Connection#getLabel() label} is set.
   * @return {@code true} if set
   */
  public final boolean labelIsSet() {
    return label != null;
  }

  /**
   * Returns {@code true} if the default attribute {@link Connection#getIcon() icon} is set.
   * @return {@code true} if set
   */
  public final boolean iconIsSet() {
    return icon != null;
  }

  /**
   * Returns {@code true} if the default attribute {@link Connection#getColor() color} is set.
   * @return {@code true} if set
   */
  public final boolean colorIsSet() {
    return color != null;
  }


  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return true;
  }

  /**
   * Converts to {@link ImmutableConnection ImmutableConnection}.
   * @return An immutable instance of Connection
   */
  public final ImmutableConnection toImmutable() {
    return ImmutableConnection.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableConnection} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableConnection)) return false;
    ModifiableConnection other = (ModifiableConnection) another;
    return equalTo(other);
  }

  private boolean equalTo(ModifiableConnection another) {
    String id = getId();
    String label = getLabel();
    String icon = getIcon();
    String color = getColor();
    return bootstrapServers.equals(another.bootstrapServers)
        && schemaRegistryUrl.equals(another.schemaRegistryUrl)
        && properties.equals(another.properties)
        && id.equals(another.getId())
        && label.equals(another.getLabel())
        && icon.equals(another.getIcon())
        && color.equals(another.getColor())
        && Objects.equals(connectionCheck, another.connectionCheck);
  }

  /**
   * Computes a hash code from attributes: {@code bootstrapServers}, {@code schemaRegistryUrl}, {@code properties}, {@code id}, {@code label}, {@code icon}, {@code color}, {@code connectionCheck}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + bootstrapServers.hashCode();
    h += (h << 5) + schemaRegistryUrl.hashCode();
    h += (h << 5) + properties.hashCode();
    String id = getId();
    h += (h << 5) + id.hashCode();
    String label = getLabel();
    h += (h << 5) + label.hashCode();
    String icon = getIcon();
    h += (h << 5) + icon.hashCode();
    String color = getColor();
    h += (h << 5) + color.hashCode();
    h += (h << 5) + connectionCheck.hashCode();
    return h;
  }

  /**
   * Generates a string representation of this {@code Connection}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ModifiableConnection")
        .add("bootstrapServers", getBootstrapServers())
        .add("schemaRegistryUrl", getSchemaRegistryUrl())
        .add("properties", getProperties())
        .add("id", getId())
        .add("label", getLabel())
        .add("icon", getIcon())
        .add("color", getColor())
        .add("connectionCheck", connectionCheck())
        .toString();
  }
}
