package org.jresearch.gavka.rest.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PartitionInfo}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutablePartitionInfo.Builder()}.
 */
@Generated(from = "PartitionInfo", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePartitionInfo implements PartitionInfo {
  private final long partitionNumber;
  private final long startOffset;
  private final long endOffset;

  private ImmutablePartitionInfo(long partitionNumber, long startOffset, long endOffset) {
    this.partitionNumber = partitionNumber;
    this.startOffset = startOffset;
    this.endOffset = endOffset;
  }

  /**
   * @return The value of the {@code partitionNumber} attribute
   */
  @JsonProperty("partitionNumber")
  @Override
  public long partitionNumber() {
    return partitionNumber;
  }

  /**
   * @return The value of the {@code startOffset} attribute
   */
  @JsonProperty("startOffset")
  @Override
  public long startOffset() {
    return startOffset;
  }

  /**
   * @return The value of the {@code endOffset} attribute
   */
  @JsonProperty("endOffset")
  @Override
  public long endOffset() {
    return endOffset;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PartitionInfo#partitionNumber() partitionNumber} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for partitionNumber
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePartitionInfo withPartitionNumber(long value) {
    if (this.partitionNumber == value) return this;
    return new ImmutablePartitionInfo(value, this.startOffset, this.endOffset);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PartitionInfo#startOffset() startOffset} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for startOffset
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePartitionInfo withStartOffset(long value) {
    if (this.startOffset == value) return this;
    return new ImmutablePartitionInfo(this.partitionNumber, value, this.endOffset);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PartitionInfo#endOffset() endOffset} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for endOffset
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePartitionInfo withEndOffset(long value) {
    if (this.endOffset == value) return this;
    return new ImmutablePartitionInfo(this.partitionNumber, this.startOffset, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePartitionInfo} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePartitionInfo
        && equalTo((ImmutablePartitionInfo) another);
  }

  private boolean equalTo(ImmutablePartitionInfo another) {
    return partitionNumber == another.partitionNumber
        && startOffset == another.startOffset
        && endOffset == another.endOffset;
  }

  /**
   * Computes a hash code from attributes: {@code partitionNumber}, {@code startOffset}, {@code endOffset}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Longs.hashCode(partitionNumber);
    h += (h << 5) + Longs.hashCode(startOffset);
    h += (h << 5) + Longs.hashCode(endOffset);
    return h;
  }

  /**
   * Prints the immutable value {@code PartitionInfo} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PartitionInfo")
        .omitNullValues()
        .add("partitionNumber", partitionNumber)
        .add("startOffset", startOffset)
        .add("endOffset", endOffset)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link PartitionInfo} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PartitionInfo instance
   */
  public static ImmutablePartitionInfo copyOf(PartitionInfo instance) {
    if (instance instanceof ImmutablePartitionInfo) {
      return (ImmutablePartitionInfo) instance;
    }
    return new ImmutablePartitionInfo.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutablePartitionInfo ImmutablePartitionInfo}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PartitionInfo", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PARTITION_NUMBER = 0x1L;
    private static final long INIT_BIT_START_OFFSET = 0x2L;
    private static final long INIT_BIT_END_OFFSET = 0x4L;
    private long initBits = 0x7L;

    private long partitionNumber;
    private long startOffset;
    private long endOffset;

    /**
     * Creates a builder for {@link ImmutablePartitionInfo ImmutablePartitionInfo} instances.
     * <pre>
     * new ImmutablePartitionInfo.Builder()
     *    .partitionNumber(long) // required {@link PartitionInfo#partitionNumber() partitionNumber}
     *    .startOffset(long) // required {@link PartitionInfo#startOffset() startOffset}
     *    .endOffset(long) // required {@link PartitionInfo#endOffset() endOffset}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PartitionInfo} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(PartitionInfo instance) {
      Objects.requireNonNull(instance, "instance");
      partitionNumber(instance.partitionNumber());
      startOffset(instance.startOffset());
      endOffset(instance.endOffset());
      return this;
    }

    /**
     * Initializes the value for the {@link PartitionInfo#partitionNumber() partitionNumber} attribute.
     * @param partitionNumber The value for partitionNumber 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("partitionNumber")
    public final Builder partitionNumber(long partitionNumber) {
      this.partitionNumber = partitionNumber;
      initBits &= ~INIT_BIT_PARTITION_NUMBER;
      return this;
    }

    /**
     * Initializes the value for the {@link PartitionInfo#startOffset() startOffset} attribute.
     * @param startOffset The value for startOffset 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("startOffset")
    public final Builder startOffset(long startOffset) {
      this.startOffset = startOffset;
      initBits &= ~INIT_BIT_START_OFFSET;
      return this;
    }

    /**
     * Initializes the value for the {@link PartitionInfo#endOffset() endOffset} attribute.
     * @param endOffset The value for endOffset 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("endOffset")
    public final Builder endOffset(long endOffset) {
      this.endOffset = endOffset;
      initBits &= ~INIT_BIT_END_OFFSET;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePartitionInfo ImmutablePartitionInfo}.
     * @return An immutable instance of PartitionInfo
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePartitionInfo build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePartitionInfo(partitionNumber, startOffset, endOffset);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PARTITION_NUMBER) != 0) attributes.add("partitionNumber");
      if ((initBits & INIT_BIT_START_OFFSET) != 0) attributes.add("startOffset");
      if ((initBits & INIT_BIT_END_OFFSET) != 0) attributes.add("endOffset");
      return "Cannot build PartitionInfo, some of required attributes are not set " + attributes;
    }
  }
}
