package org.jresearch.gavka.rest.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ConnectionLabel}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableConnectionLabel.Builder()}.
 */
@Generated(from = "ConnectionLabel", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableConnectionLabel implements ConnectionLabel {
  private final String id;
  private final String label;

  private ImmutableConnectionLabel(String id, String label) {
    this.id = id;
    this.label = label;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String id() {
    return id;
  }

  /**
   * @return The value of the {@code label} attribute
   */
  @JsonProperty("label")
  @Override
  public String label() {
    return label;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConnectionLabel#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConnectionLabel withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableConnectionLabel(newValue, this.label);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConnectionLabel#label() label} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for label
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConnectionLabel withLabel(String value) {
    String newValue = Objects.requireNonNull(value, "label");
    if (this.label.equals(newValue)) return this;
    return new ImmutableConnectionLabel(this.id, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableConnectionLabel} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableConnectionLabel
        && equalTo((ImmutableConnectionLabel) another);
  }

  private boolean equalTo(ImmutableConnectionLabel another) {
    return id.equals(another.id)
        && label.equals(another.label);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code label}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + label.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ConnectionLabel} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ConnectionLabel")
        .omitNullValues()
        .add("id", id)
        .add("label", label)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ConnectionLabel} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ConnectionLabel instance
   */
  public static ImmutableConnectionLabel copyOf(ConnectionLabel instance) {
    if (instance instanceof ImmutableConnectionLabel) {
      return (ImmutableConnectionLabel) instance;
    }
    return new ImmutableConnectionLabel.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableConnectionLabel ImmutableConnectionLabel}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ConnectionLabel", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_LABEL = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String id;
    private @Nullable String label;

    /**
     * Creates a builder for {@link ImmutableConnectionLabel ImmutableConnectionLabel} instances.
     * <pre>
     * new ImmutableConnectionLabel.Builder()
     *    .id(String) // required {@link ConnectionLabel#id() id}
     *    .label(String) // required {@link ConnectionLabel#label() label}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ConnectionLabel} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ConnectionLabel instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.id());
      label(instance.label());
      return this;
    }

    /**
     * Initializes the value for the {@link ConnectionLabel#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ConnectionLabel#label() label} attribute.
     * @param label The value for label 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("label")
    public final Builder label(String label) {
      this.label = Objects.requireNonNull(label, "label");
      initBits &= ~INIT_BIT_LABEL;
      return this;
    }

    /**
     * Builds a new {@link ImmutableConnectionLabel ImmutableConnectionLabel}.
     * @return An immutable instance of ConnectionLabel
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableConnectionLabel build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableConnectionLabel(id, label);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_LABEL) != 0) attributes.add("label");
      return "Cannot build ConnectionLabel, some of required attributes are not set " + attributes;
    }
  }
}
