package org.jresearch.gavka.rest.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TopicRestInfo}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableTopicRestInfo.Builder()}.
 */
@Generated(from = "TopicRestInfo", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTopicRestInfo implements TopicRestInfo {
  private final String name;
  private final ImmutableList<PartitionInfo> partitionInfo;
  private final ImmutableList<GroupInfo> groupInfo;

  private ImmutableTopicRestInfo(
      String name,
      ImmutableList<PartitionInfo> partitionInfo,
      ImmutableList<GroupInfo> groupInfo) {
    this.name = name;
    this.partitionInfo = partitionInfo;
    this.groupInfo = groupInfo;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code partitionInfo} attribute
   */
  @JsonProperty("partitionInfo")
  @Override
  public ImmutableList<PartitionInfo> partitionInfo() {
    return partitionInfo;
  }

  /**
   * @return The value of the {@code groupInfo} attribute
   */
  @JsonProperty("groupInfo")
  @Override
  public ImmutableList<GroupInfo> groupInfo() {
    return groupInfo;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TopicRestInfo#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTopicRestInfo withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableTopicRestInfo(newValue, this.partitionInfo, this.groupInfo);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TopicRestInfo#partitionInfo() partitionInfo}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTopicRestInfo withPartitionInfo(PartitionInfo... elements) {
    ImmutableList<PartitionInfo> newValue = ImmutableList.copyOf(elements);
    return new ImmutableTopicRestInfo(this.name, newValue, this.groupInfo);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TopicRestInfo#partitionInfo() partitionInfo}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of partitionInfo elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTopicRestInfo withPartitionInfo(Iterable<? extends PartitionInfo> elements) {
    if (this.partitionInfo == elements) return this;
    ImmutableList<PartitionInfo> newValue = ImmutableList.copyOf(elements);
    return new ImmutableTopicRestInfo(this.name, newValue, this.groupInfo);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TopicRestInfo#groupInfo() groupInfo}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTopicRestInfo withGroupInfo(GroupInfo... elements) {
    ImmutableList<GroupInfo> newValue = ImmutableList.copyOf(elements);
    return new ImmutableTopicRestInfo(this.name, this.partitionInfo, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TopicRestInfo#groupInfo() groupInfo}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of groupInfo elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTopicRestInfo withGroupInfo(Iterable<? extends GroupInfo> elements) {
    if (this.groupInfo == elements) return this;
    ImmutableList<GroupInfo> newValue = ImmutableList.copyOf(elements);
    return new ImmutableTopicRestInfo(this.name, this.partitionInfo, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTopicRestInfo} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTopicRestInfo
        && equalTo((ImmutableTopicRestInfo) another);
  }

  private boolean equalTo(ImmutableTopicRestInfo another) {
    return name.equals(another.name)
        && partitionInfo.equals(another.partitionInfo)
        && groupInfo.equals(another.groupInfo);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code partitionInfo}, {@code groupInfo}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + partitionInfo.hashCode();
    h += (h << 5) + groupInfo.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TopicRestInfo} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TopicRestInfo")
        .omitNullValues()
        .add("name", name)
        .add("partitionInfo", partitionInfo)
        .add("groupInfo", groupInfo)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link TopicRestInfo} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TopicRestInfo instance
   */
  public static ImmutableTopicRestInfo copyOf(TopicRestInfo instance) {
    if (instance instanceof ImmutableTopicRestInfo) {
      return (ImmutableTopicRestInfo) instance;
    }
    return new ImmutableTopicRestInfo.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableTopicRestInfo ImmutableTopicRestInfo}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TopicRestInfo", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String name;
    private ImmutableList.Builder<PartitionInfo> partitionInfo = ImmutableList.builder();
    private ImmutableList.Builder<GroupInfo> groupInfo = ImmutableList.builder();

    /**
     * Creates a builder for {@link ImmutableTopicRestInfo ImmutableTopicRestInfo} instances.
     * <pre>
     * new ImmutableTopicRestInfo.Builder()
     *    .name(String) // required {@link TopicRestInfo#name() name}
     *    .addPartitionInfo|addAllPartitionInfo(org.jresearch.gavka.rest.data.PartitionInfo) // {@link TopicRestInfo#partitionInfo() partitionInfo} elements
     *    .addGroupInfo|addAllGroupInfo(org.jresearch.gavka.rest.data.GroupInfo) // {@link TopicRestInfo#groupInfo() groupInfo} elements
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TopicRestInfo} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(TopicRestInfo instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.name());
      addAllPartitionInfo(instance.partitionInfo());
      addAllGroupInfo(instance.groupInfo());
      return this;
    }

    /**
     * Initializes the value for the {@link TopicRestInfo#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Adds one element to {@link TopicRestInfo#partitionInfo() partitionInfo} list.
     * @param element A partitionInfo element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPartitionInfo(PartitionInfo element) {
      this.partitionInfo.add(element);
      return this;
    }

    /**
     * Adds elements to {@link TopicRestInfo#partitionInfo() partitionInfo} list.
     * @param elements An array of partitionInfo elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPartitionInfo(PartitionInfo... elements) {
      this.partitionInfo.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link TopicRestInfo#partitionInfo() partitionInfo} list.
     * @param elements An iterable of partitionInfo elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("partitionInfo")
    public final Builder partitionInfo(Iterable<? extends PartitionInfo> elements) {
      this.partitionInfo = ImmutableList.builder();
      return addAllPartitionInfo(elements);
    }

    /**
     * Adds elements to {@link TopicRestInfo#partitionInfo() partitionInfo} list.
     * @param elements An iterable of partitionInfo elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllPartitionInfo(Iterable<? extends PartitionInfo> elements) {
      this.partitionInfo.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link TopicRestInfo#groupInfo() groupInfo} list.
     * @param element A groupInfo element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addGroupInfo(GroupInfo element) {
      this.groupInfo.add(element);
      return this;
    }

    /**
     * Adds elements to {@link TopicRestInfo#groupInfo() groupInfo} list.
     * @param elements An array of groupInfo elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addGroupInfo(GroupInfo... elements) {
      this.groupInfo.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link TopicRestInfo#groupInfo() groupInfo} list.
     * @param elements An iterable of groupInfo elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("groupInfo")
    public final Builder groupInfo(Iterable<? extends GroupInfo> elements) {
      this.groupInfo = ImmutableList.builder();
      return addAllGroupInfo(elements);
    }

    /**
     * Adds elements to {@link TopicRestInfo#groupInfo() groupInfo} list.
     * @param elements An iterable of groupInfo elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllGroupInfo(Iterable<? extends GroupInfo> elements) {
      this.groupInfo.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableTopicRestInfo ImmutableTopicRestInfo}.
     * @return An immutable instance of TopicRestInfo
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTopicRestInfo build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTopicRestInfo(name, partitionInfo.build(), groupInfo.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build TopicRestInfo, some of required attributes are not set " + attributes;
    }
  }
}
