package org.jresearch.gavka.rest.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link GroupInfo}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableGroupInfo.Builder()}.
 */
@Generated(from = "GroupInfo", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableGroupInfo implements GroupInfo {
  private final String groupId;
  private final int partition;
  private final long currentOffset;
  private final long lag;

  private ImmutableGroupInfo(String groupId, int partition, long currentOffset, long lag) {
    this.groupId = groupId;
    this.partition = partition;
    this.currentOffset = currentOffset;
    this.lag = lag;
  }

  /**
   * @return The value of the {@code groupId} attribute
   */
  @JsonProperty("groupId")
  @Override
  public String groupId() {
    return groupId;
  }

  /**
   * @return The value of the {@code partition} attribute
   */
  @JsonProperty("partition")
  @Override
  public int partition() {
    return partition;
  }

  /**
   * @return The value of the {@code currentOffset} attribute
   */
  @JsonProperty("currentOffset")
  @Override
  public long currentOffset() {
    return currentOffset;
  }

  /**
   * @return The value of the {@code lag} attribute
   */
  @JsonProperty("lag")
  @Override
  public long lag() {
    return lag;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GroupInfo#groupId() groupId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for groupId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGroupInfo withGroupId(String value) {
    String newValue = Objects.requireNonNull(value, "groupId");
    if (this.groupId.equals(newValue)) return this;
    return new ImmutableGroupInfo(newValue, this.partition, this.currentOffset, this.lag);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GroupInfo#partition() partition} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for partition
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGroupInfo withPartition(int value) {
    if (this.partition == value) return this;
    return new ImmutableGroupInfo(this.groupId, value, this.currentOffset, this.lag);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GroupInfo#currentOffset() currentOffset} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for currentOffset
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGroupInfo withCurrentOffset(long value) {
    if (this.currentOffset == value) return this;
    return new ImmutableGroupInfo(this.groupId, this.partition, value, this.lag);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GroupInfo#lag() lag} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for lag
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGroupInfo withLag(long value) {
    if (this.lag == value) return this;
    return new ImmutableGroupInfo(this.groupId, this.partition, this.currentOffset, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGroupInfo} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGroupInfo
        && equalTo((ImmutableGroupInfo) another);
  }

  private boolean equalTo(ImmutableGroupInfo another) {
    return groupId.equals(another.groupId)
        && partition == another.partition
        && currentOffset == another.currentOffset
        && lag == another.lag;
  }

  /**
   * Computes a hash code from attributes: {@code groupId}, {@code partition}, {@code currentOffset}, {@code lag}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + groupId.hashCode();
    h += (h << 5) + partition;
    h += (h << 5) + Longs.hashCode(currentOffset);
    h += (h << 5) + Longs.hashCode(lag);
    return h;
  }

  /**
   * Prints the immutable value {@code GroupInfo} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("GroupInfo")
        .omitNullValues()
        .add("groupId", groupId)
        .add("partition", partition)
        .add("currentOffset", currentOffset)
        .add("lag", lag)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link GroupInfo} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GroupInfo instance
   */
  public static ImmutableGroupInfo copyOf(GroupInfo instance) {
    if (instance instanceof ImmutableGroupInfo) {
      return (ImmutableGroupInfo) instance;
    }
    return new ImmutableGroupInfo.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableGroupInfo ImmutableGroupInfo}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GroupInfo", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_GROUP_ID = 0x1L;
    private static final long INIT_BIT_PARTITION = 0x2L;
    private static final long INIT_BIT_CURRENT_OFFSET = 0x4L;
    private static final long INIT_BIT_LAG = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String groupId;
    private int partition;
    private long currentOffset;
    private long lag;

    /**
     * Creates a builder for {@link ImmutableGroupInfo ImmutableGroupInfo} instances.
     * <pre>
     * new ImmutableGroupInfo.Builder()
     *    .groupId(String) // required {@link GroupInfo#groupId() groupId}
     *    .partition(int) // required {@link GroupInfo#partition() partition}
     *    .currentOffset(long) // required {@link GroupInfo#currentOffset() currentOffset}
     *    .lag(long) // required {@link GroupInfo#lag() lag}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GroupInfo} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(GroupInfo instance) {
      Objects.requireNonNull(instance, "instance");
      groupId(instance.groupId());
      partition(instance.partition());
      currentOffset(instance.currentOffset());
      lag(instance.lag());
      return this;
    }

    /**
     * Initializes the value for the {@link GroupInfo#groupId() groupId} attribute.
     * @param groupId The value for groupId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("groupId")
    public final Builder groupId(String groupId) {
      this.groupId = Objects.requireNonNull(groupId, "groupId");
      initBits &= ~INIT_BIT_GROUP_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link GroupInfo#partition() partition} attribute.
     * @param partition The value for partition 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("partition")
    public final Builder partition(int partition) {
      this.partition = partition;
      initBits &= ~INIT_BIT_PARTITION;
      return this;
    }

    /**
     * Initializes the value for the {@link GroupInfo#currentOffset() currentOffset} attribute.
     * @param currentOffset The value for currentOffset 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("currentOffset")
    public final Builder currentOffset(long currentOffset) {
      this.currentOffset = currentOffset;
      initBits &= ~INIT_BIT_CURRENT_OFFSET;
      return this;
    }

    /**
     * Initializes the value for the {@link GroupInfo#lag() lag} attribute.
     * @param lag The value for lag 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("lag")
    public final Builder lag(long lag) {
      this.lag = lag;
      initBits &= ~INIT_BIT_LAG;
      return this;
    }

    /**
     * Builds a new {@link ImmutableGroupInfo ImmutableGroupInfo}.
     * @return An immutable instance of GroupInfo
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGroupInfo build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableGroupInfo(groupId, partition, currentOffset, lag);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_GROUP_ID) != 0) attributes.add("groupId");
      if ((initBits & INIT_BIT_PARTITION) != 0) attributes.add("partition");
      if ((initBits & INIT_BIT_CURRENT_OFFSET) != 0) attributes.add("currentOffset");
      if ((initBits & INIT_BIT_LAG) != 0) attributes.add("lag");
      return "Cannot build GroupInfo, some of required attributes are not set " + attributes;
    }
  }
}
