package org.jresearch.gavka.rest.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jresearch.commons.gwt.shared.model.time.GwtLocalDateTimeModel;
import org.jresearch.gavka.domain.KeyFormat;
import org.jresearch.gavka.domain.MessageFormat;

/**
 * Immutable implementation of {@link MessageParameters}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableMessageParameters.Builder()}.
 */
@Generated(from = "MessageParameters", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableMessageParameters implements MessageParameters {
  private final String connection;
  private final String topic;
  private final String key;
  private final String valuePattern;
  private final @Nullable GwtLocalDateTimeModel from;
  private final KeyFormat keyFormat;
  private final MessageFormat messageFormat;

  private ImmutableMessageParameters(
      String connection,
      String topic,
      String key,
      String valuePattern,
      @Nullable GwtLocalDateTimeModel from,
      KeyFormat keyFormat,
      MessageFormat messageFormat) {
    this.connection = connection;
    this.topic = topic;
    this.key = key;
    this.valuePattern = valuePattern;
    this.from = from;
    this.keyFormat = keyFormat;
    this.messageFormat = messageFormat;
  }

  /**
   * @return The value of the {@code connection} attribute
   */
  @JsonProperty("connection")
  @Override
  public String connection() {
    return connection;
  }

  /**
   * @return The value of the {@code topic} attribute
   */
  @JsonProperty("topic")
  @Override
  public String topic() {
    return topic;
  }

  /**
   * @return The value of the {@code key} attribute
   */
  @JsonProperty("key")
  @Override
  public String key() {
    return key;
  }

  /**
   * @return The value of the {@code valuePattern} attribute
   */
  @JsonProperty("valuePattern")
  @Override
  public String valuePattern() {
    return valuePattern;
  }

  /**
   * @return The value of the {@code from} attribute
   */
  @JsonProperty("from")
  @Override
  public Optional<GwtLocalDateTimeModel> from() {
    return Optional.ofNullable(from);
  }

  /**
   * @return The value of the {@code keyFormat} attribute
   */
  @JsonProperty("keyFormat")
  @Override
  public KeyFormat keyFormat() {
    return keyFormat;
  }

  /**
   * @return The value of the {@code messageFormat} attribute
   */
  @JsonProperty("messageFormat")
  @Override
  public MessageFormat messageFormat() {
    return messageFormat;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageParameters#connection() connection} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for connection
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessageParameters withConnection(String value) {
    String newValue = Objects.requireNonNull(value, "connection");
    if (this.connection.equals(newValue)) return this;
    return new ImmutableMessageParameters(
        newValue,
        this.topic,
        this.key,
        this.valuePattern,
        this.from,
        this.keyFormat,
        this.messageFormat);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageParameters#topic() topic} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for topic
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessageParameters withTopic(String value) {
    String newValue = Objects.requireNonNull(value, "topic");
    if (this.topic.equals(newValue)) return this;
    return new ImmutableMessageParameters(
        this.connection,
        newValue,
        this.key,
        this.valuePattern,
        this.from,
        this.keyFormat,
        this.messageFormat);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageParameters#key() key} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for key
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessageParameters withKey(String value) {
    String newValue = Objects.requireNonNull(value, "key");
    if (this.key.equals(newValue)) return this;
    return new ImmutableMessageParameters(
        this.connection,
        this.topic,
        newValue,
        this.valuePattern,
        this.from,
        this.keyFormat,
        this.messageFormat);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageParameters#valuePattern() valuePattern} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valuePattern
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessageParameters withValuePattern(String value) {
    String newValue = Objects.requireNonNull(value, "valuePattern");
    if (this.valuePattern.equals(newValue)) return this;
    return new ImmutableMessageParameters(this.connection, this.topic, this.key, newValue, this.from, this.keyFormat, this.messageFormat);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MessageParameters#from() from} attribute.
   * @param value The value for from
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMessageParameters withFrom(GwtLocalDateTimeModel value) {
    @Nullable GwtLocalDateTimeModel newValue = Objects.requireNonNull(value, "from");
    if (this.from == newValue) return this;
    return new ImmutableMessageParameters(
        this.connection,
        this.topic,
        this.key,
        this.valuePattern,
        newValue,
        this.keyFormat,
        this.messageFormat);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MessageParameters#from() from} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for from
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableMessageParameters withFrom(Optional<? extends GwtLocalDateTimeModel> optional) {
    @Nullable GwtLocalDateTimeModel value = optional.orElse(null);
    if (this.from == value) return this;
    return new ImmutableMessageParameters(
        this.connection,
        this.topic,
        this.key,
        this.valuePattern,
        value,
        this.keyFormat,
        this.messageFormat);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageParameters#keyFormat() keyFormat} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for keyFormat
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessageParameters withKeyFormat(KeyFormat value) {
    if (this.keyFormat == value) return this;
    KeyFormat newValue = Objects.requireNonNull(value, "keyFormat");
    if (this.keyFormat.equals(newValue)) return this;
    return new ImmutableMessageParameters(
        this.connection,
        this.topic,
        this.key,
        this.valuePattern,
        this.from,
        newValue,
        this.messageFormat);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageParameters#messageFormat() messageFormat} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for messageFormat
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMessageParameters withMessageFormat(MessageFormat value) {
    if (this.messageFormat == value) return this;
    MessageFormat newValue = Objects.requireNonNull(value, "messageFormat");
    if (this.messageFormat.equals(newValue)) return this;
    return new ImmutableMessageParameters(this.connection, this.topic, this.key, this.valuePattern, this.from, this.keyFormat, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMessageParameters} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMessageParameters
        && equalTo((ImmutableMessageParameters) another);
  }

  private boolean equalTo(ImmutableMessageParameters another) {
    return connection.equals(another.connection)
        && topic.equals(another.topic)
        && key.equals(another.key)
        && valuePattern.equals(another.valuePattern)
        && Objects.equals(from, another.from)
        && keyFormat.equals(another.keyFormat)
        && messageFormat.equals(another.messageFormat);
  }

  /**
   * Computes a hash code from attributes: {@code connection}, {@code topic}, {@code key}, {@code valuePattern}, {@code from}, {@code keyFormat}, {@code messageFormat}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + connection.hashCode();
    h += (h << 5) + topic.hashCode();
    h += (h << 5) + key.hashCode();
    h += (h << 5) + valuePattern.hashCode();
    h += (h << 5) + Objects.hashCode(from);
    h += (h << 5) + keyFormat.hashCode();
    h += (h << 5) + messageFormat.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MessageParameters} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("MessageParameters")
        .omitNullValues()
        .add("connection", connection)
        .add("topic", topic)
        .add("key", key)
        .add("valuePattern", valuePattern)
        .add("from", from)
        .add("keyFormat", keyFormat)
        .add("messageFormat", messageFormat)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link MessageParameters} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MessageParameters instance
   */
  public static ImmutableMessageParameters copyOf(MessageParameters instance) {
    if (instance instanceof ImmutableMessageParameters) {
      return (ImmutableMessageParameters) instance;
    }
    return new ImmutableMessageParameters.Builder()
        .connection(instance.connection())
        .topic(instance.topic())
        .key(instance.key())
        .valuePattern(instance.valuePattern())
        .from(instance.from())
        .keyFormat(instance.keyFormat())
        .messageFormat(instance.messageFormat())
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableMessageParameters ImmutableMessageParameters}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MessageParameters", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CONNECTION = 0x1L;
    private static final long INIT_BIT_TOPIC = 0x2L;
    private static final long INIT_BIT_KEY = 0x4L;
    private static final long INIT_BIT_VALUE_PATTERN = 0x8L;
    private static final long INIT_BIT_KEY_FORMAT = 0x10L;
    private static final long INIT_BIT_MESSAGE_FORMAT = 0x20L;
    private long initBits = 0x3fL;

    private @Nullable String connection;
    private @Nullable String topic;
    private @Nullable String key;
    private @Nullable String valuePattern;
    private @Nullable GwtLocalDateTimeModel from;
    private @Nullable KeyFormat keyFormat;
    private @Nullable MessageFormat messageFormat;

    /**
     * Creates a builder for {@link ImmutableMessageParameters ImmutableMessageParameters} instances.
     * <pre>
     * new ImmutableMessageParameters.Builder()
     *    .connection(String) // required {@link MessageParameters#connection() connection}
     *    .topic(String) // required {@link MessageParameters#topic() topic}
     *    .key(String) // required {@link MessageParameters#key() key}
     *    .valuePattern(String) // required {@link MessageParameters#valuePattern() valuePattern}
     *    .from(org.jresearch.commons.gwt.shared.model.time.GwtLocalDateTimeModel) // optional {@link MessageParameters#from() from}
     *    .keyFormat(org.jresearch.gavka.domain.KeyFormat) // required {@link MessageParameters#keyFormat() keyFormat}
     *    .messageFormat(org.jresearch.gavka.domain.MessageFormat) // required {@link MessageParameters#messageFormat() messageFormat}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Initializes the value for the {@link MessageParameters#connection() connection} attribute.
     * @param connection The value for connection 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("connection")
    public final Builder connection(String connection) {
      this.connection = Objects.requireNonNull(connection, "connection");
      initBits &= ~INIT_BIT_CONNECTION;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageParameters#topic() topic} attribute.
     * @param topic The value for topic 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("topic")
    public final Builder topic(String topic) {
      this.topic = Objects.requireNonNull(topic, "topic");
      initBits &= ~INIT_BIT_TOPIC;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageParameters#key() key} attribute.
     * @param key The value for key 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("key")
    public final Builder key(String key) {
      this.key = Objects.requireNonNull(key, "key");
      initBits &= ~INIT_BIT_KEY;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageParameters#valuePattern() valuePattern} attribute.
     * @param valuePattern The value for valuePattern 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("valuePattern")
    public final Builder valuePattern(String valuePattern) {
      this.valuePattern = Objects.requireNonNull(valuePattern, "valuePattern");
      initBits &= ~INIT_BIT_VALUE_PATTERN;
      return this;
    }

    /**
     * Initializes the optional value {@link MessageParameters#from() from} to from.
     * @param from The value for from
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(GwtLocalDateTimeModel from) {
      this.from = Objects.requireNonNull(from, "from");
      return this;
    }

    /**
     * Initializes the optional value {@link MessageParameters#from() from} to from.
     * @param from The value for from
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("from")
    public final Builder from(Optional<? extends GwtLocalDateTimeModel> from) {
      this.from = from.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link MessageParameters#keyFormat() keyFormat} attribute.
     * @param keyFormat The value for keyFormat 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("keyFormat")
    public final Builder keyFormat(KeyFormat keyFormat) {
      this.keyFormat = Objects.requireNonNull(keyFormat, "keyFormat");
      initBits &= ~INIT_BIT_KEY_FORMAT;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageParameters#messageFormat() messageFormat} attribute.
     * @param messageFormat The value for messageFormat 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("messageFormat")
    public final Builder messageFormat(MessageFormat messageFormat) {
      this.messageFormat = Objects.requireNonNull(messageFormat, "messageFormat");
      initBits &= ~INIT_BIT_MESSAGE_FORMAT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMessageParameters ImmutableMessageParameters}.
     * @return An immutable instance of MessageParameters
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMessageParameters build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMessageParameters(connection, topic, key, valuePattern, from, keyFormat, messageFormat);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CONNECTION) != 0) attributes.add("connection");
      if ((initBits & INIT_BIT_TOPIC) != 0) attributes.add("topic");
      if ((initBits & INIT_BIT_KEY) != 0) attributes.add("key");
      if ((initBits & INIT_BIT_VALUE_PATTERN) != 0) attributes.add("valuePattern");
      if ((initBits & INIT_BIT_KEY_FORMAT) != 0) attributes.add("keyFormat");
      if ((initBits & INIT_BIT_MESSAGE_FORMAT) != 0) attributes.add("messageFormat");
      return "Cannot build MessageParameters, some of required attributes are not set " + attributes;
    }
  }
}
