package org.jresearch.gavka.rest.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link GafkaCoordinates}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ImmutableGafkaCoordinates.Builder()}.
 */
@Generated(from = "GafkaCoordinates", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableGafkaCoordinates implements GafkaCoordinates {
  private final String connectionId;
  private final String topic;

  private ImmutableGafkaCoordinates(String connectionId, String topic) {
    this.connectionId = connectionId;
    this.topic = topic;
  }

  /**
   * @return The value of the {@code connectionId} attribute
   */
  @JsonProperty("connectionId")
  @Override
  public String connectionId() {
    return connectionId;
  }

  /**
   * @return The value of the {@code topic} attribute
   */
  @JsonProperty("topic")
  @Override
  public String topic() {
    return topic;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GafkaCoordinates#connectionId() connectionId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for connectionId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGafkaCoordinates withConnectionId(String value) {
    String newValue = Objects.requireNonNull(value, "connectionId");
    if (this.connectionId.equals(newValue)) return this;
    return new ImmutableGafkaCoordinates(newValue, this.topic);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GafkaCoordinates#topic() topic} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for topic
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGafkaCoordinates withTopic(String value) {
    String newValue = Objects.requireNonNull(value, "topic");
    if (this.topic.equals(newValue)) return this;
    return new ImmutableGafkaCoordinates(this.connectionId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGafkaCoordinates} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGafkaCoordinates
        && equalTo((ImmutableGafkaCoordinates) another);
  }

  private boolean equalTo(ImmutableGafkaCoordinates another) {
    return connectionId.equals(another.connectionId)
        && topic.equals(another.topic);
  }

  /**
   * Computes a hash code from attributes: {@code connectionId}, {@code topic}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + connectionId.hashCode();
    h += (h << 5) + topic.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GafkaCoordinates} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("GafkaCoordinates")
        .omitNullValues()
        .add("connectionId", connectionId)
        .add("topic", topic)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link GafkaCoordinates} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GafkaCoordinates instance
   */
  public static ImmutableGafkaCoordinates copyOf(GafkaCoordinates instance) {
    if (instance instanceof ImmutableGafkaCoordinates) {
      return (ImmutableGafkaCoordinates) instance;
    }
    return new ImmutableGafkaCoordinates.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableGafkaCoordinates ImmutableGafkaCoordinates}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GafkaCoordinates", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CONNECTION_ID = 0x1L;
    private static final long INIT_BIT_TOPIC = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String connectionId;
    private @Nullable String topic;

    /**
     * Creates a builder for {@link ImmutableGafkaCoordinates ImmutableGafkaCoordinates} instances.
     * <pre>
     * new ImmutableGafkaCoordinates.Builder()
     *    .connectionId(String) // required {@link GafkaCoordinates#connectionId() connectionId}
     *    .topic(String) // required {@link GafkaCoordinates#topic() topic}
     *    .build();
     * </pre>
     */
    public Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GafkaCoordinates} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(GafkaCoordinates instance) {
      Objects.requireNonNull(instance, "instance");
      connectionId(instance.connectionId());
      topic(instance.topic());
      return this;
    }

    /**
     * Initializes the value for the {@link GafkaCoordinates#connectionId() connectionId} attribute.
     * @param connectionId The value for connectionId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("connectionId")
    public final Builder connectionId(String connectionId) {
      this.connectionId = Objects.requireNonNull(connectionId, "connectionId");
      initBits &= ~INIT_BIT_CONNECTION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link GafkaCoordinates#topic() topic} attribute.
     * @param topic The value for topic 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("topic")
    public final Builder topic(String topic) {
      this.topic = Objects.requireNonNull(topic, "topic");
      initBits &= ~INIT_BIT_TOPIC;
      return this;
    }

    /**
     * Builds a new {@link ImmutableGafkaCoordinates ImmutableGafkaCoordinates}.
     * @return An immutable instance of GafkaCoordinates
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGafkaCoordinates build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableGafkaCoordinates(connectionId, topic);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CONNECTION_ID) != 0) attributes.add("connectionId");
      if ((initBits & INIT_BIT_TOPIC) != 0) attributes.add("topic");
      return "Cannot build GafkaCoordinates, some of required attributes are not set " + attributes;
    }
  }
}
