/*
 * Decompiled with CFR 0.152.
 */
package org.gwtproject.editor.processor;

import com.google.auto.common.BasicAnnotationProcessor;
import com.google.auto.common.MoreTypes;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.StringJoiner;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.gwtproject.editor.client.Editor;
import org.gwtproject.editor.client.EditorVisitor;
import org.gwtproject.editor.client.SimpleBeanEditorDriver;
import org.gwtproject.editor.client.annotation.IsDriver;
import org.gwtproject.editor.client.impl.AbstractEditorContext;
import org.gwtproject.editor.client.impl.AbstractSimpleBeanEditorDriver;
import org.gwtproject.editor.client.impl.RootEditorContext;
import org.gwtproject.editor.client.impl.SimpleBeanEditorDelegate;
import org.gwtproject.editor.processor.NameFactory;
import org.gwtproject.editor.processor.model.EditorModel;
import org.gwtproject.editor.processor.model.EditorProperty;
import org.gwtproject.editor.processor.model.EditorTypes;

public class DriverProcessingStep
implements BasicAnnotationProcessor.ProcessingStep {
    private final Messager messager;
    private final Filer filer;
    private final Types types;
    private final Elements elements;

    private DriverProcessingStep(Messager messager, Filer filer, Types types, Elements elements) {
        this.messager = messager;
        this.filer = filer;
        this.types = types;
        this.elements = elements;
    }

    public Set<? extends Class<? extends Annotation>> annotations() {
        return Collections.singleton(IsDriver.class);
    }

    public Set<Element> process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        for (Element element : elementsByAnnotation.get(IsDriver.class)) {
            EditorModel root = new EditorModel(this.messager, new EditorTypes(this.types, this.elements), element.asType(), this.types.erasure(this.elements.getTypeElement(this.getDriverInterfaceType().toString()).asType()));
            try {
                this.generateDriver((TypeElement)element, root);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return ImmutableSet.of();
    }

    private void generateDriver(TypeElement interfaceToImplement, EditorModel rootEditorModel) throws IOException {
        String pkgName = this.elements.getPackageOf(interfaceToImplement).getQualifiedName().toString();
        String typeName = this.createNameFromEnclosedTypes(interfaceToImplement, "_Impl");
        ParameterizedTypeName rootEdContextType = ParameterizedTypeName.get((ClassName)ClassName.get(RootEditorContext.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)rootEditorModel.getProxyType())});
        MethodSpec accept = MethodSpec.methodBuilder((String)"accept").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Void.TYPE).addAnnotation(Override.class).addParameter(EditorVisitor.class, "visitor", new Modifier[0]).addStatement("$T ctx = new $T(getDelegate(), (Class<$T>)(Class)$L.class, getObject())", new Object[]{rootEdContextType, rootEdContextType, TypeName.get((TypeMirror)rootEditorModel.getProxyType()), MoreTypes.asElement((TypeMirror)rootEditorModel.getProxyType())}).addStatement("ctx.traverse(visitor, getDelegate())", new Object[0]).build();
        ParameterizedTypeName delegateType = ParameterizedTypeName.get((ClassName)this.getEditorDelegateType(), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)rootEditorModel.getProxyType()), TypeName.get((TypeMirror)rootEditorModel.getEditorType())});
        MethodSpec createDelegate = MethodSpec.methodBuilder((String)"createDelegate").addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)delegateType).addAnnotation(Override.class).addStatement("return new $T()", new Object[]{this.getEditorDelegate(rootEditorModel, rootEditorModel.getRootData())}).build();
        TypeSpec driverType = TypeSpec.classBuilder((String)typeName).addOriginatingElement((Element)interfaceToImplement).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface(TypeName.get((TypeMirror)interfaceToImplement.asType())).superclass((TypeName)ParameterizedTypeName.get((ClassName)this.getDriverSuperclassType(), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)rootEditorModel.getProxyType()), TypeName.get((TypeMirror)rootEditorModel.getEditorType())})).addMethod(accept).addMethod(createDelegate).build();
        JavaFile driverFile = JavaFile.builder((String)pkgName, (TypeSpec)driverType).build();
        driverFile.writeTo(this.filer);
    }

    private ClassName getEditorDelegate(EditorModel editorModel, EditorProperty data) throws IOException {
        String delegateSimpleName = this.escapedMaybeParameterizedBinaryName(data.getEditorType()) + "_" + this.getEditorDelegateType().simpleName();
        String packageName = this.elements.getPackageOf(this.types.asElement(data.getEditorType())).getQualifiedName().toString();
        try {
            TypeName rawEditorType = ClassName.get((TypeMirror)this.types.erasure(data.getEditorType()));
            TypeSpec.Builder delegateTypeBuilder = TypeSpec.classBuilder((String)delegateSimpleName).addOriginatingElement(this.types.asElement(data.getEditedType())).addOriginatingElement(this.types.asElement(data.getEditorType())).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass((TypeName)this.getEditorDelegateType());
            NameFactory names = new NameFactory();
            IdentityHashMap<EditorProperty, String> delegateFields = new IdentityHashMap<EditorProperty, String>();
            delegateTypeBuilder.addField(FieldSpec.builder((TypeName)rawEditorType, (String)"editor", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
            names.addName("editor");
            delegateTypeBuilder.addField(FieldSpec.builder((TypeName)ClassName.get((TypeMirror)data.getEditedType()), (String)"object", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build());
            names.addName("object");
            for (EditorProperty editorProperty : editorModel.getEditorData(data.getEditorType())) {
                if (!editorProperty.isDelegateRequired()) continue;
                String string = names.createName(editorProperty.getPropertyName() + "Delegate");
                delegateFields.put(editorProperty, string);
                delegateTypeBuilder.addField((TypeName)this.getEditorDelegateType(), string, new Modifier[]{Modifier.PRIVATE});
            }
            delegateTypeBuilder.addMethod(MethodSpec.methodBuilder((String)"getEditor").addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(rawEditorType).addAnnotation(Override.class).addStatement("return editor", new Object[0]).build());
            delegateTypeBuilder.addMethod(MethodSpec.methodBuilder((String)"setEditor").addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(Void.TYPE).addAnnotation(Override.class).addParameter(Editor.class, "editor", new Modifier[0]).addStatement("this.editor = ($T) editor", new Object[]{rawEditorType}).build());
            delegateTypeBuilder.addMethod(MethodSpec.methodBuilder((String)"getObject").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(ClassName.get((TypeMirror)data.getEditedType())).addAnnotation(Override.class).addStatement("return object", new Object[0]).build());
            delegateTypeBuilder.addMethod(MethodSpec.methodBuilder((String)"setObject").addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(Void.TYPE).addAnnotation(Override.class).addParameter((TypeName)ClassName.get(Object.class), "object", new Modifier[0]).addStatement("this.object = ($T) object", new Object[]{ClassName.get((TypeMirror)data.getEditedType())}).build());
            MethodSpec.Builder initializeSubDelegatesBuilder = MethodSpec.methodBuilder((String)"initializeSubDelegates").addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(Void.TYPE).addAnnotation(Override.class);
            if (data.isCompositeEditor()) {
                initializeSubDelegatesBuilder.addStatement("createChain($L.class)", new Object[]{MoreTypes.asElement((TypeMirror)data.getComposedData().getEditedType())});
            }
            for (EditorProperty editorProperty : editorModel.getEditorData(data.getEditorType())) {
                ClassName subDelegateType = this.getEditorDelegate(editorModel, editorProperty);
                if (!editorProperty.isDelegateRequired()) continue;
                initializeSubDelegatesBuilder.beginControlFlow("if (editor.$L != null)", new Object[]{editorProperty.getSimpleExpression()}).addStatement("$L = new $T()", new Object[]{delegateFields.get(editorProperty), subDelegateType}).addStatement("addSubDelegate($L, appendPath(\"$L\"), editor.$L)", new Object[]{delegateFields.get(editorProperty), editorProperty.getDeclaredPath(), editorProperty.getSimpleExpression()}).endControlFlow();
            }
            delegateTypeBuilder.addMethod(initializeSubDelegatesBuilder.build());
            MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"accept").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Void.TYPE).addAnnotation(Override.class).addParameter(EditorVisitor.class, "visitor", new Modifier[0]);
            if (data.isCompositeEditor()) {
                builder.addStatement("getEditorChain().accept(visitor)", new Object[0]);
            }
            for (EditorProperty d : editorModel.getEditorData(data.getEditorType())) {
                if (d.isDelegateRequired()) {
                    builder.beginControlFlow("if ($L != null)", new Object[]{delegateFields.get(d)});
                } else {
                    builder.beginControlFlow("", new Object[0]);
                }
                ClassName editorContextName = this.getEditorContext(data, d);
                builder.addStatement("$T ctx = new $T(getObject(), editor.$L, appendPath(\"$L\"))", new Object[]{editorContextName, editorContextName, d.getSimpleExpression(), d.getDeclaredPath()});
                if (d.isDelegateRequired()) {
                    builder.addStatement("ctx.setEditorDelegate($L)", new Object[]{delegateFields.get(d)});
                    builder.addStatement("ctx.traverse(visitor, $L)", new Object[]{delegateFields.get(d)});
                } else {
                    builder.addStatement("ctx.traverse(visitor, null)", new Object[0]);
                }
                builder.endControlFlow();
            }
            delegateTypeBuilder.addMethod(builder.build());
            if (data.isCompositeEditor()) {
                ClassName className = this.getEditorDelegate(editorModel, data.getComposedData());
                delegateTypeBuilder.addMethod(MethodSpec.methodBuilder((String)"createComposedDelegate").addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)className).addAnnotation(Override.class).addStatement("return new $T()", new Object[]{className}).build());
            }
            JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)delegateTypeBuilder.build()).build();
            javaFile.writeTo(this.filer);
        }
        catch (FilerException filerException) {
            // empty catch block
        }
        return ClassName.get((String)packageName, (String)delegateSimpleName, (String[])new String[0]);
    }

    private ClassName getEditorContext(EditorProperty parent, EditorProperty data) throws IOException {
        String contextSimpleName = this.escapedMaybeParameterizedBinaryName(parent.getEditorType()) + "_" + data.getDeclaredPath().replace("_", "_1").replace(".", "_") + "_Context";
        String packageName = this.elements.getPackageOf(this.types.asElement(parent.getEditorType())).getQualifiedName().toString();
        try {
            TypeSpec.Builder contextTypeBuilder = TypeSpec.classBuilder((String)contextSimpleName).addOriginatingElement(this.types.asElement(parent.getEditorType())).addOriginatingElement(this.types.asElement(parent.getEditedType())).addOriginatingElement(this.types.asElement(data.getEditedType())).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(AbstractEditorContext.class), (TypeName[])new TypeName[]{ClassName.get((TypeMirror)data.getEditedType())}));
            contextTypeBuilder.addField(ClassName.get((TypeMirror)parent.getEditedType()), "parent", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
            contextTypeBuilder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ClassName.get((TypeMirror)parent.getEditedType()), "parent", new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Editor.class), (TypeName[])new TypeName[]{ClassName.get((TypeMirror)data.getEditedType())}), "editor", new Modifier[0]).addParameter(String.class, "path", new Modifier[0]).addStatement("super(editor, path)", new Object[0]).addStatement("this.parent = parent", new Object[0]).build());
            contextTypeBuilder.addMethod(MethodSpec.methodBuilder((String)"canSetInModel").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(Boolean.TYPE).addStatement("return parent != null && $L && $L", new Object[]{data.getSetterName() == null ? "false" : "true", data.getBeanOwnerGuard("parent")}).build());
            contextTypeBuilder.addMethod(MethodSpec.methodBuilder((String)"checkAssignment").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(ClassName.get((TypeMirror)data.getEditedType())).addParameter(Object.class, "value", new Modifier[0]).addStatement("return ($T) value", new Object[]{ClassName.get((TypeMirror)data.getEditedType())}).build());
            contextTypeBuilder.addMethod(MethodSpec.methodBuilder((String)"getEditedType").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(Class.class).addStatement("return $L.class", new Object[]{MoreTypes.asElement((TypeMirror)data.getEditedType())}).build());
            contextTypeBuilder.addMethod(MethodSpec.methodBuilder((String)"getFromModel").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(ClassName.get((TypeMirror)data.getEditedType())).addStatement("return (parent != null && $L) ? parent$L$L : null", new Object[]{data.getBeanOwnerGuard("parent"), data.getBeanOwnerExpression(), data.getGetterExpression()}).build());
            MethodSpec.Builder setInModelMethodBuilder = MethodSpec.methodBuilder((String)"setInModel").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(Void.TYPE).addParameter(ClassName.get((TypeMirror)data.getEditedType()), "data", new Modifier[0]);
            if (data.getSetterName() == null) {
                setInModelMethodBuilder.addStatement("throw new UnsupportedOperationException()", new Object[0]);
            } else {
                setInModelMethodBuilder.addStatement("parent$L.$L(data)", new Object[]{data.getBeanOwnerExpression(), data.getSetterName()});
            }
            contextTypeBuilder.addMethod(setInModelMethodBuilder.build());
            JavaFile contextFile = JavaFile.builder((String)packageName, (TypeSpec)contextTypeBuilder.build()).build();
            contextFile.writeTo(this.filer);
        }
        catch (FilerException filerException) {
            // empty catch block
        }
        return ClassName.get((String)packageName, (String)contextSimpleName, (String[])new String[0]);
    }

    protected ClassName getDriverInterfaceType() {
        return ClassName.get(SimpleBeanEditorDriver.class);
    }

    protected ClassName getDriverSuperclassType() {
        return ClassName.get(AbstractSimpleBeanEditorDriver.class);
    }

    protected ClassName getEditorDelegateType() {
        return ClassName.get(SimpleBeanEditorDelegate.class);
    }

    private String escapedMaybeParameterizedBinaryName(TypeMirror editor) {
        StringBuilder maybeParameterizedName = new StringBuilder(this.createNameFromEnclosedTypes(MoreTypes.asTypeElement((TypeMirror)editor), null));
        for (TypeMirror typeMirror : MoreTypes.asDeclared((TypeMirror)editor).getTypeArguments()) {
            maybeParameterizedName.append("$").append(this.escapedMaybeParameterizedBinaryName(typeMirror));
        }
        return this.escapedBinaryName(maybeParameterizedName.toString());
    }

    private String escapedBinaryName(String binaryName) {
        return binaryName.replace("_", "_1").replace('$', '_').replace('.', '_');
    }

    private String createNameFromEnclosedTypes(TypeElement interfaceToImplement, String suffix) {
        StringJoiner joiner = new StringJoiner("_", "", suffix == null ? "" : suffix);
        ClassName.get((TypeElement)interfaceToImplement).simpleNames().forEach(joiner::add);
        return joiner.toString();
    }

    public static class Builder {
        private Messager messager;
        private Filer filer;
        private Types types;
        private Elements elements;

        public Builder setMessager(Messager messager) {
            this.messager = messager;
            return this;
        }

        public Builder setFiler(Filer filer) {
            this.filer = filer;
            return this;
        }

        public Builder setTypes(Types types) {
            this.types = types;
            return this;
        }

        public Builder setElements(Elements elements) {
            this.elements = elements;
            return this;
        }

        public DriverProcessingStep build() {
            return new DriverProcessingStep(this.messager, this.filer, this.types, this.elements);
        }
    }
}

