/*
 * Decompiled with CFR 0.152.
 */
package org.gwtproject.editor.processor;

import com.google.auto.common.MoreTypes;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

public class ModelUtils {
    private static Set<String> VALUE_TYPE_NAMES = Sets.newHashSet((Object[])new String[]{BigDecimal.class.getName(), BigInteger.class.getName(), Boolean.class.getName(), Byte.class.getName(), Character.class.getName(), Double.class.getName(), Enum.class.getName(), Float.class.getName(), Integer.class.getName(), Long.class.getName(), Short.class.getName(), String.class.getName(), Void.class.getName()});

    public static List<? extends TypeMirror> findParameterizationOf(Types types, TypeMirror intfType, TypeMirror subType) {
        for (TypeMirror supertype : ModelUtils.getFlattenedSupertypeHierarchy(types, subType)) {
            if (!(supertype instanceof DeclaredType)) continue;
            DeclaredType parameterized = (DeclaredType)supertype;
            if (!MoreTypes.asElement((TypeMirror)intfType).equals(parameterized.asElement())) continue;
            return new ArrayList<TypeMirror>(parameterized.getTypeArguments());
        }
        return null;
    }

    public static boolean isValueType(TypeMirror type) {
        if (type.getKind().isPrimitive()) {
            return true;
        }
        if (MoreTypes.asElement((TypeMirror)type).getKind() == ElementKind.ENUM) {
            return true;
        }
        return VALUE_TYPE_NAMES.contains(type.toString());
    }

    public static Set<TypeMirror> getFlattenedSupertypeHierarchy(Types types, TypeMirror t) {
        ArrayList<? extends TypeMirror> toAdd = new ArrayList<TypeMirror>();
        LinkedHashSet<TypeMirror> result = new LinkedHashSet<TypeMirror>();
        toAdd.add(t);
        for (int i = 0; i < toAdd.size(); ++i) {
            TypeMirror type = (TypeMirror)toAdd.get(i);
            if (!result.add(type)) continue;
            toAdd.addAll(types.directSupertypes(type));
        }
        return result;
    }
}

